/*
 * Decompiled with CFR 0.152.
 */
package xyz.ressor.source.git.builder;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.util.FS;
import xyz.ressor.source.git.GitRef;
import xyz.ressor.source.git.GitSource;
import xyz.ressor.source.git.RefType;

public abstract class RepositoryBuilderBase<T extends RepositoryBuilderBase> {
    protected String ref = "master";
    protected RefType refType;
    protected String repositoryDirectory;
    protected String privateKeyPath;
    protected String privateKeyPassphrase;
    protected String filePath;
    protected boolean asyncPull = false;

    public T refValue(String ref) {
        this.ref = ref;
        return (T)this;
    }

    public T refValue(String ref, RefType refType) {
        this.ref = ref;
        this.refType = refType;
        return (T)this;
    }

    public T repositoryDirectory(String repositoryDirectory) {
        this.repositoryDirectory = repositoryDirectory;
        return (T)this;
    }

    public T privateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return (T)this;
    }

    public T privateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
        return (T)this;
    }

    public T filePath(String filePath) {
        this.filePath = filePath;
        return (T)this;
    }

    public T asyncPull(boolean asyncPull) {
        this.asyncPull = asyncPull;
        return (T)this;
    }

    protected GitRef ref() {
        return this.refType == null ? new GitRef(this.ref) : new GitRef(this.ref, this.refType);
    }

    protected TransportConfigCallback createTransportConfig() {
        return this.privateKeyPath == null ? GitSource.EMPTY_TRANSPORT_CONFIG : transport -> {
            SshTransport ssh = (SshTransport)transport;
            ssh.setSshSessionFactory((SshSessionFactory)new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host hc, Session session) {
                    session.setConfig("StrictHostKeyChecking", "no");
                }

                protected JSch createDefaultJSch(FS fs) throws JSchException {
                    JSch jSch = super.createDefaultJSch(fs);
                    jSch.addIdentity(RepositoryBuilderBase.this.privateKeyPath, RepositoryBuilderBase.this.privateKeyPassphrase);
                    return jSch;
                }
            });
        };
    }
}

