/*
 * Decompiled with CFR 0.152.
 */
package xyz.ressor.source.git.builder;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import xyz.ressor.commons.utils.Exceptions;
import xyz.ressor.source.git.GitSource;
import xyz.ressor.source.git.builder.RepositoryBuilderBase;

public class RemoteRepositoryBuilder
extends RepositoryBuilderBase<RemoteRepositoryBuilder> {
    protected String repositoryURI;
    protected boolean bare = true;

    public RemoteRepositoryBuilder repositoryURI(String repositoryURI) {
        this.repositoryURI = repositoryURI;
        return this;
    }

    public RemoteRepositoryBuilder bare(boolean bare) {
        this.bare = bare;
        return this;
    }

    public GitSource build() {
        if (this.repositoryURI == null) {
            throw new IllegalArgumentException("Repository URI can't be empty");
        }
        if (this.filePath == null) {
            throw new IllegalArgumentException("No target file path is provided for this repository");
        }
        try {
            if (this.repositoryDirectory == null) {
                this.repositoryDirectory = Files.createTempDirectory("git_source", new FileAttribute[0]).toFile().getAbsolutePath();
            }
            TransportConfigCallback transportConfig = this.createTransportConfig();
            return new GitSource(((CloneCommand)Git.cloneRepository().setURI(this.repositoryURI).setBranch(this.ref).setBare(this.bare).setDirectory(new File(this.repositoryDirectory)).setTransportConfigCallback(transportConfig)).call(), transportConfig, this.filePath, this.ref(), this.asyncPull);
        }
        catch (Throwable t) {
            throw Exceptions.wrap((Throwable)t);
        }
    }
}

