/*
 * Decompiled with CFR 0.152.
 */
package xyz.ressor.source.git;

import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.filter.AndRevFilter;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.ressor.commons.utils.Exceptions;
import xyz.ressor.source.LoadedResource;
import xyz.ressor.source.Source;
import xyz.ressor.source.SourceVersion;
import xyz.ressor.source.Subscription;
import xyz.ressor.source.git.GitRef;
import xyz.ressor.source.git.GitRev;
import xyz.ressor.source.git.RefType;
import xyz.ressor.source.version.LastModified;

public class GitSource
implements Source {
    private static final Logger log = LoggerFactory.getLogger(GitSource.class);
    public static final TransportConfigCallback EMPTY_TRANSPORT_CONFIG = transport -> {};
    protected static final SourceVersion EMPTY = new LastModified(-1L);
    protected final Git git;
    protected final TransportConfigCallback transportConfig;
    protected final String filePath;
    protected final GitRef refValue;
    protected final ObjectId objectId;
    protected final boolean asyncPull;
    protected final boolean hasRemotes;

    public GitSource(Git git, TransportConfigCallback transportConfig, String filePath, GitRef ref, boolean asyncPull) {
        this.git = git;
        this.transportConfig = transportConfig;
        this.filePath = filePath;
        GitRef refValue = ref;
        try {
            boolean isBranch;
            this.objectId = git.getRepository().resolve(refValue.getFullName());
            if (this.objectId == null) {
                throw new IllegalArgumentException("Unable to find a ref with id [" + refValue.getFullName() + "], try passing a full ref name (like 'refs/heads/develop', 'refs/tags/tag-1', etc) or another one.");
            }
            if (refValue.isShort() && refValue.isBranch() && !(isBranch = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call().stream().map(r -> new GitRef(r.getName())).anyMatch(r -> r.isConnectedWith(ref)))) {
                refValue = new GitRef(refValue.getName(), RefType.TAG);
            }
            this.hasRemotes = git.remoteList().call().size() > 0;
            this.refValue = refValue;
        }
        catch (Throwable t) {
            throw Exceptions.wrap((Throwable)t);
        }
        this.asyncPull = asyncPull;
    }

    public LoadedResource loadIfModified(SourceVersion version) {
        try {
            this.pull();
            RevFilter filter = CommitTimeRevFilter.after((long)((Long)version.val()));
            LogCommand logsCmd = this.git.log().all();
            if (this.refValue.isHash()) {
                logsCmd.add((AnyObjectId)this.objectId).setRevFilter(AndRevFilter.create((RevFilter)filter, (RevFilter)GitRev.exact(this.objectId)));
            } else if (this.refValue.isTag()) {
                ObjectId objectId = this.git.getRepository().findRef(this.refValue.getFullName()).getPeeledObjectId();
                logsCmd.setRevFilter(AndRevFilter.create((RevFilter)filter, (RevFilter)GitRev.exact(objectId)));
            } else {
                logsCmd.addPath(this.filePath).setRevFilter(filter);
            }
            for (RevCommit commit : logsCmd.call()) {
                if (this.refValue.isBranchType()) {
                    List branches = this.git.branchList().setListMode(ListBranchCommand.ListMode.ALL).setContains(commit.getId().name()).call();
                    for (Ref branchRefValue : branches) {
                        GitRef branchRef = new GitRef(branchRefValue.getName());
                        if (!this.refValue.isConnectedWith(branchRef)) continue;
                        return this.loadFromCommit(commit);
                    }
                    continue;
                }
                return this.loadFromCommit(commit);
            }
            return null;
        }
        catch (Throwable t) {
            throw Exceptions.wrap((Throwable)t);
        }
    }

    public boolean isListenable() {
        return false;
    }

    public Subscription subscribe(Runnable listener) {
        return null;
    }

    public String describe() {
        return this.git.toString() + ";" + this.filePath;
    }

    public SourceVersion emptyVersion() {
        return EMPTY;
    }

    protected void pull() {
        if (this.asyncPull) {
            ForkJoinPool.commonPool().submit(this::doPull);
        } else {
            this.doPull();
        }
    }

    protected void doPull() {
        try {
            if (this.hasRemotes) {
                log.debug("Performing repository fetch");
                ((FetchCommand)this.git.fetch().setTransportConfigCallback(this.transportConfig)).call();
            }
        }
        catch (Throwable t) {
            log.error("doPull error: {}", (Object)t.getMessage(), (Object)t);
        }
    }

    protected LoadedResource loadFromCommit(RevCommit commit) {
        InputStream stream = this.getContent(commit, this.filePath);
        return stream == null ? null : new LoadedResource(stream, (SourceVersion)new LastModified((long)commit.getCommitTime() * 1000L), this.filePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream getContent(RevCommit commit, String path) {
        try (TreeWalk treeWalk = TreeWalk.forPath((Repository)this.git.getRepository(), (String)path, (RevTree)commit.getTree());){
            if (treeWalk != null) {
                ObjectId blobId = treeWalk.getObjectId(0);
                try (ObjectReader objectReader = this.git.getRepository().newObjectReader();){
                    ObjectLoader objectLoader = objectReader.open((AnyObjectId)blobId);
                    ObjectStream objectStream = objectLoader.openStream();
                    return objectStream;
                }
            }
            InputStream inputStream = null;
            return inputStream;
        }
        catch (Throwable t) {
            throw Exceptions.wrap((Throwable)t);
        }
    }
}

