/*
 * Decompiled with CFR 0.152.
 */
package xyz.ressor.source.git;

import java.util.Objects;
import org.eclipse.jgit.lib.ObjectId;
import xyz.ressor.source.git.RefType;

public class GitRef {
    private final String fullName;
    private final String name;
    private final RefType type;

    public GitRef(String refName) {
        this.fullName = refName;
        String[] split = refName.split("/");
        this.name = split[split.length - 1];
        if (ObjectId.isId((String)refName)) {
            this.type = RefType.HASH;
        } else if (split.length >= 3) {
            switch (split[1]) {
                case "heads": {
                    this.type = RefType.HEAD;
                    break;
                }
                case "remotes": {
                    this.type = RefType.REMOTE;
                    break;
                }
                case "tags": {
                    this.type = RefType.TAG;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown ref type: " + split[1]);
                }
            }
        } else {
            this.type = RefType.HEAD;
        }
    }

    public GitRef(String refName, RefType type) {
        this.fullName = refName;
        String[] split = refName.split("/");
        this.name = split[split.length - 1];
        this.type = type;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public RefType getType() {
        return this.type;
    }

    public boolean isHash() {
        return this.type == RefType.HASH;
    }

    public boolean isTag() {
        return this.type == RefType.TAG;
    }

    public boolean isBranch() {
        return this.type == RefType.HEAD;
    }

    public boolean isRemoteBranch() {
        return this.type == RefType.REMOTE;
    }

    public boolean isBranchType() {
        return this.isBranch() || this.isRemoteBranch();
    }

    public boolean isShort() {
        return this.fullName.equalsIgnoreCase(this.name);
    }

    public boolean isConnectedWith(GitRef ref) {
        return this.equals(ref) || ref != null && ref.getName().equals(this.name) && (this.type.id | ref.type.id) == 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitRef gitRef = (GitRef)o;
        return Objects.equals(this.name, gitRef.name) && this.type == gitRef.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public String toString() {
        return "GitRef{name='" + this.name + "', type=" + this.type + "}";
    }
}

