/*
 * Copyright © 2019-2022 Forb Yuan
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package win.doyto.query.web.config;

import win.doyto.query.geo.GeoShape;
import win.doyto.query.util.BeanUtil;

import java.beans.PropertyEditorSupport;

/**
 * GeoShapeEditor
 *
 * @author f0rb on 2022-03-15
 */
class GeoShapeEditor extends PropertyEditorSupport {

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        GeoShape<?> geoShape = BeanUtil.parse(text, GeoShape.class);
        super.setValue(geoShape);
    }

}
