/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.mongodb.filter;

import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bson.conversions.Bson;
import win.doyto.query.geo.Box;
import win.doyto.query.geo.Circle;
import win.doyto.query.geo.Near;
import win.doyto.query.geo.NearSphere;
import win.doyto.query.geo.Point;

public final class MongoGeoFilters {
    public static Bson near(String column, Object value) {
        if (value instanceof NearSphere) {
            return MongoGeoFilters.nearSphere(column, value);
        }
        Near near = (Near)value;
        return Filters.near((String)column, (double)near.getX(), (double)near.getY(), (Double)near.getMaxDistance(), (Double)near.getMinDistance());
    }

    public static Bson nearSphere(String column, Object value) {
        Near near = (Near)value;
        return Filters.nearSphere((String)column, (double)near.getX(), (double)near.getY(), (Double)near.getMaxDistance(), (Double)near.getMinDistance());
    }

    public static Bson withinCenter(String column, Object value) {
        Circle circle = (Circle)value;
        return Filters.geoWithinCenter((String)column, (double)circle.getX(), (double)circle.getY(), (double)circle.getRadius());
    }

    public static Bson withinCenterSphere(String column, Object value) {
        Circle circle = (Circle)value;
        return Filters.geoWithinCenterSphere((String)column, (double)circle.getX(), (double)circle.getY(), (double)circle.getRadius());
    }

    public static Bson withinBox(String column, Object value) {
        Box box = (Box)value;
        Point p1 = box.getP1();
        Point p2 = box.getP2();
        return Filters.geoWithinBox((String)column, (double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
    }

    public static Bson withinPolygon(String column, Object value) {
        List points = ((List)value).stream().map(Point::toList).collect(Collectors.toList());
        return Filters.geoWithinPolygon((String)column, points);
    }

    public static Bson within(String column, Object value) {
        return Filters.geoWithin((String)column, (Bson)((Bson)value));
    }

    public static Bson intersects(String column, Object value) {
        return Filters.geoIntersects((String)column, (Bson)((Bson)value));
    }

    @Generated
    private MongoGeoFilters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

