/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.mongodb.filter;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import win.doyto.query.core.DoytoQuery;
import win.doyto.query.core.Or;
import win.doyto.query.core.QuerySuffix;
import win.doyto.query.entity.Persistable;
import win.doyto.query.mongodb.filter.MongoGeoFilters;
import win.doyto.query.util.ColumnUtil;
import win.doyto.query.util.CommonUtil;

public final class MongoFilterBuilder {
    private static final Map<QuerySuffix, BiFunction<String, Object, Bson>> suffixFuncMap;
    private static final Pattern SORT_PTN;

    public static Bson buildFilter(Object query) {
        ArrayList<Bson> filters = new ArrayList<Bson>();
        MongoFilterBuilder.buildFilter(query, "", filters);
        switch (filters.size()) {
            case 0: {
                return new Document();
            }
            case 1: {
                return (Bson)filters.get(0);
            }
        }
        return Filters.and(filters);
    }

    private static void buildFilter(Object query, String prefix, List<Bson> filters) {
        Field[] fields;
        prefix = StringUtils.isEmpty((CharSequence)prefix) ? "" : prefix + ".";
        for (Field field : fields = ColumnUtil.initFields(query.getClass())) {
            Object value = CommonUtil.readFieldGetter((Field)field, (Object)query);
            if (QuerySuffix.isValidValue((Object)value, (Field)field)) {
                String newPrefix = prefix + field.getName();
                if (value instanceof DoytoQuery) {
                    MongoFilterBuilder.buildFilter(value, newPrefix, filters);
                    continue;
                }
                if (value instanceof Or) {
                    MongoFilterBuilder.buildOrFilter(value, filters);
                    continue;
                }
                filters.add(MongoFilterBuilder.resolveFilter(newPrefix, value));
                continue;
            }
            if (!(value instanceof Bson)) continue;
            String fieldName = field.getName();
            String column = QuerySuffix.resolve((String)fieldName).resolveColumnName(fieldName);
            filters.add((Bson)new Document(column, value));
        }
    }

    private static void buildOrFilter(Object value, List<Bson> rootFilters) {
        ArrayList<Bson> filters = new ArrayList<Bson>();
        MongoFilterBuilder.buildFilter(value, "", filters);
        switch (filters.size()) {
            case 0: {
                break;
            }
            case 1: {
                rootFilters.add((Bson)filters.get(0));
                break;
            }
            default: {
                rootFilters.add(Filters.or(filters));
            }
        }
    }

    private static Bson resolveFilter(String fieldName, Object value) {
        QuerySuffix querySuffix = QuerySuffix.resolve((String)fieldName);
        String columnName = querySuffix.resolveColumnName(fieldName);
        return suffixFuncMap.getOrDefault(querySuffix, Filters::eq).apply(columnName, value);
    }

    public static Bson buildUpdates(Object target) {
        ArrayList<Bson> updates = new ArrayList<Bson>();
        MongoFilterBuilder.buildUpdates(target, "", updates);
        return Updates.combine(updates);
    }

    private static void buildUpdates(Object entity, String prefix, List<Bson> updates) {
        Field[] fields;
        prefix = StringUtils.isEmpty((CharSequence)prefix) ? "" : prefix + ".";
        for (Field field : fields = ColumnUtil.initFields(entity.getClass())) {
            Object value = CommonUtil.readFieldGetter((Field)field, (Object)entity);
            if (!QuerySuffix.isValidValue((Object)value, (Field)field)) continue;
            String newPrefix = prefix + field.getName();
            if (value instanceof Persistable) {
                MongoFilterBuilder.buildUpdates(value, newPrefix, updates);
                continue;
            }
            updates.add(Updates.set((String)newPrefix, (Object)value));
        }
    }

    public static Bson buildSort(String sort) {
        ArrayList<Bson> sortList = new ArrayList<Bson>();
        Matcher matcher = SORT_PTN.matcher(sort.toLowerCase());
        while (matcher.find()) {
            String filedName = matcher.group(1);
            String direction = matcher.group(2);
            boolean isDesc = StringUtils.equals((CharSequence)direction, (CharSequence)",desc");
            sortList.add(isDesc ? Sorts.descending((String[])new String[]{filedName}) : Sorts.ascending((String[])new String[]{filedName}));
        }
        return Sorts.orderBy(sortList);
    }

    @Generated
    private MongoFilterBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        SORT_PTN = Pattern.compile("(\\w+)(,asc|,desc)?");
        suffixFuncMap = new EnumMap<QuerySuffix, BiFunction<String, Object, Bson>>(QuerySuffix.class);
        suffixFuncMap.put(QuerySuffix.Eq, Filters::eq);
        suffixFuncMap.put(QuerySuffix.Contain, (s, v) -> Filters.regex((String)s, (String)v.toString()));
        suffixFuncMap.put(QuerySuffix.Lt, Filters::lt);
        suffixFuncMap.put(QuerySuffix.Le, Filters::lte);
        suffixFuncMap.put(QuerySuffix.Gt, Filters::gt);
        suffixFuncMap.put(QuerySuffix.Ge, Filters::gte);
        suffixFuncMap.put(QuerySuffix.In, (fieldName, values) -> Filters.in((String)fieldName, (Iterable)((Iterable)values)));
        suffixFuncMap.put(QuerySuffix.NotIn, (fieldName, values) -> Filters.nin((String)fieldName, (Iterable)((Iterable)values)));
        suffixFuncMap.put(QuerySuffix.Not, Filters::ne);
        suffixFuncMap.put(QuerySuffix.Near, MongoGeoFilters::near);
        suffixFuncMap.put(QuerySuffix.NearSphere, MongoGeoFilters::nearSphere);
        suffixFuncMap.put(QuerySuffix.Center, MongoGeoFilters::withinCenter);
        suffixFuncMap.put(QuerySuffix.CenterSphere, MongoGeoFilters::withinCenterSphere);
        suffixFuncMap.put(QuerySuffix.Box, MongoGeoFilters::withinBox);
        suffixFuncMap.put(QuerySuffix.Py, MongoGeoFilters::withinPolygon);
        suffixFuncMap.put(QuerySuffix.Within, MongoGeoFilters::within);
        suffixFuncMap.put(QuerySuffix.IntX, MongoGeoFilters::intersects);
    }
}

