/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.mongodb.entity;

import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.Generated;
import org.bson.types.ObjectId;
import win.doyto.query.mongodb.entity.MongoPersistable;
import win.doyto.query.util.BeanUtil;

public final class ObjectIdMapper {
    private static final Map<Class<?>, Function<ObjectId, ?>> classFuncMap = new ConcurrentHashMap();

    static void initIdMapper(Class<? extends MongoPersistable> aClass) {
        classFuncMap.computeIfAbsent(aClass, clazz -> {
            Class idType = BeanUtil.getIdClass((Class)clazz);
            Function<ObjectId, Object> setIdFunc = idType.isAssignableFrom(String.class) ? ObjectId::toHexString : (idType.isAssignableFrom(ObjectId.class) ? objectId -> objectId : (idType.isAssignableFrom(BigInteger.class) ? objectId -> new BigInteger(objectId.toHexString(), 16) : objectId -> null));
            return setIdFunc;
        });
    }

    public static <I> I convert(Class<?> clazz, ObjectId objectId) {
        return (I)classFuncMap.get(clazz).apply(objectId);
    }

    @Generated
    private ObjectIdMapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

