/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.mongodb;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.config.GlobalConfiguration;
import win.doyto.query.core.DataAccess;
import win.doyto.query.core.DoytoQuery;
import win.doyto.query.core.IdWrapper;
import win.doyto.query.entity.MongoEntity;
import win.doyto.query.entity.Persistable;
import win.doyto.query.mongodb.entity.ObjectIdAware;
import win.doyto.query.mongodb.entity.ObjectIdMapper;
import win.doyto.query.mongodb.filter.MongoFilterBuilder;
import win.doyto.query.util.BeanUtil;

public class MongoDataAccess<E extends Persistable<I>, I extends Serializable, Q extends DoytoQuery>
implements DataAccess<E, I, Q> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MongoDataAccess.class);
    private static final String MONGO_ID = "_id";
    private final Class<E> entityClass;
    private final MongoCollection<Document> collection;

    public MongoDataAccess(MongoClient mongoClient, Class<E> entityClass) {
        this.entityClass = entityClass;
        MongoEntity table = entityClass.getAnnotation(MongoEntity.class);
        MongoDatabase database = mongoClient.getDatabase(table.database());
        this.collection = database.getCollection(table.collection());
    }

    private void setObjectId(E entity, Document document) {
        ObjectId objectId = (ObjectId)document.get((Object)MONGO_ID);
        if (entity instanceof ObjectIdAware) {
            ((ObjectIdAware)entity).setObjectId(objectId);
        }
    }

    private Bson getIdFilter(Object id) {
        return Filters.eq((String)MONGO_ID, (Object)new ObjectId(id.toString()));
    }

    private Bson buildFilterForChange(Q query) {
        return query.needPaging() ? Filters.in((String)MONGO_ID, this.queryObjectId(query)) : MongoFilterBuilder.buildFilter(query);
    }

    public List<E> query(Q query) {
        return this.queryColumns(query, this.entityClass, new String[0]);
    }

    public long count(Q query) {
        return this.collection.countDocuments(MongoFilterBuilder.buildFilter(query));
    }

    public <V> List<V> queryColumns(Q query, Class<V> clazz, String ... columns) {
        FindIterable findIterable = this.collection.find(MongoFilterBuilder.buildFilter(query)).projection(Projections.include((String[])columns));
        if (query.getSort() != null) {
            findIterable.sort(MongoFilterBuilder.buildSort(query.getSort()));
        }
        if (query.needPaging()) {
            int offset = GlobalConfiguration.calcOffset(query);
            findIterable.skip(offset).limit(query.getPageSize());
        }
        return (List)findIterable.map(document -> this.convert((Document)document, columns, clazz)).into(new ArrayList());
    }

    private <V> V convert(Document document, String[] columns, Class<V> clazz) {
        Object e = columns.length == 1 ? (columns[0].contains(".") ? document.getEmbedded(this.splitToKeys(columns[0]), clazz) : document.get((Object)columns[0], clazz)) : BeanUtil.parse((String)document.toJson(), clazz);
        if (log.isDebugEnabled()) {
            log.debug("Entity parsed: {}", (Object)BeanUtil.stringify((Object)e));
        }
        return (V)e;
    }

    private List<String> splitToKeys(String column) {
        return Arrays.asList(StringUtils.split((String)column, (String)"."));
    }

    public E get(IdWrapper<I> w) {
        return (E)((Persistable)this.collection.find(this.getIdFilter(w.getId())).map(document -> (Persistable)BeanUtil.parse((String)document.toJson(), this.entityClass)).first());
    }

    public int delete(IdWrapper<I> w) {
        return (int)this.collection.deleteOne(this.getIdFilter(w.getId())).getDeletedCount();
    }

    public int delete(Q query) {
        Bson inId = this.buildFilterForChange(query);
        return (int)this.collection.deleteMany(inId).getDeletedCount();
    }

    public void create(E entity) {
        Document document = (Document)BeanUtil.convertToIgnoreNull(entity, Document.class);
        this.collection.insertOne((Object)document);
        this.setObjectId(entity, document);
    }

    public int batchInsert(Iterable<E> entities, String ... columns) {
        List documents = (List)BeanUtil.convertToIgnoreNull(entities, (TypeReference)new TypeReference<List<Document>>(){});
        this.collection.insertMany(documents);
        int i = 0;
        for (Persistable entity : entities) {
            this.setObjectId(entity, (Document)documents.get(i));
            ++i;
        }
        return documents.size();
    }

    public int update(E e) {
        Bson filter = this.getIdFilter(e.getId());
        Document replacement = (Document)BeanUtil.convertTo(e, Document.class);
        replacement.remove((Object)MONGO_ID);
        return (int)this.collection.replaceOne(filter, (Object)replacement).getModifiedCount();
    }

    public int patch(E e) {
        Bson updates = MongoFilterBuilder.buildUpdates(e);
        return (int)this.collection.updateOne(this.getIdFilter(e.getId()), updates).getModifiedCount();
    }

    public int patch(E e, Q q) {
        Bson updates = MongoFilterBuilder.buildUpdates(e);
        Bson inId = this.buildFilterForChange(q);
        return (int)this.collection.updateMany(inId, updates).getModifiedCount();
    }

    public List<I> queryIds(Q query) {
        return this.queryObjectId(query).stream().map(objectId -> (Serializable)ObjectIdMapper.convert(this.entityClass, objectId)).collect(Collectors.toList());
    }

    public List<ObjectId> queryObjectId(Q query) {
        return this.queryColumns(query, ObjectId.class, MONGO_ID);
    }

    @Generated
    public MongoCollection<Document> getCollection() {
        return this.collection;
    }
}

