/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.doyto.query.geo.Box;
import win.doyto.query.geo.Circle;
import win.doyto.query.geo.Near;

public enum QuerySuffix {
    Not,
    NotLike(Constants.LIKE_PREDICATE),
    Like(Constants.LIKE_PREDICATE),
    Contain(Constants.LIKE_PREDICATE),
    Start(Constants.LIKE_PREDICATE),
    NotIn(new NotInPredicate()),
    In(new InPredicate()),
    NotNull,
    Null,
    Gt,
    Ge,
    Lt,
    Le,
    Eq,
    Near(Near.class::isInstance),
    NearSphere(Near.class::isInstance),
    Center(Circle.class::isInstance),
    CenterSphere(Circle.class::isInstance),
    Box(Box.class::isInstance),
    Py(o -> o instanceof Collection && ((Collection)o).size() >= 3),
    Within,
    IntX,
    NONE;

    @Generated
    private static final Logger log;
    private static final Pattern SUFFIX_PTN;
    private Predicate<Object> typeValidator;

    private QuerySuffix() {
        this(c -> true);
    }

    public static QuerySuffix resolve(String fieldName) {
        Matcher matcher = SUFFIX_PTN.matcher(fieldName);
        return matcher.find() ? QuerySuffix.valueOf(matcher.group()) : NONE;
    }

    public static boolean isValidValue(Object value, Field field) {
        return value != null && (!(value instanceof Boolean) || !field.getType().isPrimitive() || !Boolean.FALSE.equals(value)) && !QuerySuffix.resolve(field.getName()).shouldIgnore(value);
    }

    public String resolveColumnName(String fieldName) {
        String suffix = this.name();
        return fieldName.endsWith(suffix) ? fieldName.substring(0, fieldName.length() - suffix.length()) : fieldName;
    }

    public boolean shouldIgnore(Object value) {
        return !this.typeValidator.test(value);
    }

    @Generated
    private QuerySuffix(Predicate<Object> typeValidator) {
        this.typeValidator = typeValidator;
    }

    static {
        log = LoggerFactory.getLogger(QuerySuffix.class);
        SUFFIX_PTN = Pattern.compile(Arrays.stream(QuerySuffix.values()).filter(querySuffix -> querySuffix != NONE).map(Enum::name).collect(Collectors.joining("|", "(", ")$")));
    }

    private static interface Constants {
        public static final Predicate<Object> LIKE_PREDICATE = value -> {
            if (value instanceof String) {
                return !((String)value).trim().isEmpty();
            }
            log.warn("Type of field which ends with Like should be String.");
            return false;
        };
    }

    static class NotInPredicate
    extends InPredicate {
        NotInPredicate() {
        }

        @Override
        public boolean test(Object o) {
            return super.test(o) && !((Collection)o).isEmpty();
        }
    }

    static class InPredicate
    implements Predicate<Object> {
        InPredicate() {
        }

        @Override
        public boolean test(Object o) {
            if (o instanceof Collection) {
                return true;
            }
            log.warn("Type of field which ends with In/NotIn should be Collection.");
            return false;
        }
    }
}

