/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import win.doyto.query.core.UniqueKey;

public interface AssociationService<K1, K2> {
    default public Set<UniqueKey<K1, K2>> buildUniqueKeys(K1 k1, List<K2> collection) {
        return collection.stream().map(k2 -> new UniqueKey<Object, Object>(k1, k2)).collect(Collectors.toSet());
    }

    default public Set<UniqueKey<K1, K2>> buildUniqueKeys(List<K1> list, K2 k2) {
        return list.stream().map(k1 -> new UniqueKey<Object, Object>(k1, k2)).collect(Collectors.toSet());
    }

    default public int associate(K1 k1, K2 k2) {
        return this.associate(Collections.singleton(new UniqueKey<K1, K2>(k1, k2)));
    }

    public int associate(Set<UniqueKey<K1, K2>> var1);

    default public int dissociate(K1 k1, K2 k2) {
        return this.dissociate(Collections.singleton(new UniqueKey<K1, K2>(k1, k2)));
    }

    public int dissociate(Set<UniqueKey<K1, K2>> var1);

    public List<K1> queryK1ByK2(K2 var1);

    public List<K2> queryK2ByK1(K1 var1);

    public int deleteByK1(K1 var1);

    public int deleteByK2(K2 var1);

    public int reassociateForK1(K1 var1, List<K2> var2);

    public int reassociateForK2(K2 var1, List<K1> var2);

    public long count(Set<UniqueKey<K1, K2>> var1);

    default public boolean exists(K1 k1, K2 k2) {
        return this.exists(Collections.singleton(new UniqueKey<K1, K2>(k1, k2)));
    }

    default public boolean exists(Set<UniqueKey<K1, K2>> uniqueKeys) {
        return this.count(uniqueKeys) > 0L;
    }

    default public boolean existsExactly(Set<UniqueKey<K1, K2>> uniqueKeys) {
        return this.count(uniqueKeys) == (long)uniqueKeys.size();
    }
}

