/*
 * Decompiled with CFR 0.152.
 */
package win.doyto.query.core;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;

public enum AggregationPrefix {
    sum,
    max,
    min,
    avg,
    first,
    last,
    stdDevPop("stddev_pop"),
    stdDevSamp("stddev_samp"),
    stdDev("stddev"),
    addToSet,
    push,
    count{

        @Override
        public String resolveColumnName(String viewFieldName) {
            return viewFieldName.equals(this.name()) ? "*" : super.resolveColumnName(viewFieldName);
        }
    }
    ,
    NONE(0);

    private static final Pattern SUFFIX_PTN;
    private final int prefixLength;
    private final String name;

    private AggregationPrefix() {
        this.name = this.name();
        this.prefixLength = this.name().length();
    }

    private AggregationPrefix(String name) {
        this.name = name;
        this.prefixLength = this.name().length();
    }

    private AggregationPrefix(int prefixLength) {
        this.name = this.name();
        this.prefixLength = prefixLength;
    }

    public static AggregationPrefix resolveField(String fieldName) {
        Matcher matcher = SUFFIX_PTN.matcher(fieldName);
        return matcher.find() ? AggregationPrefix.valueOf(matcher.group()) : NONE;
    }

    public String resolveColumnName(String viewFieldName) {
        return viewFieldName.substring(this.prefixLength);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static {
        SUFFIX_PTN = Pattern.compile(Arrays.stream(AggregationPrefix.values()).map(Enum::name).collect(Collectors.joining("|", "^\\b(", ")(?=[A-Z])|count")));
    }
}

