/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import uk.staygrounded.k8sconfig.ClientConfig;
import uk.staygrounded.k8sconfig.NamespaceSelector;
import uk.staygrounded.k8sconfig.Rule__8;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"rules", "failurePolicy", "clientConfig", "name", "namespaceSelector"})
public class Webhook {
    @JsonProperty(value="rules")
    @JsonPropertyDescription(value="Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.")
    private List<Rule__8> rules = new ArrayList<Rule__8>();
    @JsonProperty(value="failurePolicy")
    @JsonPropertyDescription(value="FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.")
    private String failurePolicy;
    @JsonProperty(value="clientConfig")
    @JsonPropertyDescription(value="WebhookClientConfig contains the information to make a TLS connection with the webhook")
    private ClientConfig clientConfig;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.")
    private String name;
    @JsonProperty(value="namespaceSelector")
    @JsonPropertyDescription(value="A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.")
    private NamespaceSelector namespaceSelector;

    @JsonProperty(value="rules")
    public List<Rule__8> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    public void setRules(List<Rule__8> rules) {
        this.rules = rules;
    }

    @JsonProperty(value="failurePolicy")
    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    @JsonProperty(value="failurePolicy")
    public void setFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
    }

    @JsonProperty(value="clientConfig")
    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    @JsonProperty(value="clientConfig")
    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="namespaceSelector")
    public NamespaceSelector getNamespaceSelector() {
        return this.namespaceSelector;
    }

    @JsonProperty(value="namespaceSelector")
    public void setNamespaceSelector(NamespaceSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Webhook.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("rules");
        sb.append('=');
        sb.append(this.rules == null ? "<null>" : this.rules);
        sb.append(',');
        sb.append("failurePolicy");
        sb.append('=');
        sb.append(this.failurePolicy == null ? "<null>" : this.failurePolicy);
        sb.append(',');
        sb.append("clientConfig");
        sb.append('=');
        sb.append(this.clientConfig == null ? "<null>" : this.clientConfig);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("namespaceSelector");
        sb.append('=');
        sb.append(this.namespaceSelector == null ? "<null>" : this.namespaceSelector);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.namespaceSelector == null ? 0 : this.namespaceSelector.hashCode());
        result = result * 31 + (this.rules == null ? 0 : this.rules.hashCode());
        result = result * 31 + (this.clientConfig == null ? 0 : this.clientConfig.hashCode());
        result = result * 31 + (this.failurePolicy == null ? 0 : this.failurePolicy.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Webhook)) {
            return false;
        }
        Webhook rhs = (Webhook)other;
        return (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.namespaceSelector == rhs.namespaceSelector || this.namespaceSelector != null && this.namespaceSelector.equals(rhs.namespaceSelector)) && (this.rules == rhs.rules || this.rules != null && this.rules.equals(rhs.rules)) && (this.clientConfig == rhs.clientConfig || this.clientConfig != null && this.clientConfig.equals(rhs.clientConfig)) && (this.failurePolicy == rhs.failurePolicy || this.failurePolicy != null && this.failurePolicy.equals(rhs.failurePolicy));
    }
}

