/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import uk.staygrounded.k8sconfig.Selector__35;
import uk.staygrounded.k8sconfig.Template__22;
import uk.staygrounded.k8sconfig.UpdateStrategy__4;
import uk.staygrounded.k8sconfig.VolumeClaimTemplate__1;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"replicas", "volumeClaimTemplates", "podManagementPolicy", "selector", "serviceName", "template", "revisionHistoryLimit", "updateStrategy"})
public class Spec__77 {
    @JsonProperty(value="replicas")
    @JsonPropertyDescription(value="replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.")
    private Integer replicas;
    @JsonProperty(value="volumeClaimTemplates")
    @JsonPropertyDescription(value="volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.")
    private List<VolumeClaimTemplate__1> volumeClaimTemplates = new ArrayList<VolumeClaimTemplate__1>();
    @JsonProperty(value="podManagementPolicy")
    @JsonPropertyDescription(value="podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.")
    private String podManagementPolicy;
    @JsonProperty(value="selector")
    @JsonPropertyDescription(value="A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.")
    private Selector__35 selector;
    @JsonProperty(value="serviceName")
    @JsonPropertyDescription(value="serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.")
    private String serviceName;
    @JsonProperty(value="template")
    @JsonPropertyDescription(value="PodTemplateSpec describes the data a pod should have when created from a template")
    private Template__22 template;
    @JsonProperty(value="revisionHistoryLimit")
    @JsonPropertyDescription(value="revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.")
    private Integer revisionHistoryLimit;
    @JsonProperty(value="updateStrategy")
    @JsonPropertyDescription(value="StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.")
    private UpdateStrategy__4 updateStrategy;

    @JsonProperty(value="replicas")
    public Integer getReplicas() {
        return this.replicas;
    }

    @JsonProperty(value="replicas")
    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    @JsonProperty(value="volumeClaimTemplates")
    public List<VolumeClaimTemplate__1> getVolumeClaimTemplates() {
        return this.volumeClaimTemplates;
    }

    @JsonProperty(value="volumeClaimTemplates")
    public void setVolumeClaimTemplates(List<VolumeClaimTemplate__1> volumeClaimTemplates) {
        this.volumeClaimTemplates = volumeClaimTemplates;
    }

    @JsonProperty(value="podManagementPolicy")
    public String getPodManagementPolicy() {
        return this.podManagementPolicy;
    }

    @JsonProperty(value="podManagementPolicy")
    public void setPodManagementPolicy(String podManagementPolicy) {
        this.podManagementPolicy = podManagementPolicy;
    }

    @JsonProperty(value="selector")
    public Selector__35 getSelector() {
        return this.selector;
    }

    @JsonProperty(value="selector")
    public void setSelector(Selector__35 selector) {
        this.selector = selector;
    }

    @JsonProperty(value="serviceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @JsonProperty(value="serviceName")
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @JsonProperty(value="template")
    public Template__22 getTemplate() {
        return this.template;
    }

    @JsonProperty(value="template")
    public void setTemplate(Template__22 template) {
        this.template = template;
    }

    @JsonProperty(value="revisionHistoryLimit")
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @JsonProperty(value="revisionHistoryLimit")
    public void setRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
    }

    @JsonProperty(value="updateStrategy")
    public UpdateStrategy__4 getUpdateStrategy() {
        return this.updateStrategy;
    }

    @JsonProperty(value="updateStrategy")
    public void setUpdateStrategy(UpdateStrategy__4 updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Spec__77.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("replicas");
        sb.append('=');
        sb.append(this.replicas == null ? "<null>" : this.replicas);
        sb.append(',');
        sb.append("volumeClaimTemplates");
        sb.append('=');
        sb.append(this.volumeClaimTemplates == null ? "<null>" : this.volumeClaimTemplates);
        sb.append(',');
        sb.append("podManagementPolicy");
        sb.append('=');
        sb.append(this.podManagementPolicy == null ? "<null>" : this.podManagementPolicy);
        sb.append(',');
        sb.append("selector");
        sb.append('=');
        sb.append(this.selector == null ? "<null>" : this.selector);
        sb.append(',');
        sb.append("serviceName");
        sb.append('=');
        sb.append(this.serviceName == null ? "<null>" : this.serviceName);
        sb.append(',');
        sb.append("template");
        sb.append('=');
        sb.append(this.template == null ? "<null>" : this.template);
        sb.append(',');
        sb.append("revisionHistoryLimit");
        sb.append('=');
        sb.append(this.revisionHistoryLimit == null ? "<null>" : this.revisionHistoryLimit);
        sb.append(',');
        sb.append("updateStrategy");
        sb.append('=');
        sb.append(this.updateStrategy == null ? "<null>" : this.updateStrategy);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.template == null ? 0 : this.template.hashCode());
        result = result * 31 + (this.podManagementPolicy == null ? 0 : this.podManagementPolicy.hashCode());
        result = result * 31 + (this.updateStrategy == null ? 0 : this.updateStrategy.hashCode());
        result = result * 31 + (this.replicas == null ? 0 : this.replicas.hashCode());
        result = result * 31 + (this.selector == null ? 0 : this.selector.hashCode());
        result = result * 31 + (this.revisionHistoryLimit == null ? 0 : this.revisionHistoryLimit.hashCode());
        result = result * 31 + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = result * 31 + (this.volumeClaimTemplates == null ? 0 : this.volumeClaimTemplates.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Spec__77)) {
            return false;
        }
        Spec__77 rhs = (Spec__77)other;
        return (this.template == rhs.template || this.template != null && this.template.equals(rhs.template)) && (this.podManagementPolicy == rhs.podManagementPolicy || this.podManagementPolicy != null && this.podManagementPolicy.equals(rhs.podManagementPolicy)) && (this.updateStrategy == rhs.updateStrategy || this.updateStrategy != null && this.updateStrategy.equals(rhs.updateStrategy)) && (this.replicas == rhs.replicas || this.replicas != null && this.replicas.equals(rhs.replicas)) && (this.selector == rhs.selector || this.selector != null && this.selector.equals(rhs.selector)) && (this.revisionHistoryLimit == rhs.revisionHistoryLimit || this.revisionHistoryLimit != null && this.revisionHistoryLimit.equals(rhs.revisionHistoryLimit)) && (this.serviceName == rhs.serviceName || this.serviceName != null && this.serviceName.equals(rhs.serviceName)) && (this.volumeClaimTemplates == rhs.volumeClaimTemplates || this.volumeClaimTemplates != null && this.volumeClaimTemplates.equals(rhs.volumeClaimTemplates));
    }
}

