/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import uk.staygrounded.k8sconfig.Egress;
import uk.staygrounded.k8sconfig.Ingress__5;
import uk.staygrounded.k8sconfig.PodSelector__2;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"policyTypes", "egress", "ingress", "podSelector"})
public class Spec__38 {
    @JsonProperty(value="policyTypes")
    @JsonPropertyDescription(value="List of rule types that the NetworkPolicy relates to. Valid options are Ingress, Egress, or Ingress,Egress. If this field is not specified, it will default based on the existence of Ingress or Egress rules; policies that contain an Egress section are assumed to affect Egress, and all policies (whether or not they contain an Ingress section) are assumed to affect Ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ \"Egress\" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include \"Egress\" (since such a policy would not include an Egress section and would otherwise default to just [ \"Ingress\" ]). This field is beta-level in 1.8")
    private List<String> policyTypes = new ArrayList<String>();
    @JsonProperty(value="egress")
    @JsonPropertyDescription(value="List of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8")
    private List<Egress> egress = new ArrayList<Egress>();
    @JsonProperty(value="ingress")
    @JsonPropertyDescription(value="List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)")
    private List<Ingress__5> ingress = new ArrayList<Ingress__5>();
    @JsonProperty(value="podSelector")
    @JsonPropertyDescription(value="A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects.")
    private PodSelector__2 podSelector;

    @JsonProperty(value="policyTypes")
    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    @JsonProperty(value="policyTypes")
    public void setPolicyTypes(List<String> policyTypes) {
        this.policyTypes = policyTypes;
    }

    @JsonProperty(value="egress")
    public List<Egress> getEgress() {
        return this.egress;
    }

    @JsonProperty(value="egress")
    public void setEgress(List<Egress> egress) {
        this.egress = egress;
    }

    @JsonProperty(value="ingress")
    public List<Ingress__5> getIngress() {
        return this.ingress;
    }

    @JsonProperty(value="ingress")
    public void setIngress(List<Ingress__5> ingress) {
        this.ingress = ingress;
    }

    @JsonProperty(value="podSelector")
    public PodSelector__2 getPodSelector() {
        return this.podSelector;
    }

    @JsonProperty(value="podSelector")
    public void setPodSelector(PodSelector__2 podSelector) {
        this.podSelector = podSelector;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Spec__38.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("policyTypes");
        sb.append('=');
        sb.append(this.policyTypes == null ? "<null>" : this.policyTypes);
        sb.append(',');
        sb.append("egress");
        sb.append('=');
        sb.append(this.egress == null ? "<null>" : this.egress);
        sb.append(',');
        sb.append("ingress");
        sb.append('=');
        sb.append(this.ingress == null ? "<null>" : this.ingress);
        sb.append(',');
        sb.append("podSelector");
        sb.append('=');
        sb.append(this.podSelector == null ? "<null>" : this.podSelector);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.ingress == null ? 0 : this.ingress.hashCode());
        result = result * 31 + (this.policyTypes == null ? 0 : this.policyTypes.hashCode());
        result = result * 31 + (this.podSelector == null ? 0 : this.podSelector.hashCode());
        result = result * 31 + (this.egress == null ? 0 : this.egress.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Spec__38)) {
            return false;
        }
        Spec__38 rhs = (Spec__38)other;
        return (this.ingress == rhs.ingress || this.ingress != null && this.ingress.equals(rhs.ingress)) && (this.policyTypes == rhs.policyTypes || this.policyTypes != null && this.policyTypes.equals(rhs.policyTypes)) && (this.podSelector == rhs.podSelector || this.podSelector != null && this.podSelector.equals(rhs.podSelector)) && (this.egress == rhs.egress || this.egress != null && this.egress.equals(rhs.egress));
    }
}

