/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import uk.staygrounded.k8sconfig.Service;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"group", "service", "version", "caBundle", "groupPriorityMinimum", "insecureSkipTLSVerify", "versionPriority"})
public class Spec {
    @JsonProperty(value="group")
    @JsonPropertyDescription(value="Group is the API group name this server hosts")
    private String group;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="ServiceReference holds a reference to Service.legacy.k8s.io")
    private Service service;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Version is the API version this server hosts.  For example, \"v1\"")
    private String version;
    @JsonProperty(value="caBundle")
    @JsonPropertyDescription(value="CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate.")
    private String caBundle;
    @JsonProperty(value="groupPriorityMinimum")
    @JsonPropertyDescription(value="GroupPriorityMininum is the priority this group should have at least. Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s")
    private Integer groupPriorityMinimum;
    @JsonProperty(value="insecureSkipTLSVerify")
    @JsonPropertyDescription(value="InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged.  You should use the CABundle instead.")
    private Boolean insecureSkipTLSVerify;
    @JsonProperty(value="versionPriority")
    @JsonPropertyDescription(value="VersionPriority controls the ordering of this API version inside of its group.  Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) Since it's inside of a group, the number can be small, probably in the 10s.")
    private Integer versionPriority;

    @JsonProperty(value="group")
    public String getGroup() {
        return this.group;
    }

    @JsonProperty(value="group")
    public void setGroup(String group) {
        this.group = group;
    }

    @JsonProperty(value="service")
    public Service getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(Service service) {
        this.service = service;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="caBundle")
    public String getCaBundle() {
        return this.caBundle;
    }

    @JsonProperty(value="caBundle")
    public void setCaBundle(String caBundle) {
        this.caBundle = caBundle;
    }

    @JsonProperty(value="groupPriorityMinimum")
    public Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    @JsonProperty(value="groupPriorityMinimum")
    public void setGroupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
    }

    @JsonProperty(value="insecureSkipTLSVerify")
    public Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    @JsonProperty(value="insecureSkipTLSVerify")
    public void setInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
    }

    @JsonProperty(value="versionPriority")
    public Integer getVersionPriority() {
        return this.versionPriority;
    }

    @JsonProperty(value="versionPriority")
    public void setVersionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Spec.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("group");
        sb.append('=');
        sb.append(this.group == null ? "<null>" : this.group);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("caBundle");
        sb.append('=');
        sb.append(this.caBundle == null ? "<null>" : this.caBundle);
        sb.append(',');
        sb.append("groupPriorityMinimum");
        sb.append('=');
        sb.append(this.groupPriorityMinimum == null ? "<null>" : this.groupPriorityMinimum);
        sb.append(',');
        sb.append("insecureSkipTLSVerify");
        sb.append('=');
        sb.append(this.insecureSkipTLSVerify == null ? "<null>" : this.insecureSkipTLSVerify);
        sb.append(',');
        sb.append("versionPriority");
        sb.append('=');
        sb.append(this.versionPriority == null ? "<null>" : this.versionPriority);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.caBundle == null ? 0 : this.caBundle.hashCode());
        result = result * 31 + (this.groupPriorityMinimum == null ? 0 : this.groupPriorityMinimum.hashCode());
        result = result * 31 + (this.versionPriority == null ? 0 : this.versionPriority.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.insecureSkipTLSVerify == null ? 0 : this.insecureSkipTLSVerify.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.group == null ? 0 : this.group.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Spec)) {
            return false;
        }
        Spec rhs = (Spec)other;
        return (this.caBundle == rhs.caBundle || this.caBundle != null && this.caBundle.equals(rhs.caBundle)) && (this.groupPriorityMinimum == rhs.groupPriorityMinimum || this.groupPriorityMinimum != null && this.groupPriorityMinimum.equals(rhs.groupPriorityMinimum)) && (this.versionPriority == rhs.versionPriority || this.versionPriority != null && this.versionPriority.equals(rhs.versionPriority)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service)) && (this.insecureSkipTLSVerify == rhs.insecureSkipTLSVerify || this.insecureSkipTLSVerify != null && this.insecureSkipTLSVerify.equals(rhs.insecureSkipTLSVerify)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.group == rhs.group || this.group != null && this.group.equals(rhs.group));
    }
}

