/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import uk.staygrounded.k8sconfig.Port__64;
import uk.staygrounded.k8sconfig.Selector__31;
import uk.staygrounded.k8sconfig.SessionAffinityConfig__2;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"loadBalancerIP", "externalIPs", "externalTrafficPolicy", "type", "selector", "externalName", "sessionAffinityConfig", "sessionAffinity", "clusterIP", "loadBalancerSourceRanges", "healthCheckNodePort", "ports", "publishNotReadyAddresses"})
public class Servicespec {
    @JsonProperty(value="loadBalancerIP")
    @JsonPropertyDescription(value="Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.")
    private String loadBalancerIP;
    @JsonProperty(value="externalIPs")
    @JsonPropertyDescription(value="externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.")
    private List<String> externalIPs = new ArrayList<String>();
    @JsonProperty(value="externalTrafficPolicy")
    @JsonPropertyDescription(value="externalTrafficPolicy denotes if this Service desires to route external traffic to node-local or cluster-wide endpoints. \"Local\" preserves the client source IP and avoids a second hop for LoadBalancer and Nodeport type services, but risks potentially imbalanced traffic spreading. \"Cluster\" obscures the client source IP and may cause a second hop to another node, but should have good overall load-spreading.")
    private String externalTrafficPolicy;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. \"ExternalName\" maps to the specified externalName. \"ClusterIP\" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is \"None\", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. \"NodePort\" builds on ClusterIP and allocates a port on every node which routes to the clusterIP. \"LoadBalancer\" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services---service-types")
    private String type;
    @JsonProperty(value="selector")
    @JsonPropertyDescription(value="Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/")
    private Selector__31 selector;
    @JsonProperty(value="externalName")
    @JsonPropertyDescription(value="externalName is the external reference that kubedns or equivalent will return as a CNAME record for this service. No proxying will be involved. Must be a valid RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires Type to be ExternalName.")
    private String externalName;
    @JsonProperty(value="sessionAffinityConfig")
    @JsonPropertyDescription(value="SessionAffinityConfig represents the configurations of session affinity.")
    private SessionAffinityConfig__2 sessionAffinityConfig;
    @JsonProperty(value="sessionAffinity")
    @JsonPropertyDescription(value="Supports \"ClientIP\" and \"None\". Used to maintain session affinity. Enable client IP based session affinity. Must be ClientIP or None. Defaults to None. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies")
    private String sessionAffinity;
    @JsonProperty(value="clusterIP")
    @JsonPropertyDescription(value="clusterIP is the IP address of the service and is usually assigned randomly by the master. If an address is specified manually and is not in use by others, it will be allocated to the service; otherwise, creation of the service will fail. This field can not be changed through updates. Valid values are \"None\", empty string (\"\"), or a valid IP address. \"None\" can be specified for headless services when proxying is not required. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies")
    private String clusterIP;
    @JsonProperty(value="loadBalancerSourceRanges")
    @JsonPropertyDescription(value="If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature.\" More info: https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/")
    private List<String> loadBalancerSourceRanges = new ArrayList<String>();
    @JsonProperty(value="healthCheckNodePort")
    @JsonPropertyDescription(value="healthCheckNodePort specifies the healthcheck nodePort for the service. If not specified, HealthCheckNodePort is created by the service api backend with the allocated nodePort. Will use user-specified nodePort value if specified by the client. Only effects when Type is set to LoadBalancer and ExternalTrafficPolicy is set to Local.")
    private Integer healthCheckNodePort;
    @JsonProperty(value="ports")
    @JsonPropertyDescription(value="The list of ports that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies")
    private List<Port__64> ports = new ArrayList<Port__64>();
    @JsonProperty(value="publishNotReadyAddresses")
    @JsonPropertyDescription(value="publishNotReadyAddresses, when set to true, indicates that DNS implementations must publish the notReadyAddresses of subsets for the Endpoints associated with the Service. The default value is false. The primary use case for setting this field is to use a StatefulSet's Headless Service to propagate SRV records for its Pods without respect to their readiness for purpose of peer discovery. This field will replace the service.alpha.kubernetes.io/tolerate-unready-endpoints when that annotation is deprecated and all clients have been converted to use this field.")
    private Boolean publishNotReadyAddresses;

    @JsonProperty(value="loadBalancerIP")
    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    @JsonProperty(value="loadBalancerIP")
    public void setLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP = loadBalancerIP;
    }

    @JsonProperty(value="externalIPs")
    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    @JsonProperty(value="externalIPs")
    public void setExternalIPs(List<String> externalIPs) {
        this.externalIPs = externalIPs;
    }

    @JsonProperty(value="externalTrafficPolicy")
    public String getExternalTrafficPolicy() {
        return this.externalTrafficPolicy;
    }

    @JsonProperty(value="externalTrafficPolicy")
    public void setExternalTrafficPolicy(String externalTrafficPolicy) {
        this.externalTrafficPolicy = externalTrafficPolicy;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="selector")
    public Selector__31 getSelector() {
        return this.selector;
    }

    @JsonProperty(value="selector")
    public void setSelector(Selector__31 selector) {
        this.selector = selector;
    }

    @JsonProperty(value="externalName")
    public String getExternalName() {
        return this.externalName;
    }

    @JsonProperty(value="externalName")
    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    @JsonProperty(value="sessionAffinityConfig")
    public SessionAffinityConfig__2 getSessionAffinityConfig() {
        return this.sessionAffinityConfig;
    }

    @JsonProperty(value="sessionAffinityConfig")
    public void setSessionAffinityConfig(SessionAffinityConfig__2 sessionAffinityConfig) {
        this.sessionAffinityConfig = sessionAffinityConfig;
    }

    @JsonProperty(value="sessionAffinity")
    public String getSessionAffinity() {
        return this.sessionAffinity;
    }

    @JsonProperty(value="sessionAffinity")
    public void setSessionAffinity(String sessionAffinity) {
        this.sessionAffinity = sessionAffinity;
    }

    @JsonProperty(value="clusterIP")
    public String getClusterIP() {
        return this.clusterIP;
    }

    @JsonProperty(value="clusterIP")
    public void setClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
    }

    @JsonProperty(value="loadBalancerSourceRanges")
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    @JsonProperty(value="loadBalancerSourceRanges")
    public void setLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
    }

    @JsonProperty(value="healthCheckNodePort")
    public Integer getHealthCheckNodePort() {
        return this.healthCheckNodePort;
    }

    @JsonProperty(value="healthCheckNodePort")
    public void setHealthCheckNodePort(Integer healthCheckNodePort) {
        this.healthCheckNodePort = healthCheckNodePort;
    }

    @JsonProperty(value="ports")
    public List<Port__64> getPorts() {
        return this.ports;
    }

    @JsonProperty(value="ports")
    public void setPorts(List<Port__64> ports) {
        this.ports = ports;
    }

    @JsonProperty(value="publishNotReadyAddresses")
    public Boolean getPublishNotReadyAddresses() {
        return this.publishNotReadyAddresses;
    }

    @JsonProperty(value="publishNotReadyAddresses")
    public void setPublishNotReadyAddresses(Boolean publishNotReadyAddresses) {
        this.publishNotReadyAddresses = publishNotReadyAddresses;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Servicespec.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("loadBalancerIP");
        sb.append('=');
        sb.append(this.loadBalancerIP == null ? "<null>" : this.loadBalancerIP);
        sb.append(',');
        sb.append("externalIPs");
        sb.append('=');
        sb.append(this.externalIPs == null ? "<null>" : this.externalIPs);
        sb.append(',');
        sb.append("externalTrafficPolicy");
        sb.append('=');
        sb.append(this.externalTrafficPolicy == null ? "<null>" : this.externalTrafficPolicy);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("selector");
        sb.append('=');
        sb.append(this.selector == null ? "<null>" : this.selector);
        sb.append(',');
        sb.append("externalName");
        sb.append('=');
        sb.append(this.externalName == null ? "<null>" : this.externalName);
        sb.append(',');
        sb.append("sessionAffinityConfig");
        sb.append('=');
        sb.append(this.sessionAffinityConfig == null ? "<null>" : this.sessionAffinityConfig);
        sb.append(',');
        sb.append("sessionAffinity");
        sb.append('=');
        sb.append(this.sessionAffinity == null ? "<null>" : this.sessionAffinity);
        sb.append(',');
        sb.append("clusterIP");
        sb.append('=');
        sb.append(this.clusterIP == null ? "<null>" : this.clusterIP);
        sb.append(',');
        sb.append("loadBalancerSourceRanges");
        sb.append('=');
        sb.append(this.loadBalancerSourceRanges == null ? "<null>" : this.loadBalancerSourceRanges);
        sb.append(',');
        sb.append("healthCheckNodePort");
        sb.append('=');
        sb.append(this.healthCheckNodePort == null ? "<null>" : this.healthCheckNodePort);
        sb.append(',');
        sb.append("ports");
        sb.append('=');
        sb.append(this.ports == null ? "<null>" : this.ports);
        sb.append(',');
        sb.append("publishNotReadyAddresses");
        sb.append('=');
        sb.append(this.publishNotReadyAddresses == null ? "<null>" : this.publishNotReadyAddresses);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.healthCheckNodePort == null ? 0 : this.healthCheckNodePort.hashCode());
        result = result * 31 + (this.externalIPs == null ? 0 : this.externalIPs.hashCode());
        result = result * 31 + (this.sessionAffinity == null ? 0 : this.sessionAffinity.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.ports == null ? 0 : this.ports.hashCode());
        result = result * 31 + (this.sessionAffinityConfig == null ? 0 : this.sessionAffinityConfig.hashCode());
        result = result * 31 + (this.loadBalancerIP == null ? 0 : this.loadBalancerIP.hashCode());
        result = result * 31 + (this.externalName == null ? 0 : this.externalName.hashCode());
        result = result * 31 + (this.loadBalancerSourceRanges == null ? 0 : this.loadBalancerSourceRanges.hashCode());
        result = result * 31 + (this.externalTrafficPolicy == null ? 0 : this.externalTrafficPolicy.hashCode());
        result = result * 31 + (this.selector == null ? 0 : this.selector.hashCode());
        result = result * 31 + (this.publishNotReadyAddresses == null ? 0 : this.publishNotReadyAddresses.hashCode());
        result = result * 31 + (this.clusterIP == null ? 0 : this.clusterIP.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Servicespec)) {
            return false;
        }
        Servicespec rhs = (Servicespec)other;
        return (this.healthCheckNodePort == rhs.healthCheckNodePort || this.healthCheckNodePort != null && this.healthCheckNodePort.equals(rhs.healthCheckNodePort)) && (this.externalIPs == rhs.externalIPs || this.externalIPs != null && this.externalIPs.equals(rhs.externalIPs)) && (this.sessionAffinity == rhs.sessionAffinity || this.sessionAffinity != null && this.sessionAffinity.equals(rhs.sessionAffinity)) && (this.type == rhs.type || this.type != null && this.type.equals(rhs.type)) && (this.ports == rhs.ports || this.ports != null && this.ports.equals(rhs.ports)) && (this.sessionAffinityConfig == rhs.sessionAffinityConfig || this.sessionAffinityConfig != null && this.sessionAffinityConfig.equals(rhs.sessionAffinityConfig)) && (this.loadBalancerIP == rhs.loadBalancerIP || this.loadBalancerIP != null && this.loadBalancerIP.equals(rhs.loadBalancerIP)) && (this.externalName == rhs.externalName || this.externalName != null && this.externalName.equals(rhs.externalName)) && (this.loadBalancerSourceRanges == rhs.loadBalancerSourceRanges || this.loadBalancerSourceRanges != null && this.loadBalancerSourceRanges.equals(rhs.loadBalancerSourceRanges)) && (this.externalTrafficPolicy == rhs.externalTrafficPolicy || this.externalTrafficPolicy != null && this.externalTrafficPolicy.equals(rhs.externalTrafficPolicy)) && (this.selector == rhs.selector || this.selector != null && this.selector.equals(rhs.selector)) && (this.publishNotReadyAddresses == rhs.publishNotReadyAddresses || this.publishNotReadyAddresses != null && this.publishNotReadyAddresses.equals(rhs.publishNotReadyAddresses)) && (this.clusterIP == rhs.clusterIP || this.clusterIP != null && this.clusterIP.equals(rhs.clusterIP));
    }
}

