/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import uk.staygrounded.k8sconfig.SeLinuxOptions__25;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"runAsGroup", "runAsUser", "supplementalGroups", "fsGroup", "runAsNonRoot", "seLinuxOptions"})
public class SecurityContext__25 {
    @JsonProperty(value="runAsGroup")
    @JsonPropertyDescription(value="The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.")
    private Integer runAsGroup;
    @JsonProperty(value="runAsUser")
    @JsonPropertyDescription(value="The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.")
    private Integer runAsUser;
    @JsonProperty(value="supplementalGroups")
    @JsonPropertyDescription(value="A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.")
    private List<Integer> supplementalGroups = new ArrayList<Integer>();
    @JsonProperty(value="fsGroup")
    @JsonPropertyDescription(value="A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:\n\n1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----\n\nIf unset, the Kubelet will not modify the ownership and permissions of any volume.")
    private Integer fsGroup;
    @JsonProperty(value="runAsNonRoot")
    @JsonPropertyDescription(value="Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    private Boolean runAsNonRoot;
    @JsonProperty(value="seLinuxOptions")
    @JsonPropertyDescription(value="SELinuxOptions are the labels to be applied to the container")
    private SeLinuxOptions__25 seLinuxOptions;

    @JsonProperty(value="runAsGroup")
    public Integer getRunAsGroup() {
        return this.runAsGroup;
    }

    @JsonProperty(value="runAsGroup")
    public void setRunAsGroup(Integer runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    @JsonProperty(value="runAsUser")
    public Integer getRunAsUser() {
        return this.runAsUser;
    }

    @JsonProperty(value="runAsUser")
    public void setRunAsUser(Integer runAsUser) {
        this.runAsUser = runAsUser;
    }

    @JsonProperty(value="supplementalGroups")
    public List<Integer> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    @JsonProperty(value="supplementalGroups")
    public void setSupplementalGroups(List<Integer> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
    }

    @JsonProperty(value="fsGroup")
    public Integer getFsGroup() {
        return this.fsGroup;
    }

    @JsonProperty(value="fsGroup")
    public void setFsGroup(Integer fsGroup) {
        this.fsGroup = fsGroup;
    }

    @JsonProperty(value="runAsNonRoot")
    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    @JsonProperty(value="runAsNonRoot")
    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    @JsonProperty(value="seLinuxOptions")
    public SeLinuxOptions__25 getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    @JsonProperty(value="seLinuxOptions")
    public void setSeLinuxOptions(SeLinuxOptions__25 seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(SecurityContext__25.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("runAsGroup");
        sb.append('=');
        sb.append(this.runAsGroup == null ? "<null>" : this.runAsGroup);
        sb.append(',');
        sb.append("runAsUser");
        sb.append('=');
        sb.append(this.runAsUser == null ? "<null>" : this.runAsUser);
        sb.append(',');
        sb.append("supplementalGroups");
        sb.append('=');
        sb.append(this.supplementalGroups == null ? "<null>" : this.supplementalGroups);
        sb.append(',');
        sb.append("fsGroup");
        sb.append('=');
        sb.append(this.fsGroup == null ? "<null>" : this.fsGroup);
        sb.append(',');
        sb.append("runAsNonRoot");
        sb.append('=');
        sb.append(this.runAsNonRoot == null ? "<null>" : this.runAsNonRoot);
        sb.append(',');
        sb.append("seLinuxOptions");
        sb.append('=');
        sb.append(this.seLinuxOptions == null ? "<null>" : this.seLinuxOptions);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.runAsUser == null ? 0 : this.runAsUser.hashCode());
        result = result * 31 + (this.seLinuxOptions == null ? 0 : this.seLinuxOptions.hashCode());
        result = result * 31 + (this.fsGroup == null ? 0 : this.fsGroup.hashCode());
        result = result * 31 + (this.supplementalGroups == null ? 0 : this.supplementalGroups.hashCode());
        result = result * 31 + (this.runAsGroup == null ? 0 : this.runAsGroup.hashCode());
        result = result * 31 + (this.runAsNonRoot == null ? 0 : this.runAsNonRoot.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SecurityContext__25)) {
            return false;
        }
        SecurityContext__25 rhs = (SecurityContext__25)other;
        return (this.runAsUser == rhs.runAsUser || this.runAsUser != null && this.runAsUser.equals(rhs.runAsUser)) && (this.seLinuxOptions == rhs.seLinuxOptions || this.seLinuxOptions != null && this.seLinuxOptions.equals(rhs.seLinuxOptions)) && (this.fsGroup == rhs.fsGroup || this.fsGroup != null && this.fsGroup.equals(rhs.fsGroup)) && (this.supplementalGroups == rhs.supplementalGroups || this.supplementalGroups != null && this.supplementalGroups.equals(rhs.supplementalGroups)) && (this.runAsGroup == rhs.runAsGroup || this.runAsGroup != null && this.runAsGroup.equals(rhs.runAsGroup)) && (this.runAsNonRoot == rhs.runAsNonRoot || this.runAsNonRoot != null && this.runAsNonRoot.equals(rhs.runAsNonRoot));
    }
}

