/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"labelSelectorPath", "statusReplicasPath", "specReplicasPath"})
public class Scale {
    @JsonProperty(value="labelSelectorPath")
    @JsonPropertyDescription(value="LabelSelectorPath defines the JSON path inside of a CustomResource that corresponds to Scale.Status.Selector. Only JSON paths without the array notation are allowed. Must be a JSON Path under .status. Must be set to work with HPA. If there is no value under the given path in the CustomResource, the status label selector value in the /scale subresource will default to the empty string.")
    private String labelSelectorPath;
    @JsonProperty(value="statusReplicasPath")
    @JsonPropertyDescription(value="StatusReplicasPath defines the JSON path inside of a CustomResource that corresponds to Scale.Status.Replicas. Only JSON paths without the array notation are allowed. Must be a JSON Path under .status. If there is no value under the given path in the CustomResource, the status replica value in the /scale subresource will default to 0.")
    private String statusReplicasPath;
    @JsonProperty(value="specReplicasPath")
    @JsonPropertyDescription(value="SpecReplicasPath defines the JSON path inside of a CustomResource that corresponds to Scale.Spec.Replicas. Only JSON paths without the array notation are allowed. Must be a JSON Path under .spec. If there is no value under the given path in the CustomResource, the /scale subresource will return an error on GET.")
    private String specReplicasPath;

    @JsonProperty(value="labelSelectorPath")
    public String getLabelSelectorPath() {
        return this.labelSelectorPath;
    }

    @JsonProperty(value="labelSelectorPath")
    public void setLabelSelectorPath(String labelSelectorPath) {
        this.labelSelectorPath = labelSelectorPath;
    }

    @JsonProperty(value="statusReplicasPath")
    public String getStatusReplicasPath() {
        return this.statusReplicasPath;
    }

    @JsonProperty(value="statusReplicasPath")
    public void setStatusReplicasPath(String statusReplicasPath) {
        this.statusReplicasPath = statusReplicasPath;
    }

    @JsonProperty(value="specReplicasPath")
    public String getSpecReplicasPath() {
        return this.specReplicasPath;
    }

    @JsonProperty(value="specReplicasPath")
    public void setSpecReplicasPath(String specReplicasPath) {
        this.specReplicasPath = specReplicasPath;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Scale.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("labelSelectorPath");
        sb.append('=');
        sb.append(this.labelSelectorPath == null ? "<null>" : this.labelSelectorPath);
        sb.append(',');
        sb.append("statusReplicasPath");
        sb.append('=');
        sb.append(this.statusReplicasPath == null ? "<null>" : this.statusReplicasPath);
        sb.append(',');
        sb.append("specReplicasPath");
        sb.append('=');
        sb.append(this.specReplicasPath == null ? "<null>" : this.specReplicasPath);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.labelSelectorPath == null ? 0 : this.labelSelectorPath.hashCode());
        result = result * 31 + (this.statusReplicasPath == null ? 0 : this.statusReplicasPath.hashCode());
        result = result * 31 + (this.specReplicasPath == null ? 0 : this.specReplicasPath.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Scale)) {
            return false;
        }
        Scale rhs = (Scale)other;
        return (this.labelSelectorPath == rhs.labelSelectorPath || this.labelSelectorPath != null && this.labelSelectorPath.equals(rhs.labelSelectorPath)) && (this.statusReplicasPath == rhs.statusReplicasPath || this.statusReplicasPath != null && this.statusReplicasPath.equals(rhs.statusReplicasPath)) && (this.specReplicasPath == rhs.specReplicasPath || this.specReplicasPath != null && this.specReplicasPath.equals(rhs.specReplicasPath));
    }
}

