/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"shortNames", "namespaced", "kind", "group", "name", "version", "singularName", "categories", "verbs"})
public class Resource {
    @JsonProperty(value="shortNames")
    @JsonPropertyDescription(value="shortNames is a list of suggested short names of the resource.")
    private List<String> shortNames = new ArrayList<String>();
    @JsonProperty(value="namespaced")
    @JsonPropertyDescription(value="namespaced indicates if a resource is namespaced or not.")
    private Boolean namespaced;
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')")
    private String kind;
    @JsonProperty(value="group")
    @JsonPropertyDescription(value="group is the preferred group of the resource.  Empty implies the group of the containing resource list. For subresources, this may have a different value, for example: Scale\".")
    private String group;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="name is the plural name of the resource.")
    private String name;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="version is the preferred version of the resource.  Empty implies the version of the containing resource list For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource's group)\".")
    private String version;
    @JsonProperty(value="singularName")
    @JsonPropertyDescription(value="singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely. The singularName is more correct for reporting status on a single item and both singular and plural are allowed from the kubectl CLI interface.")
    private String singularName;
    @JsonProperty(value="categories")
    @JsonPropertyDescription(value="categories is a list of the grouped resources this resource belongs to (e.g. 'all')")
    private List<String> categories = new ArrayList<String>();
    @JsonProperty(value="verbs")
    @JsonPropertyDescription(value="verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)")
    private List<String> verbs = new ArrayList<String>();

    @JsonProperty(value="shortNames")
    public List<String> getShortNames() {
        return this.shortNames;
    }

    @JsonProperty(value="shortNames")
    public void setShortNames(List<String> shortNames) {
        this.shortNames = shortNames;
    }

    @JsonProperty(value="namespaced")
    public Boolean getNamespaced() {
        return this.namespaced;
    }

    @JsonProperty(value="namespaced")
    public void setNamespaced(Boolean namespaced) {
        this.namespaced = namespaced;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="group")
    public String getGroup() {
        return this.group;
    }

    @JsonProperty(value="group")
    public void setGroup(String group) {
        this.group = group;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="singularName")
    public String getSingularName() {
        return this.singularName;
    }

    @JsonProperty(value="singularName")
    public void setSingularName(String singularName) {
        this.singularName = singularName;
    }

    @JsonProperty(value="categories")
    public List<String> getCategories() {
        return this.categories;
    }

    @JsonProperty(value="categories")
    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    @JsonProperty(value="verbs")
    public List<String> getVerbs() {
        return this.verbs;
    }

    @JsonProperty(value="verbs")
    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Resource.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("shortNames");
        sb.append('=');
        sb.append(this.shortNames == null ? "<null>" : this.shortNames);
        sb.append(',');
        sb.append("namespaced");
        sb.append('=');
        sb.append(this.namespaced == null ? "<null>" : this.namespaced);
        sb.append(',');
        sb.append("kind");
        sb.append('=');
        sb.append(this.kind == null ? "<null>" : this.kind);
        sb.append(',');
        sb.append("group");
        sb.append('=');
        sb.append(this.group == null ? "<null>" : this.group);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("singularName");
        sb.append('=');
        sb.append(this.singularName == null ? "<null>" : this.singularName);
        sb.append(',');
        sb.append("categories");
        sb.append('=');
        sb.append(this.categories == null ? "<null>" : this.categories);
        sb.append(',');
        sb.append("verbs");
        sb.append('=');
        sb.append(this.verbs == null ? "<null>" : this.verbs);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.shortNames == null ? 0 : this.shortNames.hashCode());
        result = result * 31 + (this.kind == null ? 0 : this.kind.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.verbs == null ? 0 : this.verbs.hashCode());
        result = result * 31 + (this.categories == null ? 0 : this.categories.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        result = result * 31 + (this.namespaced == null ? 0 : this.namespaced.hashCode());
        result = result * 31 + (this.group == null ? 0 : this.group.hashCode());
        result = result * 31 + (this.singularName == null ? 0 : this.singularName.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Resource)) {
            return false;
        }
        Resource rhs = (Resource)other;
        return (this.shortNames == rhs.shortNames || this.shortNames != null && this.shortNames.equals(rhs.shortNames)) && (this.kind == rhs.kind || this.kind != null && this.kind.equals(rhs.kind)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.verbs == rhs.verbs || this.verbs != null && this.verbs.equals(rhs.verbs)) && (this.categories == rhs.categories || this.categories != null && this.categories.equals(rhs.categories)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version)) && (this.namespaced == rhs.namespaced || this.namespaced != null && this.namespaced.equals(rhs.namespaced)) && (this.group == rhs.group || this.group != null && this.group.equals(rhs.group)) && (this.singularName == rhs.singularName || this.singularName != null && this.singularName.equals(rhs.singularName));
    }
}

