/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import uk.staygrounded.k8sconfig.External__1;
import uk.staygrounded.k8sconfig.Object__1;
import uk.staygrounded.k8sconfig.Pods__1;
import uk.staygrounded.k8sconfig.Resource__2;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"resource", "object", "pods", "external", "type"})
public class Metricspec {
    @JsonProperty(value="resource")
    @JsonPropertyDescription(value="ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.")
    private Resource__2 resource;
    @JsonProperty(value="object")
    @JsonPropertyDescription(value="ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).")
    private Object__1 object;
    @JsonProperty(value="pods")
    @JsonPropertyDescription(value="PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.")
    private Pods__1 pods;
    @JsonProperty(value="external")
    @JsonPropertyDescription(value="ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster). Exactly one \"target\" type should be set.")
    private External__1 external;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="type is the type of metric source.  It should be one of \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object.")
    private String type;

    @JsonProperty(value="resource")
    public Resource__2 getResource() {
        return this.resource;
    }

    @JsonProperty(value="resource")
    public void setResource(Resource__2 resource) {
        this.resource = resource;
    }

    @JsonProperty(value="object")
    public Object__1 getObject() {
        return this.object;
    }

    @JsonProperty(value="object")
    public void setObject(Object__1 object) {
        this.object = object;
    }

    @JsonProperty(value="pods")
    public Pods__1 getPods() {
        return this.pods;
    }

    @JsonProperty(value="pods")
    public void setPods(Pods__1 pods) {
        this.pods = pods;
    }

    @JsonProperty(value="external")
    public External__1 getExternal() {
        return this.external;
    }

    @JsonProperty(value="external")
    public void setExternal(External__1 external) {
        this.external = external;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Metricspec.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("resource");
        sb.append('=');
        sb.append(this.resource == null ? "<null>" : this.resource);
        sb.append(',');
        sb.append("object");
        sb.append('=');
        sb.append(this.object == null ? "<null>" : this.object);
        sb.append(',');
        sb.append("pods");
        sb.append('=');
        sb.append(this.pods == null ? "<null>" : this.pods);
        sb.append(',');
        sb.append("external");
        sb.append('=');
        sb.append(this.external == null ? "<null>" : this.external);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.pods == null ? 0 : this.pods.hashCode());
        result = result * 31 + (this.external == null ? 0 : this.external.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.resource == null ? 0 : this.resource.hashCode());
        result = result * 31 + (this.object == null ? 0 : this.object.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Metricspec)) {
            return false;
        }
        Metricspec rhs = (Metricspec)other;
        return (this.pods == rhs.pods || this.pods != null && this.pods.equals(rhs.pods)) && (this.external == rhs.external || this.external != null && this.external.equals(rhs.external)) && (this.type == rhs.type || this.type != null && this.type.equals(rhs.type)) && (this.resource == rhs.resource || this.resource != null && this.resource.equals(rhs.resource)) && (this.object == rhs.object || this.object != null && this.object.equals(rhs.object));
    }
}

