/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import uk.staygrounded.k8sconfig.Metric;
import uk.staygrounded.k8sconfig.ScaleTargetRef__2;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"metrics", "minReplicas", "scaleTargetRef", "maxReplicas"})
public class Horizontalpodautoscalerspec {
    @JsonProperty(value="metrics")
    @JsonPropertyDescription(value="metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond.")
    private List<Metric> metrics = new ArrayList<Metric>();
    @JsonProperty(value="minReplicas")
    @JsonPropertyDescription(value="minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down. It defaults to 1 pod.")
    private Integer minReplicas;
    @JsonProperty(value="scaleTargetRef")
    @JsonPropertyDescription(value="CrossVersionObjectReference contains enough information to let you identify the referred resource.")
    private ScaleTargetRef__2 scaleTargetRef;
    @JsonProperty(value="maxReplicas")
    @JsonPropertyDescription(value="maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.")
    private Integer maxReplicas;

    @JsonProperty(value="metrics")
    public List<Metric> getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    @JsonProperty(value="minReplicas")
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    @JsonProperty(value="minReplicas")
    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    @JsonProperty(value="scaleTargetRef")
    public ScaleTargetRef__2 getScaleTargetRef() {
        return this.scaleTargetRef;
    }

    @JsonProperty(value="scaleTargetRef")
    public void setScaleTargetRef(ScaleTargetRef__2 scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
    }

    @JsonProperty(value="maxReplicas")
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    @JsonProperty(value="maxReplicas")
    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Horizontalpodautoscalerspec.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("metrics");
        sb.append('=');
        sb.append(this.metrics == null ? "<null>" : this.metrics);
        sb.append(',');
        sb.append("minReplicas");
        sb.append('=');
        sb.append(this.minReplicas == null ? "<null>" : this.minReplicas);
        sb.append(',');
        sb.append("scaleTargetRef");
        sb.append('=');
        sb.append(this.scaleTargetRef == null ? "<null>" : this.scaleTargetRef);
        sb.append(',');
        sb.append("maxReplicas");
        sb.append('=');
        sb.append(this.maxReplicas == null ? "<null>" : this.maxReplicas);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.maxReplicas == null ? 0 : this.maxReplicas.hashCode());
        result = result * 31 + (this.metrics == null ? 0 : this.metrics.hashCode());
        result = result * 31 + (this.minReplicas == null ? 0 : this.minReplicas.hashCode());
        result = result * 31 + (this.scaleTargetRef == null ? 0 : this.scaleTargetRef.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Horizontalpodautoscalerspec)) {
            return false;
        }
        Horizontalpodautoscalerspec rhs = (Horizontalpodautoscalerspec)other;
        return (this.maxReplicas == rhs.maxReplicas || this.maxReplicas != null && this.maxReplicas.equals(rhs.maxReplicas)) && (this.metrics == rhs.metrics || this.metrics != null && this.metrics.equals(rhs.metrics)) && (this.minReplicas == rhs.minReplicas || this.minReplicas != null && this.minReplicas.equals(rhs.minReplicas)) && (this.scaleTargetRef == rhs.scaleTargetRef || this.scaleTargetRef != null && this.scaleTargetRef.equals(rhs.scaleTargetRef));
    }
}

