/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import uk.staygrounded.k8sconfig.PreferredVersion__1;
import uk.staygrounded.k8sconfig.ServerAddressByClientCIDR__1;
import uk.staygrounded.k8sconfig.Version__1;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"kind", "name", "versions", "apiVersion", "serverAddressByClientCIDRs", "preferredVersion"})
public class Group {
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    private String kind;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="name is the name of the group.")
    private String name;
    @JsonProperty(value="versions")
    @JsonPropertyDescription(value="versions are the versions supported in this group.")
    private List<Version__1> versions = new ArrayList<Version__1>();
    @JsonProperty(value="apiVersion")
    @JsonPropertyDescription(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    private String apiVersion;
    @JsonProperty(value="serverAddressByClientCIDRs")
    @JsonPropertyDescription(value="a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.")
    private List<ServerAddressByClientCIDR__1> serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDR__1>();
    @JsonProperty(value="preferredVersion")
    @JsonPropertyDescription(value="GroupVersion contains the \"group/version\" and \"version\" string of a version. It is made a struct to keep extensibility.")
    private PreferredVersion__1 preferredVersion;

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="versions")
    public List<Version__1> getVersions() {
        return this.versions;
    }

    @JsonProperty(value="versions")
    public void setVersions(List<Version__1> versions) {
        this.versions = versions;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="serverAddressByClientCIDRs")
    public List<ServerAddressByClientCIDR__1> getServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs;
    }

    @JsonProperty(value="serverAddressByClientCIDRs")
    public void setServerAddressByClientCIDRs(List<ServerAddressByClientCIDR__1> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
    }

    @JsonProperty(value="preferredVersion")
    public PreferredVersion__1 getPreferredVersion() {
        return this.preferredVersion;
    }

    @JsonProperty(value="preferredVersion")
    public void setPreferredVersion(PreferredVersion__1 preferredVersion) {
        this.preferredVersion = preferredVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Group.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("kind");
        sb.append('=');
        sb.append(this.kind == null ? "<null>" : this.kind);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("versions");
        sb.append('=');
        sb.append(this.versions == null ? "<null>" : this.versions);
        sb.append(',');
        sb.append("apiVersion");
        sb.append('=');
        sb.append(this.apiVersion == null ? "<null>" : this.apiVersion);
        sb.append(',');
        sb.append("serverAddressByClientCIDRs");
        sb.append('=');
        sb.append(this.serverAddressByClientCIDRs == null ? "<null>" : this.serverAddressByClientCIDRs);
        sb.append(',');
        sb.append("preferredVersion");
        sb.append('=');
        sb.append(this.preferredVersion == null ? "<null>" : this.preferredVersion);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.apiVersion == null ? 0 : this.apiVersion.hashCode());
        result = result * 31 + (this.versions == null ? 0 : this.versions.hashCode());
        result = result * 31 + (this.kind == null ? 0 : this.kind.hashCode());
        result = result * 31 + (this.preferredVersion == null ? 0 : this.preferredVersion.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.serverAddressByClientCIDRs == null ? 0 : this.serverAddressByClientCIDRs.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Group)) {
            return false;
        }
        Group rhs = (Group)other;
        return (this.apiVersion == rhs.apiVersion || this.apiVersion != null && this.apiVersion.equals(rhs.apiVersion)) && (this.versions == rhs.versions || this.versions != null && this.versions.equals(rhs.versions)) && (this.kind == rhs.kind || this.kind != null && this.kind.equals(rhs.kind)) && (this.preferredVersion == rhs.preferredVersion || this.preferredVersion != null && this.preferredVersion.equals(rhs.preferredVersion)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.serverAddressByClientCIDRs == rhs.serverAddressByClientCIDRs || this.serverAddressByClientCIDRs != null && this.serverAddressByClientCIDRs.equals(rhs.serverAddressByClientCIDRs));
    }
}

