/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import uk.staygrounded.k8sconfig.Service__8;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"caBundle", "url", "service"})
public class ClientConfig__4 {
    @JsonProperty(value="caBundle")
    @JsonPropertyDescription(value="`caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. Required.")
    private String caBundle;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="`url` gives the location of the webhook, in standard URL form (`[scheme://]host:port/path`). Exactly one of `url` or `service` must be specified.\n\nThe `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.\n\nPlease note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.\n\nThe scheme must be \"https\"; the URL must begin with \"https://\".\n\nA path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.\n\nAttempting to use a user or basic auth e.g. \"user:password@\" is not allowed. Fragments (\"#...\") and query parameters (\"?...\") are not allowed, either.")
    private String url;
    @JsonProperty(value="service")
    @JsonPropertyDescription(value="ServiceReference holds a reference to Service.legacy.k8s.io")
    private Service__8 service;

    @JsonProperty(value="caBundle")
    public String getCaBundle() {
        return this.caBundle;
    }

    @JsonProperty(value="caBundle")
    public void setCaBundle(String caBundle) {
        this.caBundle = caBundle;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="service")
    public Service__8 getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    public void setService(Service__8 service) {
        this.service = service;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ClientConfig__4.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("caBundle");
        sb.append('=');
        sb.append(this.caBundle == null ? "<null>" : this.caBundle);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("service");
        sb.append('=');
        sb.append(this.service == null ? "<null>" : this.service);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.caBundle == null ? 0 : this.caBundle.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ClientConfig__4)) {
            return false;
        }
        ClientConfig__4 rhs = (ClientConfig__4)other;
        return (this.caBundle == rhs.caBundle || this.caBundle != null && this.caBundle.equals(rhs.caBundle)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.service == rhs.service || this.service != null && this.service.equals(rhs.service));
    }
}

