/*
 * Decompiled with CFR 0.152.
 */
package uk.staygrounded.k8sconfig;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import uk.staygrounded.k8sconfig.ServerAddressByClientCIDR__2;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"serverAddressByClientCIDRs", "kind", "apiVersion", "versions"})
public class Apiversions {
    @JsonProperty(value="serverAddressByClientCIDRs")
    @JsonPropertyDescription(value="a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.")
    private List<ServerAddressByClientCIDR__2> serverAddressByClientCIDRs = new ArrayList<ServerAddressByClientCIDR__2>();
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    private String kind;
    @JsonProperty(value="apiVersion")
    @JsonPropertyDescription(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    private String apiVersion;
    @JsonProperty(value="versions")
    @JsonPropertyDescription(value="versions are the api versions that are available.")
    private List<String> versions = new ArrayList<String>();

    @JsonProperty(value="serverAddressByClientCIDRs")
    public List<ServerAddressByClientCIDR__2> getServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs;
    }

    @JsonProperty(value="serverAddressByClientCIDRs")
    public void setServerAddressByClientCIDRs(List<ServerAddressByClientCIDR__2> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="versions")
    public List<String> getVersions() {
        return this.versions;
    }

    @JsonProperty(value="versions")
    public void setVersions(List<String> versions) {
        this.versions = versions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Apiversions.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("serverAddressByClientCIDRs");
        sb.append('=');
        sb.append(this.serverAddressByClientCIDRs == null ? "<null>" : this.serverAddressByClientCIDRs);
        sb.append(',');
        sb.append("kind");
        sb.append('=');
        sb.append(this.kind == null ? "<null>" : this.kind);
        sb.append(',');
        sb.append("apiVersion");
        sb.append('=');
        sb.append(this.apiVersion == null ? "<null>" : this.apiVersion);
        sb.append(',');
        sb.append("versions");
        sb.append('=');
        sb.append(this.versions == null ? "<null>" : this.versions);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.apiVersion == null ? 0 : this.apiVersion.hashCode());
        result = result * 31 + (this.versions == null ? 0 : this.versions.hashCode());
        result = result * 31 + (this.serverAddressByClientCIDRs == null ? 0 : this.serverAddressByClientCIDRs.hashCode());
        result = result * 31 + (this.kind == null ? 0 : this.kind.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Apiversions)) {
            return false;
        }
        Apiversions rhs = (Apiversions)other;
        return (this.apiVersion == rhs.apiVersion || this.apiVersion != null && this.apiVersion.equals(rhs.apiVersion)) && (this.versions == rhs.versions || this.versions != null && this.versions.equals(rhs.versions)) && (this.serverAddressByClientCIDRs == rhs.serverAddressByClientCIDRs || this.serverAddressByClientCIDRs != null && this.serverAddressByClientCIDRs.equals(rhs.serverAddressByClientCIDRs)) && (this.kind == rhs.kind || this.kind != null && this.kind.equals(rhs.kind));
    }
}

