package uk.num.modules.contacts.compact;

import java.io.IOException;
import java.io.IOException;
import com.fasterxml.jackson.core.*;
import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.databind.annotation.*;
import com.fasterxml.jackson.core.type.*;
import java.util.List;

@JsonDeserialize(using = Contact.Deserializer.class)
@JsonSerialize(using = Contact.Serializer.class)
public class Contact {
    public Method methodValue;
    public List<String> stringArrayValue;
    public String stringValue;

    static class Deserializer extends JsonDeserializer<Contact> {
        @Override
        public Contact deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Contact value = new Contact();
            switch (jsonParser.currentToken()) {
                case VALUE_STRING:
                    String string = jsonParser.readValueAs(String.class);
                    value.stringValue = string;
                    break;
                case START_ARRAY:
                    value.stringArrayValue = jsonParser.readValueAs(new TypeReference<List<String>>() {});
                    break;
                case START_OBJECT:
                    value.methodValue = jsonParser.readValueAs(Method.class);
                    break;
                default: throw new IOException("Cannot deserialize Contact");
            }
            return value;
        }
    }

    static class Serializer extends JsonSerializer<Contact> {
        @Override
        public void serialize(Contact obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (obj.methodValue != null) {
                jsonGenerator.writeObject(obj.methodValue);
                return;
            }
            if (obj.stringArrayValue != null) {
                jsonGenerator.writeObject(obj.stringArrayValue);
                return;
            }
            if (obj.stringValue != null) {
                jsonGenerator.writeObject(obj.stringValue);
                return;
            }
            throw new IOException("Contact must not be null");
        }
    }
}
