/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.util;

import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.util.HashUtils;
import uk.num.numlib.internal.util.LookupGenerator;

abstract class BaseLookupGenerator
implements LookupGenerator {
    protected final String numId;
    protected final AppContext appContext;
    protected String branch;
    protected String domain;

    public BaseLookupGenerator(@NonNull AppContext appContext, @NonNull String numId) {
        if (appContext == null) {
            throw new NullPointerException("appContext is marked @NonNull but is null");
        }
        if (numId == null) {
            throw new NullPointerException("numId is marked @NonNull but is null");
        }
        this.numId = numId;
        this.appContext = appContext;
    }

    protected static String normaliseDomainName(@NonNull String numId) {
        if (numId == null) {
            throw new NullPointerException("numId is marked @NonNull but is null");
        }
        if (numId.startsWith("http")) {
            try {
                URL url = new URL(numId);
                String host = url.getHost();
                return BaseLookupGenerator.normaliseDomainName(host);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Invalid URL: " + numId);
            }
        }
        String result = numId;
        if (result.startsWith("www.")) {
            result = result.substring(4);
        }
        if (result.startsWith(".")) {
            result = result.substring(1);
        }
        if (result.endsWith(".")) {
            result = result.substring(0, result.length() - 1);
        }
        if (!StringUtils.isAsciiPrintable((CharSequence)result)) {
            Object[] parts = result.split("\\.");
            for (int i = 0; i < parts.length; ++i) {
                if (StringUtils.isAsciiPrintable((CharSequence)parts[i])) continue;
                parts[i] = IDN.toASCII((String)parts[i]);
            }
            result = StringUtils.join((Object[])parts, (String)".");
        }
        return result;
    }

    protected static String normalisePath(String path) {
        String result = "";
        if (path != null && !path.isEmpty()) {
            Object[] pathComponents = path.split("[/]");
            ArrayUtils.reverse((Object[])pathComponents);
            if (pathComponents.length > 0 && ((String)pathComponents[0]).contains(".")) {
                pathComponents[0] = "";
            }
            if (pathComponents.length > 0) {
                result = StringUtils.join((Object[])pathComponents, (String)".");
                if ((result = result.replaceAll(" ", "_")).startsWith(".")) {
                    result = result.substring(1);
                }
                if (result.endsWith(".")) {
                    result = result.substring(0, result.length() - 1);
                }
            }
        }
        return result;
    }

    @Override
    public String getIndependentLocation(@NonNull String moduleId) {
        if (moduleId == null) {
            throw new NullPointerException("moduleId is marked @NonNull but is null");
        }
        String result = this.getRootIndependentLocation(moduleId);
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    @Override
    public String getHostedLocation(@NonNull String moduleId) {
        if (moduleId == null) {
            throw new NullPointerException("moduleId is marked @NonNull but is null");
        }
        String result = this.getRootHostedLocation(moduleId);
        if (this.branch == null) {
            return result;
        }
        return this.branch + "." + result;
    }

    @Override
    public boolean isDomainRoot() {
        return this.branch == null;
    }

    protected String transformBranch(String s) {
        if (s == null || s.equals("/")) {
            return null;
        }
        int i = s.indexOf("/");
        Object[] split = s.substring(i + 1).split("/");
        ArrayUtils.reverse((Object[])split);
        return String.join((CharSequence)".", (CharSequence[])split);
    }

    @Override
    public String getPopulatorLocation(@NonNull String moduleId) {
        if (moduleId == null) {
            throw new NullPointerException("moduleId is marked @NonNull but is null");
        }
        if (this.branch != null) {
            return null;
        }
        return moduleId + "." + this.appContext.stringConstants.DOMAIN_NAME_PREFIX() + this.domain + this.appContext.stringConstants.POPULATOR_SERVICE_SUFFIX() + ".";
    }

    @Override
    public String getRootIndependentLocation(@NonNull String moduleId) {
        if (moduleId == null) {
            throw new NullPointerException("moduleId is marked @NonNull but is null");
        }
        return moduleId + this.appContext.stringConstants.UTILITY_MODULE_PREFIX() + this.domain + ".";
    }

    @Override
    public String getRootHostedLocation(@NonNull String moduleId) {
        if (moduleId == null) {
            throw new NullPointerException("moduleId is marked @NonNull but is null");
        }
        return moduleId + "." + this.appContext.stringConstants.DOMAIN_NAME_PREFIX() + this.domain + HashUtils.hash3(this.domain) + this.appContext.stringConstants.HOSTED_RECORD_SUFFIX() + ".";
    }
}

