/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.api;

import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import uk.num.numlib.api.NumAPI;
import uk.num.numlib.api.NumAPICallbacks;
import uk.num.numlib.api.NumAPIContext;
import uk.num.numlib.api.UserVariable;
import uk.num.numlib.exc.NumBadModuleConfigDataException;
import uk.num.numlib.exc.NumBadModuleIdException;
import uk.num.numlib.exc.NumBadRecordException;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumDNSQueryException;
import uk.num.numlib.exc.NumInvalidDNSHostException;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumInvalidPopulatorResponseCodeException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.exc.NumMaximumRedirectsExceededException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.NumNotImplementedException;
import uk.num.numlib.exc.NumPopulatorErrorException;
import uk.num.numlib.exc.RrSetHeaderFormatException;
import uk.num.numlib.exc.RrSetIncompleteException;
import uk.num.numlib.exc.RrSetNoHeadersException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.ctx.NumAPIContextBase;
import uk.num.numlib.internal.dns.DNSServices;
import uk.num.numlib.internal.dns.DNSServicesDefaultImpl;
import uk.num.numlib.internal.modl.ModlServices;
import uk.num.numlib.internal.modl.NumLookupRedirect;
import uk.num.numlib.internal.modl.NumQueryRedirect;
import uk.num.numlib.internal.modl.PopulatorResponse;
import uk.num.numlib.internal.module.Module;
import uk.num.numlib.internal.module.ModuleConfig;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.module.ModuleFactory;
import uk.num.numlib.internal.util.NonBlankString;
import uk.num.numlib.internal.util.PopulatorRetryConfig;

public class NumAPIImpl
implements NumAPI {
    private static final Logger log = LogManager.getLogger(NumAPIImpl.class);
    public static final String MATCH_NUM_RECORDS = "(_n=[0-9]+;.*)|(^\\d+\\|.*)|(\\d+\\/\\d+\\|_n=\\d+;.*)";
    private final AppContext appContext = new AppContext();
    private final ModuleFactory moduleFactory = new ModuleFactory();
    private DNSServices dnsServices;
    private ModlServices modlServices;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public NumAPIImpl() {
        log.info("enter - NumAPI()");
        this.dnsServices = new DNSServicesDefaultImpl();
        this.modlServices = new ModlServices();
        log.info("NumAPI object created.");
    }

    public NumAPIImpl(DNSServices dnsServices, String dnsHost) throws NumInvalidDNSHostException {
        this();
        this.dnsServices = dnsServices;
        log.info("enter - NumAPI({})", (Object)dnsHost);
        try {
            if (!StringUtils.isEmpty((CharSequence)dnsHost)) {
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                Lookup.setDefaultResolver((Resolver)resolver);
            }
        }
        catch (UnknownHostException e) {
            log.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        log.info("NumAPI object created.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NumAPIImpl(String[] dnsHosts) throws NumInvalidDNSHostException, NumInvalidParameterException {
        this();
        log.info("enter - NumAPI({})", (Object)Arrays.toString(dnsHosts));
        if (dnsHosts == null || dnsHosts.length == 0) {
            log.error("No DNS hosts supplied.");
            throw new NumInvalidParameterException("No DNS hosts supplied.");
        }
        try {
            if (dnsHosts.length == 1) {
                String dnsHost = dnsHosts[0];
                if (StringUtils.isEmpty((CharSequence)dnsHost)) {
                    log.error("Empty hostname in the dnsHosts parameter.");
                    throw new NumInvalidDNSHostException("Empty hostname in the dnsHosts parameter.");
                }
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                Lookup.setDefaultResolver((Resolver)resolver);
            } else {
                ExtendedResolver resolver = new ExtendedResolver(dnsHosts);
                Lookup.setDefaultResolver((Resolver)resolver);
            }
        }
        catch (UnknownHostException e) {
            log.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        log.info("NumAPI object created.");
    }

    public NumAPIImpl(String dnsHost, int port) throws NumInvalidDNSHostException {
        this();
        log.info("NumAPI({}, {})", (Object)dnsHost, (Object)port);
        try {
            if (!StringUtils.isEmpty((CharSequence)dnsHost)) {
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                resolver.setPort(port);
                Lookup.setDefaultResolver((Resolver)resolver);
                this.setTCPOnly(true);
            }
        }
        catch (UnknownHostException e) {
            log.error("UnknownHostException", (Throwable)e);
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
        log.info("NumAPI object created.");
    }

    @Override
    public void setTCPOnly(boolean flag) {
        log.info("Use TCP only : {}", (Object)flag);
        Lookup.getDefaultResolver().setTCP(flag);
    }

    @Override
    public void setTopLevelZone(String zone) throws NumInvalidParameterException {
        log.info("setTopLevelZone({})", (Object)zone);
        if (StringUtils.isEmpty((CharSequence)zone)) {
            throw new NumInvalidParameterException("zone cannot be null or empty");
        }
        this.appContext.stringConstants.setTopLevelZone(zone);
    }

    @Override
    public void setPopulatorTopLevelZone(String populatorTopLevelZone) throws NumInvalidParameterException {
        log.info("setPopulatorTopLevelZone({})", (Object)populatorTopLevelZone);
        if (StringUtils.isEmpty((CharSequence)populatorTopLevelZone)) {
            throw new NumInvalidParameterException("populatorTopLevelZone cannot be null or empty");
        }
        this.appContext.stringConstants.setPopulatorTopLevelZone(populatorTopLevelZone);
    }

    @Override
    public NumAPIContext begin(String moduleId, String numId, int timeoutMillis) throws NumBadModuleIdException, NumBadModuleConfigDataException, NumBadURLException, NumInvalidParameterException, NumBadRecordException, NumDNSQueryException, NumInvalidDNSQueryException, RrSetNoHeadersException, RrSetHeaderFormatException, RrSetIncompleteException {
        log.info("enter - begin({}, {}, {})", (Object)moduleId, (Object)numId, (Object)timeoutMillis);
        assert (timeoutMillis > 0);
        NumAPIContextBase ctx = new NumAPIContextBase();
        ModuleDNSQueries moduleDNSQueries = this.moduleFactory.getInstance(this.appContext, NonBlankString.of(moduleId), NonBlankString.of(numId));
        ctx.setModuleDNSQueries(moduleDNSQueries);
        Record[] records = this.dnsServices.getConfigFileTXTRecords(this.appContext, moduleId, timeoutMillis);
        if (records == null || records.length == 0) {
            log.error("No configuration moduleDNSQueries file available. Check that the moduleDNSQueries ID is correct.: {}", (Object)moduleId);
            throw new NumBadModuleIdException("No configuration moduleDNSQueries file available. Check that the moduleDNSQueries ID is correct.: " + moduleId);
        }
        String configTxt = this.dnsServices.rebuildTXTRecordContent(records).replaceAll("\\\\", "");
        ModuleConfig moduleConfig = this.modlServices.interpretModuleConfig(configTxt);
        if (!moduleConfig.isValid()) {
            log.error("The module config file is invalid. {}", (Object)configTxt);
            throw new NumBadModuleConfigDataException("Invalid module config data: " + configTxt);
        }
        ctx.setModuleConfig(moduleConfig);
        log.info("Module configuration: {}", (Object)moduleConfig);
        log.info("exit - begin()");
        return ctx;
    }

    @Override
    public Future<String> retrieveNumRecord(NumAPIContext ctx, NumAPICallbacks handler, int timeoutMillis) {
        log.info("retrieveNumRecord()");
        assert (ctx != null);
        assert (handler != null);
        log.info("Submitting background query.");
        Future<String> future = this.executor.submit(() -> {
            String result = this.numLookup(ctx, handler, timeoutMillis);
            if (result == null) {
                log.error("Unable to retrieve a NUM record.");
                handler.setLocation(null);
                ctx.setLocation(null);
                return null;
            }
            handler.setResult(result);
            return result;
        });
        log.info("Background query running.");
        return future;
    }

    private String numLookup(NumAPIContext ctx, NumAPICallbacks handler, int timeoutMillis) throws NumBadRecordException, NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException, NumNotImplementedException, NumInvalidDNSQueryException, NumMaximumRedirectsExceededException, NumNoRecordAvailableException, NumPopulatorErrorException, NumInvalidPopulatorResponseCodeException, RrSetHeaderFormatException, RrSetIncompleteException, RrSetNoHeadersException {
        NumAPIContextBase context = (NumAPIContextBase)ctx;
        context.setLocation(NumAPICallbacks.Location.INDEPENDENT);
        log.info("Trying the INDEPENDENT location.");
        ModuleConfig moduleConfig = context.getModuleConfig();
        while (true) {
            try {
                String numRecord;
                block14: {
                    block9: while (true) {
                        Optional<String> maybeZDR;
                        if ((numRecord = this.getNumRecord(timeoutMillis, context)) != null && !numRecord.matches(MATCH_NUM_RECORDS)) {
                            numRecord = null;
                        }
                        if ((maybeZDR = Optional.ofNullable(numRecord).filter(this.isZoneDistributionRecord())).isPresent()) {
                            Optional<String> maybeNewLookupResult = maybeZDR.map(this.removeZDRPrefix()).map(Integer::parseInt).map(this.checkRangeAndLogErrors(context, numRecord)).filter(this.validZDRRange()).map(this.handleZoneDistributionRecord(context)).map(s -> {
                                try {
                                    return this.getNumRecord(timeoutMillis, context);
                                }
                                catch (Exception e) {
                                    log.error("Failed in lookup: {}", (Object)context.getRecordLocation());
                                    return null;
                                }
                            });
                            numRecord = maybeNewLookupResult.orElse(null);
                        }
                        Module module = moduleConfig.getModule();
                        if (numRecord != null) break block14;
                        log.info("Lookup returned no result.");
                        switch (context.getLocation()) {
                            case INDEPENDENT: {
                                log.info("Trying the HOSTED location.");
                                context.setLocation(NumAPICallbacks.Location.HOSTED);
                                continue block9;
                            }
                            case HOSTED: {
                                if (module.isPsq() && context.getModuleDNSQueries().isRootQuery()) {
                                    log.info("Trying the POPULATOR location.");
                                    context.setLocation(NumAPICallbacks.Location.POPULATOR);
                                } else {
                                    log.info("Not configured to use the POPULATOR location.");
                                    context.setLocation(NumAPICallbacks.Location.STOP);
                                    return null;
                                }
                            }
                            case POPULATOR: {
                                log.info("Trying the POPULATOR.");
                                String fromPopulator = this.getNumRecordFromPopulator(timeoutMillis, context, handler);
                                String json = this.interpretNumRecord(fromPopulator, context);
                                handler.setResult(json);
                                return handler.getResult();
                            }
                        }
                        break;
                    }
                    return null;
                }
                String json = this.interpretNumRecord(numRecord, context);
                handler.setResult(json);
                return handler.getResult();
            }
            catch (NumLookupRedirect numLookupRedirect) {
                context.setLocation(NumAPICallbacks.Location.INDEPENDENT);
                context.handleQueryRedirect(this.appContext, NonBlankString.of(numLookupRedirect.getRedirect()), context);
                continue;
            }
            catch (NumQueryRedirect numQueryRedirect) {
                context.handleQueryRedirect(this.appContext, NonBlankString.of(numQueryRedirect.getRedirect()), context);
                continue;
            }
            break;
        }
    }

    private Function<Integer, String> handleZoneDistributionRecord(NumAPIContextBase context) {
        return n -> {
            log.info("Handling a Zone Distribution Record for {}", (Object)context.getRecordLocation());
            context.getModuleDNSQueries().setEmailRecordDistributionLevels(this.appContext, (int)n);
            return context.getRecordLocation();
        };
    }

    private Predicate<Integer> validZDRRange() {
        return n -> n > 0 && n <= 3;
    }

    private Function<Integer, Integer> checkRangeAndLogErrors(NumAPIContextBase context, String numRecord) {
        return n -> {
            if (n < 1 || n > 3) {
                log.error("Invalid Zone Distribution Record number of levels in '{}' when looking up '{}'", (Object)numRecord, (Object)context.getRecordLocation());
            }
            return n;
        };
    }

    private Function<String, String> removeZDRPrefix() {
        return s -> s.substring(this.appContext.stringConstants.ZONE_DISTRIBUTION_RECORD_PREFIX().length());
    }

    private Predicate<String> isZoneDistributionRecord() {
        return s -> s.startsWith(this.appContext.stringConstants.ZONE_DISTRIBUTION_RECORD_PREFIX());
    }

    private String getNumRecordFromPopulator(int timeoutMillis, NumAPIContextBase context, NumAPICallbacks handler) throws NumPopulatorErrorException, NumNoRecordAvailableException, NumInvalidPopulatorResponseCodeException, NumBadRecordException, NumNotImplementedException, NumInvalidDNSQueryException, RrSetHeaderFormatException, RrSetIncompleteException, RrSetNoHeadersException, NumInvalidParameterException {
        log.info("getNumRecordFromPopulator()");
        String recordLocation = context.getModuleDNSQueries().getPopulatorLocation();
        if (recordLocation == null) {
            return null;
        }
        log.info("Querying the populator service: {}", (Object)recordLocation);
        String numRecord = null;
        while (numRecord == null && (numRecord = this.getNumRecordNoCache(timeoutMillis, context, NonBlankString.of(recordLocation))) != null) {
            log.info("Response from Populator: {}.", (Object)numRecord);
            PopulatorResponse response = this.modlServices.interpretPopulatorResponse(numRecord);
            if (!response.isValid()) {
                throw new NumInvalidPopulatorResponseCodeException("Bad response received from the populator service.");
            }
            if (response.getStatus_() != null) {
                numRecord = this.handlePopulatorStatusCodes(timeoutMillis, context, response, handler);
            }
            if (response.getError_() == null) continue;
            if (response.getError_().getCode() == 100) {
                log.error("NUM Populator error: {}, {}", (Object)response.getError_().getCode(), (Object)response.getError_().getDescription());
                try {
                    for (int i = 0; i < PopulatorRetryConfig.ERROR_RETRIES; ++i) {
                        log.info("Sleeping for {} seconds.", (Object)PopulatorRetryConfig.ERROR_RETRY_DELAYS[i]);
                        TimeUnit.MILLISECONDS.sleep(PopulatorRetryConfig.ERROR_RETRY_DELAYS[i]);
                        log.info("Retrying...");
                        numRecord = this.getNumRecord(timeoutMillis, context);
                        PopulatorResponse retryResponse = this.modlServices.interpretPopulatorResponse(numRecord);
                        if (retryResponse.getStatus_() == null) continue;
                        return this.handlePopulatorStatusCodes(timeoutMillis, context, retryResponse, handler);
                    }
                }
                catch (InterruptedException e) {
                    log.error("Interrupted", (Throwable)e);
                }
                log.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            log.error("NUM Populator error: {}, {}", (Object)response.getError_().getCode(), (Object)response.getError_().getDescription());
            throw new NumPopulatorErrorException(response.getError_().getDescription());
        }
        return numRecord;
    }

    private String handlePopulatorStatusCodes(int timeoutMillis, NumAPIContextBase context, PopulatorResponse response, NumAPICallbacks handler) throws NumNoRecordAvailableException, NumInvalidPopulatorResponseCodeException, NumInvalidDNSQueryException, NumNotImplementedException, RrSetHeaderFormatException, RrSetIncompleteException, RrSetNoHeadersException, NumInvalidParameterException {
        log.info("handlePopulatorStatusCodes()");
        String numRecord = null;
        switch (response.getStatus_().getCode()) {
            case 1: {
                log.info("Populator Status code: 1");
                try {
                    context.setLocation(NumAPICallbacks.Location.POPULATOR);
                    for (int i = 0; i < PopulatorRetryConfig.RETRY_DELAYS.length; ++i) {
                        log.info("Sleeping for {} seconds.", (Object)PopulatorRetryConfig.RETRY_DELAYS[i]);
                        TimeUnit.MILLISECONDS.sleep(PopulatorRetryConfig.RETRY_DELAYS[i]);
                        log.info("Retrying...");
                        numRecord = this.getNumRecord(timeoutMillis, context);
                        if (numRecord == null || numRecord.contains("status_") || numRecord.contains("error_")) continue;
                        try {
                            String interpretNumRecord = this.interpretNumRecord(numRecord, context);
                            handler.setResult(interpretNumRecord);
                            continue;
                        }
                        catch (Throwable e) {
                            log.error("Error in response from the populator.", e);
                        }
                    }
                    if (numRecord != null && (numRecord.contains("status_") || !numRecord.contains("error_"))) {
                        log.error("Cannot retrieve NUM record from any location.");
                        throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
                    }
                    return numRecord;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            case 2: {
                log.info("Populator Status code: 2");
                context.setLocation(NumAPICallbacks.Location.INDEPENDENT);
                numRecord = this.getNumRecord(timeoutMillis, context);
                if (numRecord != null) break;
                log.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            case 3: {
                log.info("Populator Status code: 3");
                context.setLocation(NumAPICallbacks.Location.HOSTED);
                numRecord = this.getNumRecord(timeoutMillis, context);
                if (numRecord != null) break;
                log.error("Cannot retrieve NUM record from any location.");
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            case 999: {
                numRecord = response.getNumRecord();
                break;
            }
            default: {
                context.setLocation(null);
                log.error("Invalid response code from DNS populator service: {}", (Object)response.getStatus_().getCode());
                throw new NumInvalidPopulatorResponseCodeException("Invalid response code from DNS populator service: " + response.getStatus_().getCode());
            }
        }
        return numRecord;
    }

    private String getInterpretedNumRecordAsJson(String moduleNumber, ModuleConfig moduleConfig, String numRecord) throws NumBadRecordException, NumQueryRedirect, NumLookupRedirect {
        log.info("getInterpretedNumRecordAsJson({}, moduleConfig, {})", (Object)moduleNumber, (Object)numRecord);
        StringBuilder numRecordBuffer = new StringBuilder();
        UserVariable[] ruv = moduleConfig.getModule().getUv();
        if (ruv != null) {
            for (UserVariable v : ruv) {
                numRecordBuffer.append(v.getKey());
                numRecordBuffer.append("=");
                numRecordBuffer.append(v.getValue());
                numRecordBuffer.append(";");
            }
        }
        numRecordBuffer.append("*load=\"http://modules.num.uk/");
        numRecordBuffer.append(moduleNumber);
        numRecordBuffer.append("/rcf.txt!\";");
        numRecordBuffer.append(numRecord);
        log.info("Interpret NUM record: {}", (Object)numRecordBuffer.toString());
        return this.modlServices.interpretNumRecord(numRecordBuffer.toString());
    }

    private String interpretNumRecord(String numRecord, NumAPIContextBase context) throws NumLookupRedirect, NumBadRecordException, NumQueryRedirect {
        log.info("interpretNumRecord({}, context)", (Object)numRecord);
        String json = null;
        if (numRecord != null && numRecord.trim().length() > 0) {
            json = this.getInterpretedNumRecordAsJson(context.getModuleDNSQueries().getModuleId(), context.getModuleConfig(), numRecord);
        }
        return json;
    }

    private String getNumRecord(int timeoutMillis, NumAPIContextBase context) throws NumInvalidDNSQueryException, NumNotImplementedException, NumNoRecordAvailableException, RrSetHeaderFormatException, RrSetIncompleteException, RrSetNoHeadersException, NumInvalidParameterException {
        String recordLocation = context.getRecordLocation();
        if (recordLocation == null) {
            return null;
        }
        log.info("getNumRecord({}, context, {})", (Object)timeoutMillis, (Object)recordLocation);
        Record[] recordFromDns = this.dnsServices.getRecordFromDnsNoCache(NonBlankString.of(recordLocation), timeoutMillis, context.getModuleConfig().getModule().isDsr());
        if (recordFromDns == null || recordFromDns.length == 0) {
            return null;
        }
        return this.dnsServices.rebuildTXTRecordContent(recordFromDns);
    }

    private String getNumRecordNoCache(int timeoutMillis, NumAPIContextBase context, NonBlankString recordLocation) throws NumInvalidDNSQueryException, NumNotImplementedException, NumNoRecordAvailableException, RrSetHeaderFormatException, RrSetIncompleteException, RrSetNoHeadersException {
        log.info("getNumRecordNoCache({}, context, {})", (Object)timeoutMillis, (Object)recordLocation);
        Record[] recordFromDns = this.dnsServices.getRecordFromDnsNoCache(recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
        if (recordFromDns == null || recordFromDns.length == 0) {
            return null;
        }
        return this.dnsServices.rebuildTXTRecordContent(recordFromDns);
    }

    @Override
    public void shutdown() {
        log.info("shutdown()");
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Shutdown interrupted: ", (Throwable)e);
        }
        finally {
            if (!this.executor.isTerminated()) {
                log.info("Failed to shutdown after 1 second, so forcing shutdown.");
                this.executor.shutdownNow();
            }
        }
        log.info("Shutdown complete.");
    }
}

