package uk.num.numlib.internal.modl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;

/**
 * A response from the populator service.
 *
 * @author tonywalmsley
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Getter
@Setter
public class PopulatorResponse {
    public static final int VALID_TXT_RECORD_CODE = 999;
    /**
     * Error object
     */
    private PopulatorResponseRecord error_;
    /**
     * Status object
     */
    private PopulatorResponseRecord status_;

    /**
     * The NUM record returned by the DNS responder if it has one less than 2 minutes old.
     */
    private String numRecord;


    public boolean isValid() {
        if (status_ == null && error_ == null) {
            return false;
        }
        if (status_ != null) {
            final int code = status_.getCode();
            if (code < 1 || (code > 3 && code != VALID_TXT_RECORD_CODE)) {
                return false;
            }
        }
        if (error_ != null) {
            final int code = error_.getCode();
            return code >= 100 && code <= 104;
        }
        return true;
    }
}
