/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vavr.API;
import io.vavr.Predicates;
import io.vavr.collection.Vector;
import java.net.IDN;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import uk.modl.extractors.StarLoadExtractor;
import uk.modl.model.PairValue;
import uk.modl.model.ValueItem;

public final class Util {
    public static final String INVALID_CHARS = "!$-+'#^*\u00a3&";
    private static final Pattern METHODS_PATTERN = Pattern.compile("replace<[^.]*>|r<[^.]*>|t<[^<>]+>|trim<[^<>]+>|initcap|[^.]\\w+|\\w|u|e|p|s|i|d|[^%.][0-9]+");
    private static final Pattern replacerPattern = Pattern.compile("^replace<(.*),(.*)>$|^r<(.*),(.*)>$");
    private static final Pattern trimmerPattern = Pattern.compile("^trim<(.*)>$|^t<(.*)>$");

    public static String jsonNodeToString(JsonNode jsonNode) {
        try {
            return new ObjectMapper().writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String unquote(String text) {
        if (text != null) {
            if (text.startsWith("`") && text.endsWith("`")) {
                return StringUtils.unwrap((String)text, (String)"`");
            }
            return StringUtils.unwrap((String)text, (String)"\"");
        }
        return null;
    }

    public static String replacer(String spec, String s) {
        Matcher matcher = replacerPattern.matcher(spec);
        if (matcher.find()) {
            String text = matcher.group(1) != null ? matcher.group(1) : matcher.group(3);
            String rep = matcher.group(2) != null ? matcher.group(2) : matcher.group(4);
            String newText = Util.unquote(rep);
            String oldtext = Util.unquote(text);
            return s.replace(oldtext, newText);
        }
        throw new RuntimeException("Invalid method: " + spec);
    }

    public static String trimmer(String spec, String s) {
        Matcher matcher = trimmerPattern.matcher(spec);
        if (matcher.find()) {
            String text = Util.getMatcherGroup(matcher);
            int i = s.indexOf(text);
            if (i > -1) {
                return s.substring(0, i);
            }
        } else {
            throw new RuntimeException("Invalid method: " + spec);
        }
        return s;
    }

    private static String getMatcherGroup(Matcher matcher) {
        return matcher.group(1) != null ? matcher.group(1) : matcher.group(2);
    }

    public static boolean greaterThanAll(ValueItem lhs, Vector<ValueItem> values) {
        return !values.find(v -> {
            double v2 = Util.toDouble(v.toString());
            return Util.toDouble(lhs.toString()) <= v2;
        }).isDefined();
    }

    private static double toDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid numeric value: " + e.getMessage());
        }
    }

    public static boolean greaterThanOrEqualToAll(ValueItem lhs, Vector<ValueItem> values) {
        return !values.find(v -> {
            double v2 = Util.toDouble(v.toString());
            return Util.toDouble(lhs.toString()) < v2;
        }).isDefined();
    }

    public static boolean lessThanAll(ValueItem lhs, Vector<ValueItem> values) {
        return !values.find(v -> {
            double v2 = Util.toDouble(v.toString());
            return Util.toDouble(lhs.toString()) >= v2;
        }).isDefined();
    }

    public static boolean lessThanOrEqualToAll(ValueItem lhs, Vector<ValueItem> values) {
        return !values.find(v -> {
            double v2 = Util.toDouble(v.toString());
            return Util.toDouble(lhs.toString()) > v2;
        }).isDefined();
    }

    public static boolean truthy(PairValue value) {
        if (value != null) {
            String s = value.toString();
            return !s.equalsIgnoreCase("null") && !s.equalsIgnoreCase("000") && !s.equalsIgnoreCase("00") && !s.equalsIgnoreCase("false");
        }
        return false;
    }

    public static String handleMethodsAndTrailingPathComponents(String[] refList, String valueStr) {
        for (String pathComponent : refList) {
            valueStr = Util.handlePathComponent(valueStr, pathComponent);
        }
        return valueStr;
    }

    private static String handlePathComponent(String valueStr, String pathComponent) {
        String unquoted = Util.unquote(valueStr);
        String finalValueStr = valueStr;
        API.Match.Case[] caseArray = new API.Match.Case[7];
        caseArray[0] = API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new String[]{"p", "punydecode"})), () -> Util.replacePunycode(unquoted));
        caseArray[1] = API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new String[]{"u", "upcase"})), unquoted::toUpperCase);
        caseArray[2] = API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new String[]{"d", "downcase"})), unquoted::toLowerCase);
        caseArray[3] = API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new String[]{"i", "initcap"})), () -> WordUtils.capitalize((String)unquoted));
        caseArray[4] = API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new String[]{"s", "sentence"})), () -> StringUtils.capitalize((String)unquoted));
        caseArray[5] = API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.isIn((Object[])new String[]{"e", "urlencode"})), () -> Util.urlEncode(finalValueStr));
        caseArray[6] = API.Case((API.Match.Pattern0)API.$(), () -> Util.doReplaceOrTrim(unquoted, pathComponent));
        return (String)API.Match((Object)pathComponent).of(caseArray);
    }

    private static String doReplaceOrTrim(String valueStr, String pathComponent) {
        if (Util.isReplaceMethod(pathComponent)) {
            valueStr = Util.replacer(pathComponent, valueStr);
        } else if (Util.isTrimMethod(pathComponent)) {
            valueStr = Util.trimmer(pathComponent, valueStr);
        }
        return valueStr;
    }

    private static String urlEncode(String valueStr) {
        try {
            valueStr = URLEncoder.encode(valueStr, StandardCharsets.UTF_8.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing URL encoding instruction: " + e.getMessage());
        }
        return valueStr;
    }

    private static boolean isTrimMethod(String pathComponent) {
        return pathComponent.startsWith("t<") || pathComponent.startsWith("trim<");
    }

    private static boolean isReplaceMethod(String pathComponent) {
        return pathComponent.startsWith("r<") || pathComponent.startsWith("replace<");
    }

    public static String replacePunycode(String s) {
        if (s == null) {
            return null;
        }
        return IDN.toUnicode("xn--" + s);
    }

    public static Vector<String> toMethodList(String chainedMethods) {
        Matcher matcher = METHODS_PATTERN.matcher(chainedMethods);
        Vector methods = Vector.empty();
        while (matcher.find()) {
            methods = methods.append((Object)matcher.group(0));
        }
        return methods;
    }

    public static StarLoadExtractor.FileSpec normalize(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        String normalized = text;
        if (Util.isGraved(normalized)) {
            normalized = StringUtils.unwrap((String)normalized, (String)"`");
        } else if (Util.isDoubleQuoted(normalized)) {
            normalized = StringUtils.unwrap((String)normalized, (String)"\"");
        }
        boolean forceLoad = normalized.endsWith("!");
        normalized = StringUtils.removeEnd((String)normalized, (String)"!");
        if (Util.hasNoExtension(normalized)) {
            normalized = normalized + ".modl";
        }
        normalized = normalized.replace("~://", "://");
        return StarLoadExtractor.FileSpec.of(normalized, forceLoad);
    }

    private static boolean hasNoExtension(String normalized) {
        return !normalized.endsWith(".modl") && !normalized.endsWith(".txt");
    }

    private static boolean isDoubleQuoted(String normalized) {
        return normalized.length() > 1 && normalized.startsWith("\"") && normalized.endsWith("\"");
    }

    private static boolean isGraved(String normalized) {
        return normalized.length() > 1 && normalized.startsWith("`") && normalized.endsWith("`");
    }

    public static String unwrapLiteral(String literal) {
        if (literal == null || !literal.startsWith("%`")) {
            return literal;
        }
        return StringUtils.unwrap((String)literal.substring(1), (String)"`");
    }

    public static void validatePairKey(String newKey) {
        String k = Util.maybeStripLeadingSpecialCharacter(newKey);
        int badCharIndex = StringUtils.indexOfAny((CharSequence)k, (String)INVALID_CHARS);
        if (badCharIndex > -1) {
            throw new RuntimeException("Invalid key - \"" + k.charAt(badCharIndex) + "\" character not allowed: " + newKey);
        }
        if (StringUtils.isNumeric((CharSequence)k)) {
            throw new RuntimeException("Invalid key - \"" + k + "\" - entirely numeric keys are not allowed: " + newKey);
        }
    }

    private static String maybeStripLeadingSpecialCharacter(String newKey) {
        return newKey.startsWith("_") || newKey.startsWith("*") ? newKey.substring(1) : newKey;
    }

    private Util() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

