/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ArrayConditionalReturn;
import uk.modl.model.ArrayItem;
import uk.modl.model.ConditionTest;
import uk.modl.utils.IDSource;

public final class ArrayConditional
implements ArrayItem,
Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<ConditionTest> tests;
    @NonNull
    private final Vector<ArrayConditionalReturn> returns;
    @NonNull
    private final Vector<ArrayItem> result;

    public static ArrayConditional of(Ancestry ancestry, Parent parent, Vector<ConditionTest> tests, Vector<ArrayConditionalReturn> returns, Vector<ArrayItem> result) {
        ArrayConditional child = ArrayConditional.of(IDSource.nextId(), tests, returns, result);
        ancestry.add(parent, child);
        return child;
    }

    public ArrayConditional with(Ancestry ancestry, Vector<ConditionTest> tests, Vector<ArrayConditionalReturn> returns) {
        ArrayConditional child = ArrayConditional.of(this.id, tests, returns, this.result);
        ancestry.replaceChild(this, child);
        return child;
    }

    public ArrayConditional with(Ancestry ancestry, Vector<ArrayItem> result) {
        ArrayConditional child = ArrayConditional.of(this.id, this.tests, this.returns, result);
        ancestry.replaceChild(this, child);
        return child;
    }

    private ArrayConditional(long id, @NonNull Vector<ConditionTest> tests, @NonNull Vector<ArrayConditionalReturn> returns, @NonNull Vector<ArrayItem> result) {
        if (tests == null) {
            throw new NullPointerException("tests is marked non-null but is null");
        }
        if (returns == null) {
            throw new NullPointerException("returns is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.id = id;
        this.tests = tests;
        this.returns = returns;
        this.result = result;
    }

    public static ArrayConditional of(long id, @NonNull Vector<ConditionTest> tests, @NonNull Vector<ArrayConditionalReturn> returns, @NonNull Vector<ArrayItem> result) {
        return new ArrayConditional(id, tests, returns, result);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<ConditionTest> getTests() {
        return this.tests;
    }

    @NonNull
    public Vector<ArrayConditionalReturn> getReturns() {
        return this.returns;
    }

    @NonNull
    public Vector<ArrayItem> getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrayConditional)) {
            return false;
        }
        ArrayConditional other = (ArrayConditional)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "ArrayConditional(tests=" + this.getTests() + ", returns=" + this.getReturns() + ", result=" + this.getResult() + ")";
    }
}

