/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.utils;

import java.util.HashMap;
import java.util.Map;

public class SimpleCache<K, V> {
    private static final int SEVEN_DAYS = 604800000;
    private final Map<K, CacheEntry<V>> cache = new HashMap<K, CacheEntry<V>>();

    public boolean contains(K key) {
        return this.get(key) != null;
    }

    public void put(K key, V value) {
        CacheEntry<V> entry = new CacheEntry<V>(value, 604800000L + System.currentTimeMillis());
        this.cache.put(key, entry);
    }

    public V get(K key) {
        CacheEntry<V> entry = this.cache.get(key);
        if (entry == null || ((CacheEntry)entry).expiry < System.currentTimeMillis()) {
            if (entry != null) {
                this.cache.remove(key);
            }
            return null;
        }
        return (V)((CacheEntry)entry).value;
    }

    private static class CacheEntry<V> {
        private final V value;
        private final long expiry;

        CacheEntry(V value, long expiry) {
            this.value = value;
            this.expiry = expiry;
        }
    }
}

