/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.transforms;

import io.vavr.collection.HashMap;
import io.vavr.collection.IndexedSeq;
import io.vavr.collection.Vector;
import io.vavr.control.Option;
import java.util.Objects;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Parent;
import uk.modl.model.Array;
import uk.modl.model.ArrayConditional;
import uk.modl.model.ArrayItem;
import uk.modl.model.FalsePrimitive;
import uk.modl.model.Map;
import uk.modl.model.MapItem;
import uk.modl.model.NullPrimitive;
import uk.modl.model.NumberPrimitive;
import uk.modl.model.Pair;
import uk.modl.model.PairValue;
import uk.modl.model.Primitive;
import uk.modl.model.StringPrimitive;
import uk.modl.model.Structure;
import uk.modl.model.TruePrimitive;
import uk.modl.model.ValueItem;
import uk.modl.transforms.StarClassTransform;
import uk.modl.transforms.TransformationContext;
import uk.modl.utils.SupertypeInference;
import uk.modl.utils.Util;

public class ClassExpansionTransform {
    private final ExpandedClassCache cache = new ExpandedClassCache();

    public Structure apply(TransformationContext ctx, Structure s) {
        if (s instanceof Map) {
            return this.processMap(ctx, (Map)s);
        }
        if (s instanceof Array) {
            return this.processArray(ctx, (Array)s);
        }
        if (s instanceof Pair) {
            PairValue value;
            Pair pair = (Pair)s;
            Structure structure = this.processPair(ctx, pair);
            if (structure == pair && (value = ((Pair)structure).getValue()) instanceof Map) {
                Map map = this.processMap(ctx, (Map)value);
                return pair.with(ctx.getAncestry(), map);
            }
            return structure;
        }
        return s;
    }

    private Structure processPair(TransformationContext ctx, Pair pair) {
        return this.expandToClass(ctx, pair);
    }

    private Structure expandToClass(TransformationContext ctx, Pair pair) {
        Option<StarClassTransform.ClassInstruction> maybeCi = ctx.getClassByNameOrId(pair.getKey());
        if (maybeCi.isDefined()) {
            StarClassTransform.ClassInstruction ci = maybeCi.get();
            String supertype = SupertypeInference.inferType(ctx, ci, pair.getValue());
            ExpandedClass expClass = this.cache.getExpandedClass(ctx, ci, supertype);
            switch (supertype) {
                case "map": {
                    return this.convertPairToMap(ctx, pair, expClass);
                }
                case "null": {
                    return this.convertPairToNull(ctx, pair, expClass);
                }
                case "arr": {
                    return this.convertPairToArray(ctx, pair, expClass);
                }
                case "num": {
                    return this.convertPairToNumber(ctx, pair, expClass);
                }
                case "str": {
                    return this.convertPairToString(ctx, pair, expClass);
                }
                case "bool": {
                    return this.convertPairToBoolean(ctx, pair, expClass);
                }
            }
            throw new RuntimeException("Invalid superclass: " + supertype);
        }
        return pair;
    }

    private Pair convertPairToMap(TransformationContext ctx, Pair pair, ExpandedClass expClass) {
        Pair structure;
        @NonNull PairValue pairValue = pair.getValue();
        if (pairValue instanceof Array) {
            return this.getPairFromArray(ctx, pair, expClass, (Array)pairValue);
        }
        if (pairValue instanceof Map) {
            return this.getPairFromMap(ctx, pair, expClass, (Map)pairValue);
        }
        if (pairValue instanceof Primitive && (structure = this.getPairFromPrimitive(ctx, pair, expClass, pairValue)) != null) {
            return structure;
        }
        return pair.with(ctx.getAncestry(), expClass.name, pairValue);
    }

    private Pair getPairFromPrimitive(TransformationContext ctx, Pair pair, ExpandedClass expClass, @NonNull PairValue pairValue) {
        if (pairValue == null) {
            throw new NullPointerException("pairValue is marked non-null but is null");
        }
        Ancestry ancestry = ctx.getAncestry();
        if (expClass.hasSingleValueAssign()) {
            Structure s = expClass.toMapUsingAssign(ctx, pair, this.cache, Array.of(ancestry, pair, Vector.of((ArrayItem)((Object)pairValue))));
            Structure structure = this.apply(ctx, s);
            if (structure instanceof ValueItem) {
                return pair.with(ancestry, expClass.name, (PairValue)((Object)structure));
            }
            throw new RuntimeException("Cannot store this item in a Pair: " + structure.toString());
        }
        if (expClass.assigns.isEmpty()) {
            Map map = expClass.toMapFromMap(ctx, Map.of(ancestry, pair, Vector.of(pair.with(ancestry, "value", pairValue))));
            Structure structure = this.apply(ctx, map);
            return pair.with(ancestry, expClass.name, (PairValue)((Object)structure));
        }
        return null;
    }

    private Pair getPairFromMap(TransformationContext ctx, Pair pair, ExpandedClass expClass, Map pairValue) {
        Map map = expClass.toMapFromMap(ctx, pairValue);
        Structure structure = this.apply(ctx, map);
        if (structure instanceof ValueItem) {
            return pair.with(ctx.getAncestry(), expClass.name, (PairValue)((Object)structure));
        }
        throw new RuntimeException("Cannot store this item in a Pair: " + structure.toString());
    }

    private Pair getPairFromArray(TransformationContext ctx, Pair pair, ExpandedClass expClass, Array pairValue) {
        Structure s = expClass.toMapUsingAssign(ctx, pair, this.cache, pairValue);
        Structure structure = this.apply(ctx, s);
        if (structure instanceof ValueItem) {
            return pair.with(ctx.getAncestry(), expClass.name, (PairValue)((Object)structure));
        }
        throw new RuntimeException("Cannot store this item in a Pair: " + structure.toString());
    }

    private Pair convertPairToNull(TransformationContext ctx, Pair pair, ExpandedClass expClass) {
        return pair.with(ctx.getAncestry(), expClass.name, NullPrimitive.instance);
    }

    private Pair convertPairToArray(TransformationContext ctx, Pair pair, ExpandedClass expClass) {
        @NonNull PairValue pairValue = pair.getValue();
        if (pairValue instanceof Array) {
            Array array;
            if (expClass.assigns.nonEmpty()) {
                array = expClass.toArrayUsingAssign(ctx, pair, this.cache, (Array)pairValue);
            } else {
                @NonNull Vector<ArrayItem> valuesToAssign = ((Array)pairValue).getArrayItems();
                int assignListLength = valuesToAssign.size();
                array = expClass.assigns.find(l -> l.size() == assignListLength).map(assignList -> this.assignListToArray(ctx, pair, expClass, valuesToAssign, assignListLength, (Vector<String>)assignList)).getOrElse(() -> (Array)pairValue);
            }
            Structure structure = this.apply(ctx, array);
            if (structure instanceof ValueItem) {
                return pair.with(ctx.getAncestry(), expClass.name, (PairValue)((Object)structure));
            }
            throw new RuntimeException("Cannot store this item in a Pair: " + structure.toString());
        }
        if (pairValue instanceof Primitive) {
            return pair.with(ctx.getAncestry(), expClass.name, Array.of(ctx.getAncestry(), pair, Vector.of((ArrayItem)((Object)pairValue))));
        }
        if (pairValue instanceof Map) {
            throw new RuntimeException("Cannot convert map to array: " + pairValue);
        }
        return pair.with(ctx.getAncestry(), expClass.name, pairValue);
    }

    private Array assignListToArray(TransformationContext ctx, Pair pair, ExpandedClass expClass, @NonNull Vector<ArrayItem> valuesToAssign, int assignListLength, Vector<String> assignList) {
        if (valuesToAssign == null) {
            throw new NullPointerException("valuesToAssign is marked non-null but is null");
        }
        Array arr = Array.of(ctx.getAncestry(), pair, Vector.empty());
        IndexedSeq<ArrayItem> items = Vector.empty();
        for (int i = 0; i < assignListLength; ++i) {
            String maybeWildcardKey = assignList.get(i);
            String key = maybeWildcardKey.endsWith("*") ? StringUtils.removeEnd(maybeWildcardKey, "*") : maybeWildcardKey;
            Pair p = Pair.of(ctx.getAncestry(), pair, key, (PairValue)((Object)valuesToAssign.get(i)));
            Structure structure = this.expandToClass(ctx, p);
            if (!(structure instanceof Pair)) continue;
            @NonNull PairValue value = ((Pair)structure).getValue();
            if (value instanceof Map) {
                Map map = Map.of(ctx.getAncestry(), pair, (Vector<MapItem>)((Map)value).getMapItems().appendAll((Iterable)expClass.pairs));
                items = ((Vector)items).append(map);
                continue;
            }
            if (!(value instanceof Array)) continue;
            Option<StarClassTransform.ClassInstruction> maybeClass = ctx.getClassByNameOrId(key);
            if (maybeClass.isDefined()) {
                StarClassTransform.ClassInstruction classs = maybeClass.get();
                ExpandedClass expandedClass = this.cache.getExpandedClass(ctx, classs, classs.getSuperclass());
                Structure expandedObject = expandedClass.toMapUsingAssign(ctx, pair, this.cache, (Structure)((Object)value));
                items = ((Vector)items).append((ArrayItem)((Object)expandedObject));
                continue;
            }
            items = ((Vector)items).appendAll(((Array)value).getArrayItems());
        }
        return arr.with(ctx.getAncestry(), (Vector<ArrayItem>)items);
    }

    private Pair convertPairToNumber(TransformationContext ctx, Pair pair, ExpandedClass expClass) {
        try {
            if (pair.getValue() instanceof NullPrimitive) {
                throw new RuntimeException("Superclass of \"" + expClass.id + "\" is num - cannot assign value \"" + pair.getValue().toString() + "\"");
            }
            if (pair.getValue() instanceof StringPrimitive) {
                throw new RuntimeException("Superclass of \"" + expClass.id + "\" is num - cannot assign value \"" + pair.getValue().toString() + "\"");
            }
            return pair.with(ctx.getAncestry(), expClass.name, NumberPrimitive.of(ctx.getAncestry(), pair, NumberUtils.createNumber(pair.getValue().toString()).toString()));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Superclass of \"" + expClass.id + "\" is num - cannot assign value \"" + pair.getValue().toString() + "\"");
        }
    }

    private Pair convertPairToString(TransformationContext ctx, Pair pair, ExpandedClass expClass) {
        @NonNull PairValue pairValue = pair.getValue();
        if (pairValue instanceof NullPrimitive) {
            throw new RuntimeException("Cannot convert null value to string.");
        }
        if (pairValue instanceof TruePrimitive) {
            return pair.with(ctx.getAncestry(), expClass.name, StringPrimitive.of(ctx.getAncestry(), pair, "true"));
        }
        if (pairValue instanceof FalsePrimitive) {
            return pair.with(ctx.getAncestry(), expClass.name, StringPrimitive.of(ctx.getAncestry(), pair, "false"));
        }
        return pair.with(ctx.getAncestry(), expClass.name, StringPrimitive.of(ctx.getAncestry(), pair, pair.getValue().toString()));
    }

    private Pair convertPairToBoolean(TransformationContext ctx, Pair pair, ExpandedClass expClass) {
        @NonNull PairValue value = pair.getValue();
        if (Util.truthy(value)) {
            return pair.with(ctx.getAncestry(), expClass.name, TruePrimitive.instance);
        }
        return pair.with(ctx.getAncestry(), expClass.name, FalsePrimitive.instance);
    }

    private Array processArray(TransformationContext ctx, Array array) {
        return array.with(ctx.getAncestry(), (Vector<ArrayItem>)array.getArrayItems().map(ai -> this.processArrayItem(ctx, (ArrayItem)ai)));
    }

    private ArrayItem processArrayItem(TransformationContext ctx, ArrayItem arrayItem) {
        if (arrayItem instanceof Map) {
            return this.processMap(ctx, (Map)arrayItem);
        }
        if (arrayItem instanceof Pair) {
            return (ArrayItem)((Object)this.processPair(ctx, (Pair)arrayItem));
        }
        if (arrayItem instanceof Array) {
            return this.processArray(ctx, (Array)arrayItem);
        }
        if (arrayItem instanceof Primitive) {
            return this.processPrimitive((Primitive)arrayItem);
        }
        return arrayItem;
    }

    private Primitive processPrimitive(Primitive primitive) {
        return primitive;
    }

    private Map processMap(TransformationContext ctx, Map map) {
        return map.with(ctx.getAncestry(), (Vector<MapItem>)map.getMapItems().map(mi -> this.processMapItem(ctx, (MapItem)mi)));
    }

    private MapItem processMapItem(TransformationContext ctx, MapItem mapItem) {
        if (mapItem instanceof Pair) {
            return (MapItem)((Object)this.processPair(ctx, (Pair)mapItem));
        }
        return mapItem;
    }

    private static class ExpandedClassCache {
        private final io.vavr.collection.Map<String, ExpandedClass> cache = HashMap.empty();

        private ExpandedClassCache() {
        }

        public ExpandedClass getExpandedClass(TransformationContext ctx, StarClassTransform.ClassInstruction ci, String supertype) {
            ExpandedClass expClass;
            Option<ExpandedClass> maybeExpandedClass = this.cache.get(ci.getId());
            if (maybeExpandedClass.isDefined()) {
                expClass = maybeExpandedClass.get();
            } else {
                expClass = ExpandedClass.of(ctx, ci, supertype);
                this.cache.put(ci.getId(), expClass);
            }
            return expClass;
        }
    }

    public static class ExpandedClass {
        private final String id;
        private final String name;
        private final String superclass;
        private final Vector<Vector<String>> assigns;
        private final Vector<Pair> pairs;

        public ExpandedClass(String id, String name, String superclass, Vector<Vector<String>> assigns, Vector<Pair> pairs) {
            this.id = id;
            this.name = name;
            this.superclass = superclass;
            this.assigns = assigns;
            this.pairs = pairs;
        }

        public static ExpandedClass of(TransformationContext ctx, StarClassTransform.ClassInstruction ci, String supertype) {
            String id = ci.getId();
            String name = ci.getNameOrId();
            Vector<Vector<String>> assigns = ExpandedClass.getAllAssigns(ctx, ci);
            io.vavr.collection.Map<String, Pair> pairs = ExpandedClass.getAllPairs(ctx, ci);
            return new ExpandedClass(id, name, supertype, assigns, pairs.values().toVector());
        }

        private static io.vavr.collection.Map<String, Pair> getAllPairs(TransformationContext ctx, StarClassTransform.ClassInstruction ci) {
            String superclass = ci.getSuperclass();
            io.vavr.collection.Map<String, Pair> pairs = ci.getPairs();
            io.vavr.collection.Map pairsFromSuperclasses = ctx.getClassByNameOrId(superclass).map(superCi -> ExpandedClass.getAllPairs(ctx, superCi)).getOrElse(HashMap.empty());
            return pairs.merge(pairsFromSuperclasses);
        }

        private static Vector<Vector<String>> getAllAssigns(TransformationContext ctx, StarClassTransform.ClassInstruction ci) {
            IndexedSeq assign = ci.getAssign().map(vectorOfArrayItems -> ((Array)vectorOfArrayItems).getArrayItems().map(Objects::toString));
            String superclass = ci.getSuperclass();
            return ((Vector)assign).appendAll((Iterable)ctx.getClassByNameOrId(superclass).map(superCi -> ExpandedClass.getAllAssigns(ctx, superCi)).getOrElse(Vector.empty()));
        }

        public Structure toMapUsingAssign(TransformationContext ctx, Parent parent, ExpandedClassCache cache, Structure value) {
            IndexedSeq<Object> tmpValuesToAssign = Vector.empty();
            if (value instanceof Array) {
                tmpValuesToAssign = ((Array)value).getArrayItems();
                if (this.assigns.isEmpty()) {
                    IndexedSeq strings = ((Vector)tmpValuesToAssign.map(Object::toString)).intersperse(", ");
                    String arrayStr = strings.foldLeft("[", (l, r) -> l + r) + "]";
                    throw new RuntimeException("Cannot convert array to map: " + arrayStr);
                }
            } else if (value instanceof Map) {
                tmpValuesToAssign = ((Map)value).getMapItems().map(mi -> (ArrayItem)((Object)mi));
            }
            Vector<Object> valuesToAssign = tmpValuesToAssign;
            int assignListLength = valuesToAssign.size();
            return (Structure)this.assigns.find(l -> this.isCorrectLengthOrWildcarded(assignListLength, (Vector<String>)l)).map(assignList -> this.assignListToStructure(ctx, parent, cache, (Vector<ArrayItem>)valuesToAssign, assignListLength, (Vector<String>)assignList)).getOrElseThrow(() -> new RuntimeException("No key list of the correct length in class " + this.id + " - looking for one of length " + assignListLength));
        }

        private boolean isCorrectLengthOrWildcarded(int assignListLength, Vector<String> l) {
            return l.size() == assignListLength || l.count(s -> s.endsWith("*")) > 0;
        }

        private Structure assignListToStructure(TransformationContext ctx, Parent parent, ExpandedClassCache cache, Vector<ArrayItem> valuesToAssign, int assignListLength, Vector<String> assignList) {
            Option<StarClassTransform.ClassInstruction> maybeClassByNameOrId;
            IndexedSeq arrayItems = Vector.empty();
            if (this.isSingleWildcardAssign(assignList) && this.isDefinedWithAssigns(maybeClassByNameOrId = ctx.getClassByNameOrId(StringUtils.removeEnd(assignList.get(0), "*")))) {
                StarClassTransform.ClassInstruction classs = maybeClassByNameOrId.get();
                ExpandedClass expandedClass = cache.getExpandedClass(ctx, classs, classs.getSuperclass());
                Array arr = Array.of(ctx.getAncestry(), parent, Vector.empty());
                for (int i = 0; i < assignListLength; ++i) {
                    ArrayItem item = valuesToAssign.get(i);
                    Structure s = expandedClass.toMapUsingAssign(ctx, arr, cache, (Structure)((Object)item));
                    arrayItems = arrayItems.append((ArrayItem)((Object)s));
                }
                arrayItems = arrayItems.appendAll(this.pairs);
                return arr.with(ctx.getAncestry(), (Vector<ArrayItem>)arrayItems);
            }
            IndexedSeq<MapItem> mapItems = Vector.empty();
            Map map = Map.of(ctx.getAncestry(), null, mapItems);
            for (int i = 0; i < assignListLength; ++i) {
                Vector<String> keys = assignList.size() == assignListLength ? assignList : this.extendAssignList(assignListLength, assignList);
                String key = keys.get(i);
                ArrayItem item = valuesToAssign.get(i);
                if (item instanceof Pair) {
                    mapItems = ((Vector)mapItems).append((MapItem)((Object)item));
                    continue;
                }
                if (item instanceof PairValue) {
                    mapItems = ((Vector)mapItems).append(Pair.of(ctx.getAncestry(), map, key, (PairValue)((Object)item)));
                    continue;
                }
                if (!(item instanceof ArrayConditional)) continue;
                mapItems = ((Vector)mapItems).append(Pair.of(ctx.getAncestry(), map, key, (PairValue)((Object)((ArrayConditional)item).getResult().get(0))));
            }
            mapItems = ((Vector)mapItems).appendAll(this.pairs);
            return map.with(ctx.getAncestry(), (Vector<MapItem>)mapItems);
        }

        private boolean isSingleWildcardAssign(Vector<String> assignList) {
            return assignList.length() == 1 && assignList.get(0).endsWith("*");
        }

        public Array toArrayUsingAssign(TransformationContext ctx, Parent parent, ExpandedClassCache cache, Array value) {
            Vector<ArrayItem> valuesToAssign = value.getArrayItems();
            int assignListLength = valuesToAssign.size();
            return (Array)this.assigns.find(l -> this.isCorrectLengthOrWildcarded(assignListLength, (Vector<String>)l)).map(assignList -> {
                IndexedSeq arrayItems = Vector.empty();
                if (this.isSingleWildcardAssign((Vector<String>)assignList)) {
                    Option<StarClassTransform.ClassInstruction> maybeClassByNameOrId = ctx.getClassByNameOrId(StringUtils.removeEnd((String)assignList.get(0), "*"));
                    if (this.isDefinedWithAssigns(maybeClassByNameOrId)) {
                        StarClassTransform.ClassInstruction classs = maybeClassByNameOrId.get();
                        ExpandedClass expandedClass = cache.getExpandedClass(ctx, classs, classs.getSuperclass());
                        Array arr = Array.of(ctx.getAncestry(), parent, Vector.empty());
                        for (int i = 0; i < assignListLength; ++i) {
                            ArrayItem item = (ArrayItem)valuesToAssign.get(i);
                            Structure s = expandedClass.toMapUsingAssign(ctx, arr, cache, (Structure)((Object)item));
                            arrayItems = ((Vector)arrayItems).append((ArrayItem)((Object)s));
                        }
                        arrayItems = ((Vector)arrayItems).appendAll(this.pairs);
                        return arr.with(ctx.getAncestry(), (Vector<ArrayItem>)arrayItems);
                    }
                    if (maybeClassByNameOrId.isDefined()) {
                        Array arr = Array.of(ctx.getAncestry(), parent, Vector.empty());
                        for (int i = 0; i < assignListLength; ++i) {
                            ArrayItem convertedItem;
                            String supertype;
                            StarClassTransform.ClassInstruction classs = maybeClassByNameOrId.get();
                            ArrayItem item = (ArrayItem)valuesToAssign.get(i);
                            switch (supertype = SupertypeInference.inferType(ctx, classs, (PairValue)((Object)item))) {
                                case "map": {
                                    throw new RuntimeException("Class '" + classs.getNameOrId() + "' is a map so needs a *assign instruction.");
                                }
                                case "null": {
                                    throw new RuntimeException("Class '" + classs.getNameOrId() + "' has a *superclass of null.");
                                }
                                case "arr": {
                                    convertedItem = Array.of(ctx.getAncestry(), arr, Vector.of(item));
                                    break;
                                }
                                case "num": {
                                    if (item instanceof NumberPrimitive) {
                                        convertedItem = item;
                                        break;
                                    }
                                    if (item instanceof StringPrimitive) {
                                        convertedItem = (ArrayItem)((Object)((StringPrimitive)item).numericValue());
                                        break;
                                    }
                                    if (item instanceof TruePrimitive) {
                                        convertedItem = NumberPrimitive.of(ctx.getAncestry(), arr, "1");
                                        break;
                                    }
                                    if (item instanceof FalsePrimitive) {
                                        convertedItem = NumberPrimitive.of(ctx.getAncestry(), arr, "0");
                                        break;
                                    }
                                    if (item instanceof NullPrimitive) {
                                        convertedItem = NumberPrimitive.of(ctx.getAncestry(), arr, "0");
                                        break;
                                    }
                                    throw new RuntimeException("Class '" + classs.getNameOrId() + "' cannot convert '" + item + "' to a numeric value.");
                                }
                                case "str": {
                                    if (item instanceof NumberPrimitive) {
                                        convertedItem = StringPrimitive.of(ctx.getAncestry(), arr, ((NumberPrimitive)item).getValue());
                                        break;
                                    }
                                    if (item instanceof StringPrimitive) {
                                        convertedItem = item;
                                        break;
                                    }
                                    if (item instanceof TruePrimitive) {
                                        convertedItem = StringPrimitive.of(ctx.getAncestry(), arr, "true");
                                        break;
                                    }
                                    if (item instanceof FalsePrimitive) {
                                        convertedItem = StringPrimitive.of(ctx.getAncestry(), arr, "false");
                                        break;
                                    }
                                    if (item instanceof NullPrimitive) {
                                        convertedItem = StringPrimitive.of(ctx.getAncestry(), arr, "null");
                                        break;
                                    }
                                    throw new RuntimeException("Class '" + classs.getNameOrId() + "' cannot convert '" + item + "' to a string value.");
                                }
                                case "bool": {
                                    if (item instanceof TruePrimitive) {
                                        convertedItem = item;
                                        break;
                                    }
                                    if (item instanceof FalsePrimitive) {
                                        convertedItem = item;
                                        break;
                                    }
                                    throw new RuntimeException("Class '" + classs.getNameOrId() + "' cannot convert '" + item + "' to a boolean value.");
                                }
                                default: {
                                    throw new RuntimeException("Invalid superclass: " + supertype);
                                }
                            }
                            arrayItems = ((Vector)arrayItems).append(convertedItem);
                        }
                        return arr.with(ctx.getAncestry(), (Vector<ArrayItem>)arrayItems);
                    }
                }
                Array arr = Array.of(ctx.getAncestry(), parent, Vector.empty());
                for (int i = 0; i < assignListLength; ++i) {
                    Option<StarClassTransform.ClassInstruction> maybeClassByNameOrId = ctx.getClassByNameOrId(StringUtils.removeEnd((String)assignList.get(i), "*"));
                    if (!this.isDefinedWithAssigns(maybeClassByNameOrId)) continue;
                    StarClassTransform.ClassInstruction classs = maybeClassByNameOrId.get();
                    ExpandedClass expandedClass = cache.getExpandedClass(ctx, classs, classs.getSuperclass());
                    ArrayItem item = (ArrayItem)valuesToAssign.get(i);
                    Structure s = expandedClass.toMapUsingAssign(ctx, arr, cache, (Structure)((Object)item));
                    arrayItems = ((Vector)arrayItems).append((ArrayItem)((Object)s));
                }
                arrayItems = ((Vector)arrayItems).appendAll(this.pairs);
                return arr.with(ctx.getAncestry(), (Vector<ArrayItem>)arrayItems);
            }).getOrElseThrow(() -> new RuntimeException("No key list of the correct length in class " + this.id + " - looking for one of length " + assignListLength));
        }

        private boolean isDefinedWithAssigns(Option<StarClassTransform.ClassInstruction> maybeClassByNameOrId) {
            return maybeClassByNameOrId.isDefined() && maybeClassByNameOrId.get().getAssign().nonEmpty();
        }

        private Vector<String> extendAssignList(int len, Vector<String> list) {
            return list.find(s -> s.endsWith("*")).map(wild -> StringUtils.removeEnd(wild, "*")).map(s -> this.extendAssignList(len, list, (String)s)).getOrElse(list);
        }

        private Vector<String> extendAssignList(int len, Vector<String> list, String s) {
            int numberOfNonWildcardKeys = list.size() - 1;
            int numberOfAdditionalKeys = len - numberOfNonWildcardKeys;
            return list.map(key -> this.extendedKeyList(s, numberOfAdditionalKeys, (String)key)).foldLeft(Vector.empty(), Vector::appendAll);
        }

        private Vector<String> extendedKeyList(String s, int numberOfAdditionalKeys, String key) {
            if (key.endsWith("*")) {
                return Vector.fill(numberOfAdditionalKeys, s);
            }
            return Vector.of(key);
        }

        public Map toMapFromMap(TransformationContext ctx, Map map) {
            return map.with(ctx.getAncestry(), (Vector<MapItem>)map.getMapItems().appendAll(this.pairs));
        }

        public boolean hasSingleValueAssign() {
            return this.assigns.count(v -> v.size() == 1) > 0;
        }

        public String toString() {
            return "ClassExpansionTransform.ExpandedClass(id=" + this.id + ", name=" + this.name + ", superclass=" + this.superclass + ", assigns=" + this.assigns + ", pairs=" + this.pairs + ")";
        }
    }
}

