/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.ConditionTest;
import uk.modl.model.Structure;
import uk.modl.model.TopLevelConditionalReturn;
import uk.modl.utils.IDSource;

public final class TopLevelConditional
implements Structure,
Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<ConditionTest> tests;
    @NonNull
    private final Vector<TopLevelConditionalReturn> returns;
    @NonNull
    private final Vector<Structure> result;

    public static TopLevelConditional of(Ancestry ancestry, Parent parent, Vector<ConditionTest> tests, Vector<TopLevelConditionalReturn> returns, Vector<Structure> result) {
        TopLevelConditional child = TopLevelConditional.of(IDSource.nextId(), tests, returns, result);
        ancestry.add(parent, child);
        return child;
    }

    public TopLevelConditional with(Ancestry ancestry, Vector<ConditionTest> tests, Vector<TopLevelConditionalReturn> returns) {
        TopLevelConditional child = TopLevelConditional.of(this.id, tests, returns, this.result);
        ancestry.replaceChild(this, child);
        return child;
    }

    public TopLevelConditional with(Ancestry ancestry, Vector<Structure> result) {
        TopLevelConditional child = TopLevelConditional.of(this.id, this.tests, this.returns, result);
        ancestry.replaceChild(this, child);
        return child;
    }

    private TopLevelConditional(long id, @NonNull Vector<ConditionTest> tests, @NonNull Vector<TopLevelConditionalReturn> returns, @NonNull Vector<Structure> result) {
        if (tests == null) {
            throw new NullPointerException("tests is marked non-null but is null");
        }
        if (returns == null) {
            throw new NullPointerException("returns is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.id = id;
        this.tests = tests;
        this.returns = returns;
        this.result = result;
    }

    public static TopLevelConditional of(long id, @NonNull Vector<ConditionTest> tests, @NonNull Vector<TopLevelConditionalReturn> returns, @NonNull Vector<Structure> result) {
        return new TopLevelConditional(id, tests, returns, result);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<ConditionTest> getTests() {
        return this.tests;
    }

    @NonNull
    public Vector<TopLevelConditionalReturn> getReturns() {
        return this.returns;
    }

    @NonNull
    public Vector<Structure> getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopLevelConditional)) {
            return false;
        }
        TopLevelConditional other = (TopLevelConditional)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "TopLevelConditional(tests=" + this.getTests() + ", returns=" + this.getReturns() + ", result=" + this.getResult() + ")";
    }
}

