/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import org.apache.commons.lang3.math.NumberUtils;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.Primitive;
import uk.modl.utils.IDSource;

public final class StringPrimitive
implements Primitive,
Child {
    private final long id;
    private final String value;

    public static StringPrimitive of(Ancestry ancestry, Parent parent, String value) {
        StringPrimitive child = StringPrimitive.of(IDSource.nextId(), value);
        ancestry.add(parent, child);
        return child;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Number numericValue() {
        return NumberUtils.createNumber(this.value);
    }

    public StringPrimitive with(Ancestry ancestry, String value) {
        StringPrimitive child = StringPrimitive.of(this.id, value);
        ancestry.replaceChild(this, child);
        return child;
    }

    private StringPrimitive(long id, String value) {
        this.id = id;
        this.value = value;
    }

    public static StringPrimitive of(long id, String value) {
        return new StringPrimitive(id, value);
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringPrimitive)) {
            return false;
        }
        StringPrimitive other = (StringPrimitive)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }
}

