/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.model;

import io.vavr.collection.Vector;
import lombok.NonNull;
import uk.modl.ancestry.Ancestry;
import uk.modl.ancestry.Child;
import uk.modl.ancestry.Parent;
import uk.modl.model.Structure;
import uk.modl.utils.IDSource;

public final class Modl
implements Parent,
Child {
    private final long id;
    @NonNull
    private final Vector<Structure> structures;

    public static Modl of(Ancestry ancestry, Parent parent, Vector<Structure> structures) {
        Modl child = Modl.of(IDSource.nextId(), structures);
        ancestry.add(parent, child);
        return child;
    }

    public Modl with(Ancestry ancestry, Vector<Structure> structures) {
        Modl child = Modl.of(this.id, structures);
        ancestry.replaceChild(this, child);
        return child;
    }

    private Modl(long id, @NonNull Vector<Structure> structures) {
        if (structures == null) {
            throw new NullPointerException("structures is marked non-null but is null");
        }
        this.id = id;
        this.structures = structures;
    }

    public static Modl of(long id, @NonNull Vector<Structure> structures) {
        return new Modl(id, structures);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @NonNull
    public Vector<Structure> getStructures() {
        return this.structures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Modl)) {
            return false;
        }
        Modl other = (Modl)o;
        return this.getId() == other.getId();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        return result;
    }

    public String toString() {
        return "Modl(structures=" + this.getStructures() + ")";
    }
}

