/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Stack;
import org.slf4j.MDC;

public class NDC {
    public static final String PREFIX = "NDC";

    public static void clear() {
        int depth = NDC.getDepth();
        for (int i = 0; i < depth; ++i) {
            String key = PREFIX + i;
            MDC.remove(key);
        }
    }

    public static Stack cloneStack() {
        return null;
    }

    public static void inherit(Stack stack) {
    }

    public static String get() {
        return null;
    }

    public static int getDepth() {
        String val2;
        int i = 0;
        while ((val2 = MDC.get(PREFIX + i)) != null) {
            ++i;
        }
        return i;
    }

    public static String pop() {
        int next = NDC.getDepth();
        if (next == 0) {
            return "";
        }
        int last = next - 1;
        String key = PREFIX + last;
        String val2 = MDC.get(key);
        MDC.remove(key);
        return val2;
    }

    public static String peek() {
        int next = NDC.getDepth();
        if (next == 0) {
            return "";
        }
        int last = next - 1;
        String key = PREFIX + last;
        String val2 = MDC.get(key);
        return val2;
    }

    public static void push(String message) {
        int next = NDC.getDepth();
        MDC.put(PREFIX + next, message);
    }

    public static void remove() {
        NDC.clear();
    }

    public static void setMaxDepth(int maxDepth) {
    }
}

