/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.payments.commons.testing.pact.consumers;

import au.com.dius.pact.consumer.junit.PactProviderRule;
import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.RequestResponsePact;
import com.google.common.io.Resources;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import uk.gov.service.payments.commons.testing.pact.consumers.Pacts;
import uk.gov.service.payments.commons.testing.port.PortFactory;

public class PayPactProviderRule
extends PactProviderRule {
    private String methodName;
    private List<String> pactsToDelete = new ArrayList<String>();

    public PayPactProviderRule(String provider, Object target) {
        super(provider, "localhost", Integer.valueOf(PortFactory.findFreePort()), target);
    }

    public Statement apply(final Statement base, final Description description) {
        this.methodName = description.getMethodName();
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    PayPactProviderRule.super.apply(base, description).evaluate();
                }
                finally {
                    PayPactProviderRule.this.after();
                }
            }
        };
    }

    protected Map<String, RequestResponsePact> getPacts(String fragment) {
        HashMap<String, RequestResponsePact> pacts = new HashMap<String, RequestResponsePact>();
        for (Method m : this.target.getClass().getMethods()) {
            if (!m.getName().equals(this.methodName)) continue;
            Optional.ofNullable((Pacts[])m.getAnnotationsByType(Pacts.class)).ifPresent(pactsAnnotation -> Arrays.stream(pactsAnnotation).forEach(p -> Arrays.stream(p.pacts()).forEach(fileName -> {
                if (fileName.contains(this.provider)) {
                    RequestResponsePact pact = (RequestResponsePact)DefaultPactReader.INSTANCE.loadPact((Object)new FileSource(new File(Resources.getResource((String)String.format("pacts/%s.json", fileName)).getFile())));
                    pacts.put(this.provider, pact);
                }
                if (!p.publish()) {
                    this.pactsToDelete.add(String.format("%s.json", fileName));
                }
            })));
        }
        return pacts;
    }

    protected void after() {
        this.pactsToDelete.stream().forEach(s -> {
            File file = new File(Paths.get("", "target", "pacts", s).toAbsolutePath().toString());
            file.delete();
        });
    }
}

