/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.payments.commons.testing.db;

import com.google.common.base.Stopwatch;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.LogConfig;
import com.spotify.docker.client.messages.PortBinding;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresContainer {
    private static final Logger logger = LoggerFactory.getLogger(PostgresContainer.class);
    private final String containerId;
    private final int port;
    private final DockerClient docker;
    private volatile boolean stopped = false;
    private final String dbPassword;
    private final String dbUsername;
    private static final int DB_TIMEOUT_SEC = 15;
    private static final String INTERNAL_PORT = "5432";

    public PostgresContainer(DockerClient docker, String imageName, String dbUsername, String dbPassword) throws InterruptedException, IOException, DockerException {
        this.docker = docker;
        this.dbPassword = dbPassword;
        this.dbUsername = dbUsername;
        this.failsafeDockerPull(docker, imageName);
        docker.listImages(new DockerClient.ListImagesParam[]{DockerClient.ListImagesParam.create((String)"name", (String)imageName)});
        HostConfig hostConfig = HostConfig.builder().logConfig(LogConfig.create((String)"json-file")).publishAllPorts(Boolean.valueOf(true)).build();
        ContainerConfig containerConfig = ContainerConfig.builder().image(imageName).hostConfig(hostConfig).env(new String[]{"POSTGRES_USER=" + dbUsername, "POSTGRES_PASSWORD=" + dbPassword}).build();
        this.containerId = docker.createContainer(containerConfig).id();
        docker.startContainer(this.containerId);
        this.port = PostgresContainer.hostPortNumber(docker.inspectContainer(this.containerId));
        this.registerShutdownHook();
        this.waitForPostgresToStart();
    }

    public PostgresContainer() throws InterruptedException, IOException, ClassNotFoundException, DockerCertificateException, DockerException {
        this((DockerClient)DefaultDockerClient.fromEnv().build(), "govukpay/postgres:11.1", "postgres", "mysecretpassword");
    }

    public PostgresContainer(String imageTag) throws InterruptedException, IOException, DockerCertificateException, DockerException {
        this((DockerClient)DefaultDockerClient.fromEnv().build(), String.format("postgres:%s", imageTag), "postgres", "mysecretpassword");
    }

    public String getUsername() {
        return this.dbUsername;
    }

    public String getPassword() {
        return this.dbPassword;
    }

    public String getConnectionUrl() {
        return "jdbc:postgresql://" + this.docker.getHost() + ":" + this.port + "/";
    }

    private void failsafeDockerPull(DockerClient docker, String image) {
        try {
            docker.pull(image);
        }
        catch (Exception e) {
            logger.error("Docker image " + image + " could not be pulled from DockerHub", (Throwable)e);
        }
    }

    private static int hostPortNumber(ContainerInfo containerInfo) {
        List portBindings = (List)containerInfo.networkSettings().ports().get((Object)"5432/tcp");
        logger.info("Postgres host port: {}", (Object)portBindings.stream().map(PortBinding::hostPort).collect(Collectors.joining(", ")));
        return Integer.parseInt(((PortBinding)portBindings.get(0)).hostPort());
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    private void waitForPostgresToStart() throws DockerException, InterruptedException, IOException {
        Stopwatch timer = Stopwatch.createStarted();
        boolean succeeded = false;
        while (!succeeded && timer.elapsed(TimeUnit.SECONDS) < 15L) {
            Thread.sleep(500L);
            succeeded = this.checkPostgresConnection();
        }
        if (!succeeded) {
            throw new RuntimeException("Postgres did not start in 15 seconds.");
        }
        logger.info("Postgres docker container started in {}.", (Object)timer.elapsed(TimeUnit.MILLISECONDS));
    }

    private boolean checkPostgresConnection() {
        boolean bl;
        block8: {
            Properties props = new Properties();
            props.setProperty("user", this.dbUsername);
            props.setProperty("password", this.dbPassword);
            Connection connection = DriverManager.getConnection(this.getConnectionUrl(), props);
            try {
                bl = true;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception except) {
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        try {
            this.stopped = true;
            System.out.println("Killing postgres container with ID: " + this.containerId);
            LogStream logs = this.docker.logs(this.containerId, new DockerClient.LogsParam[]{DockerClient.LogsParam.stdout(), DockerClient.LogsParam.stderr()});
            System.out.println("Killed container logs:\n");
            logs.attach((OutputStream)System.out, (OutputStream)System.err);
            this.docker.stopContainer(this.containerId, 5);
            this.docker.removeContainer(this.containerId);
        }
        catch (DockerException | IOException | InterruptedException e) {
            System.err.println("Could not shutdown " + this.containerId);
            e.printStackTrace();
        }
    }
}

