/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.payments.commons.testing.db;

import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import java.io.IOException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import uk.gov.service.payments.commons.testing.db.PostgresContainer;

public class PostgresDockerRule
implements TestRule {
    private static PostgresContainer container;

    public PostgresDockerRule() {
        this.startPostgresIfNecessary();
    }

    public String getConnectionUrl() {
        return container.getConnectionUrl();
    }

    public Statement apply(Statement statement, Description description) {
        return statement;
    }

    private void startPostgresIfNecessary() {
        try {
            if (container == null) {
                container = new PostgresContainer();
            }
        }
        catch (DockerCertificateException | DockerException | IOException | ClassNotFoundException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUsername() {
        return container.getUsername();
    }

    public String getPassword() {
        return container.getPassword();
    }

    public void stop() {
        container.stop();
        container = null;
    }

    public String getDriverClass() {
        return "org.postgresql.Driver";
    }
}

