/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.payments.commons.testing.db;

import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.exceptions.DockerException;
import java.io.IOException;
import org.junit.jupiter.api.extension.Extension;
import uk.gov.service.payments.commons.testing.db.PostgresContainer;

public class PostgresDockerExtension
implements Extension {
    private static PostgresContainer container;

    public PostgresDockerExtension() {
        this.startPostgresIfNecessary();
    }

    public String getConnectionUrl() {
        return container.getConnectionUrl();
    }

    private void startPostgresIfNecessary() {
        try {
            if (container == null) {
                container = new PostgresContainer();
            }
        }
        catch (DockerCertificateException | DockerException | IOException | ClassNotFoundException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUsername() {
        return container.getUsername();
    }

    public String getPassword() {
        return container.getPassword();
    }

    public void stop() {
        container.stop();
        container = null;
    }

    public String getDriverClass() {
        return "org.postgresql.Driver";
    }
}

