/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spicule.seleniumscripter;

import com.spicule.ashot.AShot;
import com.spicule.ashot.Screenshot;
import com.spicule.ashot.shooting.ShootingStrategies;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.NotActiveException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.management.AttributeNotFoundException;
import jdk.nashorn.internal.objects.annotations.Getter;
import jdk.nashorn.internal.objects.annotations.Setter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumScripter {
    private static final int MAJOR = 1;
    private static final int MINOR = 7;
    private static final int PATCH = 8;
    private boolean DEV_MODE = false;
    private final String url;
    private final WebDriver driver;
    private final long defaultWaitTimeout = 30L;
    private final List<String> snapshots = new ArrayList<String>();
    private final List<String> capturedLabel = new ArrayList<String>();
    private final Map<String, Object> scriptVariables = new HashMap<String, Object>();
    public static final Logger LOG = LoggerFactory.getLogger(SeleniumScripter.class);
    private String outputPath = "./";
    private Map<String, Object> masterScript;
    private final Map<String, List> captureLists = new HashMap<String, List>();

    public SeleniumScripter(WebDriver driver) {
        LOG.info(SeleniumScripter.version());
        this.driver = driver;
        this.url = driver.getCurrentUrl();
    }

    public SeleniumScripter(WebDriver driver, boolean DEV_MODE) {
        LOG.info(SeleniumScripter.version());
        this.driver = driver;
        this.url = driver.getCurrentUrl();
        this.DEV_MODE = DEV_MODE;
        if (this.DEV_MODE) {
            LOG.warn("Development mode is enabled!");
        }
    }

    public static final String version() {
        return "SeleniumScripter v1.7.8";
    }

    public static List slice(String slice, List list) throws ParseException {
        if (!slice.matches("-{0,1}[0-9]+:-{0,1}[0-9]+")) {
            throw new ParseException("Invalid slice specification, must match pattern: `^-{0,1}[0-9]+:-{0,1}[0-9]+$`!", 0);
        }
        String[] parts = slice.split(":");
        int start = Integer.parseInt(parts[0]);
        int end = Integer.parseInt(parts[1]);
        if (start < 0) {
            start += list.size();
        }
        if (end < 0) {
            end += list.size();
        }
        return list.subList(start, end);
    }

    private Number parseNumber(String number) throws ParseException {
        Scanner scan = new Scanner(number);
        if (scan.hasNextInt()) {
            return Integer.parseInt(number);
        }
        if (scan.hasNextDouble()) {
            return Double.parseDouble(number);
        }
        throw new ParseException("Invalid numeric type: \"" + number + "\"", 0);
    }

    private String exceptionToSlugName(Exception e) {
        String[] parts = e.getClass().toString().split("\\.");
        return parts[parts.length - 1].toLowerCase();
    }

    private void validate(Map<String, Object> script, String requiredField) throws ParseException {
        this.validate(script, new String[]{requiredField});
    }

    private void validate(Map<String, Object> script, String[] requiredFields) throws ParseException {
        for (String r : requiredFields) {
            if (script.containsKey(r)) continue;
            throw new ParseException("Expected `" + r + "` field in block: `" + script + "`, but none was found!", 0);
        }
    }

    private void deprecated(String name) {
        LOG.error("The `" + name + "` operation is deprecated and will eventually be removed in favor of the `for` operation!");
    }

    private By by(String selector, String name) throws ParseException {
        switch (selector) {
            case "id": {
                return By.id((String)name);
            }
            case "class": {
                return By.className((String)name);
            }
            case "css": 
            case "cssSelector": {
                return By.cssSelector((String)name);
            }
            case "xpath": {
                return By.xpath((String)name);
            }
            case "name": {
                return By.name((String)name);
            }
        }
        throw new ParseException("Invalid selector type: `" + selector + "`", 0);
    }

    private String getDateString() {
        Date date = new Date();
        return new SimpleDateFormat("yyyy_MM_dd_HH-mm-ss.SSS").format(date);
    }

    private String resolveExpressionValue(String expression) throws ParseException {
        String resolved = String.valueOf(expression);
        Pattern identifierPattern = Pattern.compile("\\{[a-zA-Z_][a-zA-Z_0-9]*}");
        Matcher matches = identifierPattern.matcher(resolved);
        while (matches.find()) {
            String identifier = matches.group();
            String name = identifier.subSequence(1, identifier.length() - 1).toString();
            Object value = this.scriptVariables.get(name);
            if (value == null) {
                throw new ParseException("Variable `" + name + "` not instantiated!", 0);
            }
            resolved = resolved.replace(identifier, value.toString());
            matches = identifierPattern.matcher(resolved);
        }
        return resolved;
    }

    @Getter
    public String getElementXPath(WebElement element) {
        return (String)((JavascriptExecutor)this.driver).executeScript("gPt=function(c){if(c.id!==''){return'[@id=\"'+c.id+'\"]'}if(c===document.body){return c.tagName}var a=0;var e=c.parentNode.childNodes;for(var b=0;b<e.length;b++){var d=e[b];if(d===c){return gPt(c.parentNode)+'/'+c.tagName+'['+(a+1)+']'}if(d.nodeType===1&&d.tagName===c.tagName){a++}}};return gPt(arguments[0]);", new Object[]{element});
    }

    public void runScript(Map<String, Object> script) throws IOException, AttributeNotFoundException, ParseException, InterruptedException, StopIteration {
        if (this.masterScript == null) {
            this.masterScript = script;
        }
        for (Map.Entry<String, Object> instruction : script.entrySet()) {
            String instructionName = instruction.getKey().toString();
            Object instructionBlock = instruction.getValue();
            if (instructionBlock instanceof Map) {
                Map subscript = (Map)instructionBlock;
                String operation = subscript.getOrDefault("operation", "{UNDEFINED}").toString().toLowerCase();
                LOG.info("Executing `" + operation + "` operation in block `" + instructionName + "` with " + operation.length() + " fields!");
                switch (operation.toLowerCase()) {
                    case "{undefined}": {
                        LOG.warn("Found the " + instructionName + " block with no defined operation! Skipping...");
                        break;
                    }
                    case "alert": {
                        this.alertOperation(subscript);
                        break;
                    }
                    case "break": {
                        this.breakOperation(subscript);
                        break;
                    }
                    case "capturelist": {
                        this.captureListOperation(subscript);
                        break;
                    }
                    case "capturelisttosnapshots": {
                        this.captureListToSnapshotsOperation(subscript);
                        break;
                    }
                    case "click": {
                        this.clickOperation(subscript);
                        break;
                    }
                    case "clicklistitem": {
                        this.clickListItemOperation(subscript);
                        break;
                    }
                    case "do_while": {
                        this.doWhileOperation(subscript);
                        break;
                    }
                    case "dumpstack": {
                        this.dumpStackOperation(subscript);
                        break;
                    }
                    case "execute_js": {
                        this.executeJavascriptOperation(subscript);
                        break;
                    }
                    case "filter": {
                        this.filterOperation(subscript);
                        break;
                    }
                    case "for": {
                        this.forOperation(subscript);
                        break;
                    }
                    case "if": {
                        this.ifOperation(subscript);
                        break;
                    }
                    case "injectcontent": {
                        LOG.warn("The `injectcontent` has been renamed to `pushsnapshot`!");
                    }
                    case "pushsnapshot": {
                        this.pushSnapshot(subscript);
                        break;
                    }
                    case "injectelement": {
                        this.injectAdjacentElement(subscript);
                        break;
                    }
                    case "jsback": {
                        this.jsBackOperation();
                        break;
                    }
                    case "jsclick": {
                        this.jsClickOperation(subscript);
                        break;
                    }
                    case "jsrefresh": {
                        this.jsRefreshOperation();
                        break;
                    }
                    case "keys": {
                        this.keysOperation(subscript);
                        break;
                    }
                    case "loop": {
                        this.loopOperation(subscript);
                        break;
                    }
                    case "loadpage": {
                        this.loadPageOperation(subscript);
                        break;
                    }
                    case "noop": {
                        break;
                    }
                    case "pause": {
                        this.pauseOperation(subscript);
                        break;
                    }
                    case "restore": {
                        this.restoreOperation(subscript);
                        break;
                    }
                    case "screenshot": {
                        this.screenshotOperation(subscript);
                        break;
                    }
                    case "select": {
                        this.selectOperation(subscript);
                        break;
                    }
                    case "set": {
                        this.setOperation(subscript);
                        break;
                    }
                    case "snapshot": {
                        this.snapshotOperation(subscript);
                        break;
                    }
                    case "token": {
                        this.getTokenOperation(subscript);
                        break;
                    }
                    case "try": {
                        this.tryOperation(subscript);
                        break;
                    }
                    case "wait": {
                        this.waitOperation(subscript);
                        break;
                    }
                    default: {
                        throw new ParseException("Invalid operation: " + operation, 0);
                    }
                }
                continue;
            }
            if (instructionBlock instanceof String && instructionName.toLowerCase().equals("version")) {
                System.out.println("Version: " + instructionBlock);
                continue;
            }
            throw new ParseException("Subscript did not convert to map!", 0);
        }
    }

    private void alertOperation(Map<String, Object> script) throws ParseException {
        Alert alert;
        this.validate(script, "action");
        String action = script.get("action").toString().toLowerCase();
        long timeout = Long.parseLong(script.getOrDefault("timeout", 30L).toString());
        LOG.info("Attempting to `" + action + "` alert within " + timeout + "s...");
        try {
            alert = (Alert)new WebDriverWait(this.driver, timeout).until((Function)ExpectedConditions.alertIsPresent());
        }
        catch (NoAlertPresentException | TimeoutException e) {
            LOG.warn("Waited for an alert to appear within " + timeout + "s but none was found!");
            return;
        }
        switch (action) {
            case "accept": {
                alert.accept();
                break;
            }
            case "dismiss": {
                alert.dismiss();
                break;
            }
            case "keys": {
                this.validate(script, "name");
                String name = script.get("name").toString();
                alert.sendKeys(name);
                break;
            }
            default: {
                throw new ParseException("Unsupported action: `" + action + "`!", 0);
            }
        }
    }

    @Deprecated
    private void loopOperation(Map<String, Object> script) throws ParseException {
        this.deprecated("loop");
        this.validate(script, new String[]{"variable", "subscript"});
        String variableName = script.get("variable").toString();
        if (this.captureLists.containsKey(variableName)) {
            List list = this.captureLists.get(variableName);
            LOG.info("Iterating over list: " + list);
            for (Object v : list) {
                this.scriptVariables.put(variableName, v);
                Map subscripts = (Map)this.masterScript.get("subscripts");
                Map<String, Object> subscript = SeleniumScripter.convertToTreeMap((Map)subscripts.get(script.get("subscript")));
                try {
                    this.runScript(subscript);
                }
                catch (Exception e) {
                    LOG.error("Caught the following exception inside loop:");
                    e.printStackTrace();
                    if (script.containsKey("exitOnError") && (!script.containsKey("exitOnError") || !script.get("exitOnError").equals(true))) continue;
                    break;
                }
            }
        } else {
            LOG.info("No capturelist of that name found");
        }
    }

    private void runSubsequence(List<Map<String, String>> sequence) throws IOException, AttributeNotFoundException, ParseException, InterruptedException, StopIteration {
        for (Map<String, String> instruction : sequence) {
            HashMap<String, Object> instructionBlock = new HashMap<String, Object>();
            instructionBlock.put("subsequence", instruction);
            this.runScript(instructionBlock);
        }
    }

    private boolean guardedSubsequence(List<Map<String, String>> sequence) {
        try {
            this.runSubsequence(sequence);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Deprecated
    private void captureListOperation(Map<String, Object> script) throws ParseException {
        this.deprecated("capturelist");
        this.validate(script, new String[]{"selector", "name"});
        String selector = script.get("selector").toString();
        String name = script.get("name").toString();
        String variable = script.get("variable").toString();
        List webElements = this.driver.findElements(this.by(selector, name));
        String type = "text";
        if (script.containsKey("collect")) {
            type = script.get("collect").toString();
        }
        if (script.containsKey("type")) {
            type = script.get("type").toString();
        }
        ArrayList<String> strlist = new ArrayList<String>();
        for (WebElement el : webElements) {
            LOG.info("Capture Element Found: " + el.getText());
            if ("text".equals(type)) {
                strlist.add(el.getText());
                continue;
            }
            if ("elements".equals(type)) {
                strlist.add((String)el);
                continue;
            }
            if (!"xpath".equals(type)) continue;
            strlist.add(this.getElementXPath(el));
        }
        LOG.info("Storing capture list as `" + variable + "`!");
        String append = "false";
        if (script.containsKey("append")) {
            append = script.get("append").toString();
        }
        if (append.equals("false")) {
            this.captureLists.put(variable, strlist);
        } else if (append.equals("true")) {
            List list = this.captureLists.get(variable);
            ArrayList<String> newList = new ArrayList<String>(list);
            newList.addAll(strlist);
            this.captureLists.put(variable, newList);
        }
    }

    @Deprecated
    private void captureListToSnapshotsOperation(Map<String, Object> subscript) {
        this.deprecated("capturelisttosnapshots");
        if (this.captureLists.containsKey(subscript.get("variable").toString())) {
            List l = this.captureLists.get(subscript.get("variable").toString());
            for (Object m : l) {
                String sshot = JSONValue.toJSONString(m);
                this.snapshots.add(sshot);
            }
        } else {
            LOG.error("No capturelists named " + subscript.get("variable").toString() + " to convert to snapshots.");
        }
    }

    private void clickListItemOperation(Map<String, Object> script) throws ParseException {
        this.validate(script, new String[]{"selector", "name"});
        String selector = script.get("selector").toString();
        String name = script.get("name").toString();
        name = this.resolveExpressionValue(name);
        List element = this.driver.findElements(this.by(selector, name));
        int i = ((Double)script.get("item")).intValue();
        LOG.info("Clicking list item: `" + element.toString() + "` of " + i);
        ((WebElement)element.get(i)).click();
    }

    private void clickOperation(Map<String, Object> script) throws ParseException, InterruptedException {
        this.validate(script, new String[]{"selector", "name"});
        String selector = script.get("selector").toString();
        String name = script.get("name").toString();
        long delay = Long.parseLong(script.getOrDefault("delay", 0).toString());
        name = this.resolveExpressionValue(name);
        WebElement element = this.driver.findElement(this.by(selector, name));
        ((JavascriptExecutor)this.driver).executeScript("arguments[0].scrollIntoView();", new Object[]{element});
        LOG.info("Clicking element with " + selector + " of `" + name + "`");
        element.click();
        LOG.info("Waiting for " + delay + "s before continuing...");
        Thread.sleep(delay * 1000L);
    }

    private void filterOperation(Map<String, Object> script) {
        String tovariable = script.get("tovariable").toString();
        String filterType = script.get("type").toString();
        if (filterType.equals("filtermap")) {
            List matches = new ArrayList();
            matches = (List)this.executeGroovyScript(script.get("evaluation").toString());
            this.captureLists.put(tovariable, matches);
        }
    }

    private Object executeGroovyScript(String script) {
        Binding sharedData = new Binding();
        GroovyShell shell = new GroovyShell(sharedData);
        sharedData.setProperty("capturelists", this.captureLists);
        Object result = shell.evaluate(script);
        return result;
    }

    private void executeJavascriptOperation(Map<String, Object> script) throws ParseException {
        this.validate(script, "javascriptOperator");
        Boolean sendauth = Boolean.parseBoolean(script.getOrDefault("authheader", false).toString());
        if (script.containsKey("javascriptOperator")) {
            String name = script.get("javascriptOperator").toString();
            if (sendauth.booleanValue()) {
                name = name.replace("{bearer_token}", this.scriptVariables.get("bearer_token").toString());
            }
            Object v = this.scriptVariables.get(script.get("replace"));
            if (name.contains("{variable}")) {
                if (script.containsKey("variableMapValue") && v instanceof Map) {
                    String mapvalue = ((Map)v).get(script.get("variableMapValue").toString()).toString();
                    name = name.replace("{variable}", mapvalue);
                } else {
                    name = name.replace("{variable}", v.toString());
                }
            }
            Object resp = ((JavascriptExecutor)this.driver).executeAsyncScript(name, new Object[0]);
            List list = this.captureLists.get(script.get("variable"));
            ArrayList newList = new ArrayList();
            if (list != null) {
                newList = new ArrayList(list);
            }
            if (resp != null) {
                newList.addAll((ArrayList)resp);
                this.captureLists.put(script.get("variable").toString(), newList);
            }
        }
    }

    private void forOperation(Map<String, Object> script) throws ParseException, AttributeNotFoundException, IOException, InterruptedException {
        this.validate(script, new String[]{"forEach", "do"});
        Map forEachParams = (Map)script.get("forEach");
        this.validate((Map<String, Object>)forEachParams, new String[]{"selector", "name"});
        String selector = forEachParams.get("selector").toString();
        String name = forEachParams.get("name").toString();
        String iteratorName = forEachParams.get("variable").toString();
        List doBlock = (List)script.get("do");
        name = this.resolveExpressionValue(name);
        List elements = this.driver.findElements(this.by(selector, name));
        List xpaths = new ArrayList<String>();
        for (WebElement e : elements) {
            xpaths.add(this.getElementXPath(e));
        }
        if (forEachParams.containsKey("slice")) {
            String slice = forEachParams.get("slice").toString();
            xpaths = SeleniumScripter.slice(slice, xpaths);
        }
        LOG.info("Iterating over list: " + xpaths);
        for (String xpath : xpaths) {
            try {
                this.scriptVariables.put(iteratorName, xpath);
                this.runSubsequence(doBlock);
            }
            catch (StopIteration e) {
                LOG.warn("Exiting `for` loop on a call to `break`!");
                break;
            }
        }
    }

    private void ifOperation(Map<String, Object> script) throws ParseException, AttributeNotFoundException, IOException, InterruptedException, StopIteration {
        boolean comparison;
        this.validate(script, new String[]{"selector", "name", "condition", "then"});
        String selector = script.get("selector").toString();
        String name = script.get("name").toString();
        WebElement e = (WebElement)new WebDriverWait(this.driver, 0L).until((Function)ExpectedConditions.presenceOfElementLocated((By)this.by(selector, name)));
        name = this.resolveExpressionValue(name);
        List condition = (List)script.get("condition");
        List thenBody = (List)script.get("then");
        List elseBody = (List)script.get("else");
        String left_operand = e.getAttribute((String)condition.get(0));
        if (left_operand == null) {
            throw new AttributeNotFoundException("Element with " + selector + " of `" + name + "` does not have the attribute `" + (String)condition.get(0) + "`!");
        }
        left_operand = left_operand.toLowerCase();
        String operator = ((String)condition.get(1)).toLowerCase();
        String right_operand = ((String)condition.get(2)).toLowerCase();
        switch (operator) {
            case "equals": {
                comparison = left_operand.equals(right_operand);
                break;
            }
            case "contains": {
                comparison = left_operand.contains(right_operand);
                break;
            }
            default: {
                throw new ParseException("Invalid comparison operator: `" + operator + "`!", 0);
            }
        }
        if (comparison) {
            this.runSubsequence(thenBody);
        } else if (elseBody != null) {
            this.runSubsequence(elseBody);
        } else {
            LOG.warn("Condition did not meet, and no `else` clause was specified! Falling through...");
        }
    }

    private void breakOperation(Map<String, Object> script) throws StopIteration {
        throw new StopIteration("A call to `break` was caught outside of a loop, but may only be called inside a loop! Caught in block: " + script);
    }

    private void doWhileOperation(Map<String, Object> script) throws ParseException, AttributeNotFoundException, IOException, InterruptedException {
        this.validate(script, new String[]{"do_while", "do"});
        List whileBlock = (List)script.get("do_while");
        List doBlock = (List)script.get("do");
        do {
            try {
                this.runSubsequence(doBlock);
            }
            catch (StopIteration e) {
                LOG.warn("Exiting `do_while` loop on a call to `break`!");
                break;
            }
        } while (this.guardedSubsequence(whileBlock));
    }

    private void pushSnapshot(Map<String, Object> script) throws ParseException {
        String content;
        this.validate(script, "type");
        String type = script.get("type").toString().toLowerCase();
        String tokenName = script.getOrDefault("name", "null").toString();
        switch (type) {
            case "override": {
                this.validate(script, "value");
                content = script.get("value").toString();
                break;
            }
            case "html": {
                content = "<p id=\"error\">no results found</p><p id=\"token\">" + tokenName + "</p>";
                break;
            }
            case "json": {
                content = "{\"error\": \"no results found\", \"token\": \"" + tokenName + "\"}";
                break;
            }
            default: {
                throw new ParseException("Invalid `type`: " + type, 0);
            }
        }
        LOG.warn("Pushing " + type + " content to snapshot stack: `" + content + "`");
        this.snapshots.add(content);
    }

    private void jsBackOperation() {
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        try {
            LOG.info("Going to last page...");
            js.executeScript("window.history.back();", new Object[0]);
            js.executeAsyncScript("window.setTimeout(arguments[arguments.length - 1], 10000);", new Object[0]);
            LOG.info("Page refreshed!");
        }
        catch (NoSuchElementException e) {
            LOG.error("Back operation failed!");
        }
    }

    private void jsClickOperation(Map<String, Object> script) throws ParseException, NoSuchElementException, InterruptedException {
        this.validate(script, new String[]{"selector", "name"});
        String selector = script.get("selector").toString();
        String name = script.get("name").toString();
        long delay = Long.parseLong(script.getOrDefault("delay", 0).toString());
        name = this.resolveExpressionValue(name);
        WebElement element = this.driver.findElement(this.by(selector, name));
        ((JavascriptExecutor)this.driver).executeScript("arguments[0].scrollIntoView();", new Object[]{element});
        LOG.info("JS-clicking element with " + selector + " of `" + name + "`!");
        ((JavascriptExecutor)this.driver).executeScript("arguments[0].click();", new Object[]{element});
        LOG.info("Waiting for " + delay + "s before continuing...");
        Thread.sleep(delay * 1000L);
    }

    private void injectAdjacentElement(Map<String, Object> script) throws ParseException {
        this.validate(script, new String[]{"selector", "name", "tag", "value"});
        String selector = script.get("selector").toString();
        String name = script.get("name").toString();
        String htmlTag = script.get("tag").toString();
        String value = script.get("value").toString();
        name = this.resolveExpressionValue(name);
        value = this.resolveExpressionValue(value);
        value = StringEscapeUtils.escapeHtml((String)value);
        WebElement element = this.driver.findElement(this.by(selector, name));
        String newElement = "<" + htmlTag + ">" + value + "</" + htmlTag + ">";
        LOG.info("Injecting DOM element: `" + newElement + "` as a sibling to element with " + selector + " of `" + name + "`");
        ((JavascriptExecutor)this.driver).executeScript("arguments[0].insertAdjacentHTML(\"afterBegin\", \"" + newElement + "\");", new Object[]{element});
    }

    private void jsRefreshOperation() {
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        try {
            LOG.info("Refreshing the page!");
            js.executeScript("location.reload();", new Object[0]);
            js.executeAsyncScript("window.setTimeout(arguments[arguments.length - 1], 10000);", new Object[0]);
        }
        catch (NoSuchElementException e) {
            LOG.info("Refresh failed!");
        }
    }

    private void keysOperation(Map<String, Object> script) throws InterruptedException, ParseException {
        this.validate(script, new String[]{"selector", "name", "value"});
        String selector = script.get("selector").toString();
        String name = script.get("name").toString();
        String input = script.get("value").toString().toLowerCase();
        int charDelay = Integer.parseInt(script.getOrDefault("delay", 300).toString());
        int postInputDelay = Integer.parseInt(script.getOrDefault("postDelay", 5000).toString());
        name = this.resolveExpressionValue(name);
        WebElement element = this.driver.findElement(this.by(selector, name));
        LOG.info("Sending `" + input + "` to element with " + selector + " of `" + name + "`!");
        switch (input) {
            case "{enter}": {
                element.sendKeys(new CharSequence[]{Keys.ENTER});
                break;
            }
            case "{return}": {
                element.sendKeys(new CharSequence[]{Keys.RETURN});
                break;
            }
            case "{backspace}": {
                element.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                break;
            }
            case "{down}": {
                element.sendKeys(new CharSequence[]{Keys.ARROW_DOWN});
                break;
            }
            default: {
                input = this.resolveExpressionValue(input);
                element.clear();
                for (char s : input.toCharArray()) {
                    element.sendKeys(new CharSequence[]{String.valueOf(s)});
                    Thread.sleep(charDelay);
                }
                Thread.sleep(postInputDelay);
            }
        }
    }

    private void loadPageOperation(Map<String, Object> script) throws ParseException {
        long timeout = this.parseNumber(script.getOrDefault("timeout", 30L).toString()).longValue();
        LOG.info("Waiting for page to fully load within " + timeout + " seconds: " + this.driver.getCurrentUrl());
        new WebDriverWait(this.driver, timeout).until(driver -> ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).toString().equals("complete"));
    }

    private void restoreOperation(Map<String, Object> script) throws ParseException {
        String url = script.getOrDefault("url", this.url).toString();
        url = this.resolveExpressionValue(url);
        LOG.info("Restoring driver to url -> " + url);
        this.driver.get(url);
    }

    private static <K, V> Map<K, V> convertToTreeMap(Map<K, V> hashMap) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>();
        treeMap.putAll(hashMap);
        return treeMap;
    }

    @Setter
    public void setOutputPath(String path) {
        this.outputPath = path;
        new File(this.outputPath).mkdirs();
    }

    public void screenshotOperation(Map<String, Object> script) throws IOException, ParseException {
        this.validate(script, "targetdir");
        String directory = this.outputPath + (this.outputPath.endsWith("/") ? "" : "/") + script.get("targetdir").toString();
        String token = script.getOrDefault("tag", "screenshot").toString();
        String dirPath = directory + (directory.endsWith("/") ? "" : "/");
        File f = new File(dirPath);
        f.mkdirs();
        String filePath = dirPath + this.getDateString() + "-" + token + ".png";
        LOG.info("Taking screenshot and saving to: " + filePath);
        Screenshot s = new AShot().shootingStrategy(ShootingStrategies.viewportPasting((int)100)).takeScreenshot(this.driver);
        File tempFile = Files.createTempFile(null, null, new FileAttribute[0]).toFile();
        ImageIO.write((RenderedImage)s.getImage(), "PNG", tempFile);
        File dest = new File(filePath);
        FileUtils.copyFile((File)tempFile, (File)dest);
    }

    public void dumpStackOperation(Map<String, Object> script) throws ParseException, IOException {
        if (!this.DEV_MODE) {
            throw new NotActiveException("The `dumpstack` operation is for development purposes only and not available in production!");
        }
        this.validate(script, "targetdir");
        String directory = this.outputPath + (this.outputPath.endsWith("/") ? "" : "/") + script.get("targetdir").toString();
        new File(directory).mkdir();
        for (int i = 0; i < this.snapshots.size(); ++i) {
            String filepath = directory + i + "-snapshot.html";
            String content = this.snapshots.get(i);
            File file = new File(filepath);
            file.createNewFile();
            FileWriter writer = new FileWriter(filepath);
            writer.write(content);
            writer.close();
        }
    }

    private void selectOperation(Map<String, Object> script) throws ParseException {
        this.validate(script, new String[]{"selector", "name", "selectBy", "value"});
        String selector = script.get("selector").toString();
        String name = script.get("name").toString();
        String selectBy = script.get("selectBy").toString();
        String value = script.get("value").toString();
        name = this.resolveExpressionValue(name);
        Select selectElement = new Select(this.driver.findElement(this.by(selector, name)));
        LOG.info("Selecting option in element with " + selector + " of `" + name + "` by `" + selectBy + "`...");
        switch (selectBy.toLowerCase()) {
            case "value": {
                selectElement.selectByValue(value);
                break;
            }
            case "index": {
                selectElement.selectByIndex(Integer.parseInt(value));
                break;
            }
            case "visible": {
                LOG.warn("The selectBy option `visible` is deprecated in favor of `visible-text`.");
            }
            case "visible-text": {
                selectElement.selectByVisibleText(value);
                break;
            }
            default: {
                throw new ParseException("Invalid `selectBy` option: " + selectBy, 0);
            }
        }
    }

    private void setOperation(Map<String, Object> script) throws ParseException, NotActiveException {
        this.validate(script, new String[]{"variable", "value"});
        String variable = script.get("variable").toString();
        Object value = script.get("value");
        String type = script.getOrDefault("type", "literal").toString().toLowerCase();
        LOG.info("Instantiating " + variable + " with " + type + " value: `" + value + "`");
        switch (type) {
            case "literal": {
                this.scriptVariables.put(variable, value.toString());
                break;
            }
            case "element": {
                Map selectorParams = (Map)value;
                this.validate((Map<String, Object>)selectorParams, new String[]{"selector", "name"});
                String selector = selectorParams.get("selector").toString();
                String name = selectorParams.get("name").toString();
                WebElement element = this.driver.findElement(this.by(selector, name));
                String xpath = this.getElementXPath(element);
                this.scriptVariables.put(variable, xpath);
            }
            default: {
                throw new ParseException("Invalid value type `" + type + "`", 0);
            }
        }
    }

    private void snapshotOperation(Map<String, Object> script) throws ParseException {
        LOG.info("Taking snapshot of " + this.driver.getCurrentUrl());
        this.snapshots.add(this.driver.getPageSource());
        if (script.containsKey("capturedlabel")) {
            WebElement element = this.driver.findElement(this.by(script.get("selector").toString(), script.get("capturedlabel").toString()));
            this.capturedLabel.add(element.getText());
        }
    }

    @Getter
    public final List<String> getSnapshots() {
        return this.snapshots;
    }

    private void tryOperation(Map<String, Object> script) throws ParseException, AttributeNotFoundException, IOException, InterruptedException, StopIteration {
        this.validate(script, new String[]{"try", "catch", "expect"});
        List tryBody = (List)script.get("try");
        List catchBody = (List)script.get("catch");
        List raw_expect = ((List)script.get("expect")).stream().map(String::toLowerCase).collect(Collectors.toList());
        try {
            this.runSubsequence(tryBody);
        }
        catch (Exception e) {
            String name = this.exceptionToSlugName(e);
            if (raw_expect.contains(name)) {
                LOG.warn("Caught specified error of type " + e.getClass() + " inside a try operation:");
                e.printStackTrace();
                this.runSubsequence(catchBody);
            }
            throw e;
        }
    }

    private void pauseOperation(Map<String, Object> script) throws ParseException, NotActiveException, InterruptedException {
        if (!this.DEV_MODE) {
            throw new NotActiveException("The `pause` operation is for development purposes only and not available in a production environment!");
        }
        String raw_timeout = script.getOrDefault("timeout", 30L).toString();
        int timeout = this.parseNumber(raw_timeout).intValue() * 1000;
        LOG.info("Pausing for " + timeout + " ms");
        Thread.sleep(timeout);
    }

    private void waitOperation(Map<String, Object> script) throws ParseException {
        ExpectedCondition condition;
        this.validate(script, new String[]{"selector", "name"});
        long timeout = this.parseNumber(script.getOrDefault("timeout", 30L).toString()).longValue();
        String conditionStr = script.getOrDefault("until", "located").toString().toLowerCase();
        String selector = script.get("selector").toString();
        String name = script.get("name").toString();
        name = this.resolveExpressionValue(name);
        LOG.info("Waiting for element with " + selector + " of `" + name + "` to appear within " + timeout + " seconds...");
        switch (conditionStr) {
            case "clickable": {
                condition = ExpectedConditions.elementToBeClickable((By)this.by(selector, name));
                break;
            }
            case "located": {
                condition = ExpectedConditions.presenceOfElementLocated((By)this.by(selector, name));
                break;
            }
            case "selected": {
                condition = ExpectedConditions.elementToBeSelected((By)this.by(selector, name));
                break;
            }
            case "text": {
                this.validate(script, "value");
                String value = script.get("value").toString();
                condition = ExpectedConditions.textToBe((By)this.by(selector, name), (String)value);
                break;
            }
            case " title": {
                this.validate(script, "value");
                String title = script.get("value").toString();
                condition = ExpectedConditions.titleContains((String)title);
                break;
            }
            case "visible": {
                condition = ExpectedConditions.visibilityOfElementLocated((By)this.by(selector, name));
                break;
            }
            default: {
                throw new ParseException("Invalid `until` condition: `" + conditionStr + "`", 0);
            }
        }
        new WebDriverWait(this.driver, timeout).until((Function)condition);
    }

    private void getTokenOperation(Map<String, Object> script) throws ParseException {
        this.validate(script, "url");
        String url = script.get("url").toString();
        String variable = script.getOrDefault("variable", "bearer_token").toString();
        this.driver.get(url);
        WebElement element = this.driver.findElement(By.tagName((String)"pre"));
        Object o = JSONValue.parse((String)element.getText());
        JSONObject jsonObject = (JSONObject)o;
        this.scriptVariables.put(variable, jsonObject.get((Object)"access_token").toString());
    }

    public class StopIteration
    extends Exception {
        public StopIteration(String message) {
            super(message);
        }
    }
}

