/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spicule.seleniumscripter;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.RemoteWebDriver;

public class DriverFactory {
    boolean headless;
    final List<String> options;

    public DriverFactory(List<String> options) {
        this.options = options;
    }

    public boolean setHeadless(boolean headless) {
        this.headless = headless;
        return this.headless;
    }

    public RemoteWebDriver generateChromeDriver() {
        ChromeOptions driverOptions = new ChromeOptions();
        this.options.forEach(xva$0 -> driverOptions.addArguments(new String[]{xva$0}));
        driverOptions.setHeadless(this.headless);
        driverOptions.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        ChromeDriver driver = new ChromeDriver(driverOptions);
        driver.manage().timeouts().pageLoadTimeout(3600L, TimeUnit.SECONDS);
        return driver;
    }

    public RemoteWebDriver generateFirefoxDriver() {
        FirefoxOptions driverOptions = new FirefoxOptions();
        this.options.forEach(xva$0 -> driverOptions.addArguments(new String[]{xva$0}));
        driverOptions.setHeadless(this.headless);
        return new FirefoxDriver(driverOptions);
    }

    public RemoteWebDriver generateEdgeDriver() {
        EdgeOptions driverOptions = new EdgeOptions();
        return new EdgeDriver(driverOptions);
    }
}

