/* Generated Fix Gateway message codec */
package uk.co.real_logic.artio.other.decoder_flyweight;

import uk.co.real_logic.artio.util.MessageTypeEncoding;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import org.agrona.AsciiNumberFormatException;
import org.agrona.MutableDirectBuffer;
import org.agrona.AsciiSequenceView;
import static uk.co.real_logic.artio.dictionary.generation.CodecUtil.*;
import static uk.co.real_logic.artio.dictionary.SessionConstants.*;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.fields.ReadOnlyDecimalFloat;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.fields.LocalMktDateEncoder;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.dictionary.CharArraySet;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.IntHashSet.IntIterator;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.CommonDecoderImpl;
import static java.nio.charset.StandardCharsets.US_ASCII;
import static uk.co.real_logic.artio.builder.Validation.CODEC_VALIDATION_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED;
import uk.co.real_logic.artio.other.*;
import uk.co.real_logic.artio.other.builder.HeaderEncoder;


public class HeaderDecoder extends CommonDecoderImpl implements SessionHeaderDecoder
{
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(14);

    {
        if (CODEC_VALIDATION_ENABLED)
        {
            REQUIRED_FIELDS.add(Constants.BEGIN_STRING);
            REQUIRED_FIELDS.add(Constants.BODY_LENGTH);
            REQUIRED_FIELDS.add(Constants.MSG_TYPE);
            REQUIRED_FIELDS.add(Constants.SENDER_COMP_ID);
            REQUIRED_FIELDS.add(Constants.TARGET_COMP_ID);
            REQUIRED_FIELDS.add(Constants.MSG_SEQ_NUM);
            REQUIRED_FIELDS.add(Constants.SENDING_TIME);
        }
    }

    private final IntHashSet alreadyVisitedFields = new IntHashSet(32);

    private final IntHashSet unknownFields = new IntHashSet(10);

    private final IntHashSet missingRequiredFields = new IntHashSet(14);

    public boolean validate()
    {
        if (rejectReason != Decoder.NO_ERROR)
        {
            return false;
        }
        final IntIterator missingFieldsIterator = missingRequiredFields.iterator();
        if (missingFieldsIterator.hasNext())
        {
            invalidTagId = missingFieldsIterator.nextValue();
            rejectReason = 1;
            return false;
        }
        msgTypeWrapper.wrap(this.msgType(), msgTypeLength);
        if (CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !MsgType.isValid(msgTypeWrapper))
        {
            invalidTagId = 35;
            rejectReason = 5;
            return false;
        }
        return true;
    }

    public HeaderDecoder()
    {
        this(new TrailerDecoder());
    }

    private final TrailerDecoder trailer;
    public HeaderDecoder(final TrailerDecoder trailer)
    {
        this.trailer = trailer;
    }

    public long messageType()
    {
        return buffer.getMessageType(msgTypeOffset, msgTypeLength);
    }

    private char[] beginString = new char[1];

    public char[] beginString()
    {
        if (buffer != null && beginStringLength > 0)
        {
            beginString = buffer.getChars(beginString, beginStringOffset, beginStringLength);
        }
        return beginString;
    }


    private int beginStringOffset;

    private int beginStringLength;

    public int beginStringLength()
    {
        return beginStringLength;
    }

    public String beginStringAsString()
    {
        return buffer != null ? buffer.getStringWithoutLengthAscii(beginStringOffset, beginStringLength) : "";
    }

    public void beginString(final AsciiSequenceView view)
    {
        view.wrap(buffer, beginStringOffset, beginStringLength);
    }


    private final CharArrayWrapper beginStringWrapper = new CharArrayWrapper();
    private int bodyLength = MISSING_INT;

    public int bodyLength()
    {
        if (buffer != null && bodyLengthLength > 0)
        {
            bodyLength = getIntFlyweight(buffer, bodyLengthOffset, bodyLengthLength, 9, CODEC_VALIDATION_ENABLED);
        }
        return bodyLength;
    }


    private int bodyLengthOffset;

    private int bodyLengthLength;

    public int bodyLengthLength()
    {
        return bodyLengthLength;
    }


    private char[] msgType = new char[1];

    public char[] msgType()
    {
        if (buffer != null && msgTypeLength > 0)
        {
            msgType = buffer.getChars(msgType, msgTypeOffset, msgTypeLength);
        }
        return msgType;
    }


    private int msgTypeOffset;

    private int msgTypeLength;

    public int msgTypeLength()
    {
        return msgTypeLength;
    }

    public String msgTypeAsString()
    {
        return buffer != null ? buffer.getStringWithoutLengthAscii(msgTypeOffset, msgTypeLength) : "";
    }

    public void msgType(final AsciiSequenceView view)
    {
        view.wrap(buffer, msgTypeOffset, msgTypeLength);
    }


    private final CharArrayWrapper msgTypeWrapper = new CharArrayWrapper();
    public MsgType msgTypeAsEnum()
    {
        msgTypeWrapper.wrap(this.msgType(), msgTypeLength);
        return MsgType.decode(msgTypeWrapper);
    }

    private char[] senderCompID = new char[1];

    public char[] senderCompID()
    {
        if (buffer != null && senderCompIDLength > 0)
        {
            senderCompID = buffer.getChars(senderCompID, senderCompIDOffset, senderCompIDLength);
        }
        return senderCompID;
    }


    private int senderCompIDOffset;

    private int senderCompIDLength;

    public int senderCompIDLength()
    {
        return senderCompIDLength;
    }

    public String senderCompIDAsString()
    {
        return buffer != null ? buffer.getStringWithoutLengthAscii(senderCompIDOffset, senderCompIDLength) : "";
    }

    public void senderCompID(final AsciiSequenceView view)
    {
        view.wrap(buffer, senderCompIDOffset, senderCompIDLength);
    }


    private final CharArrayWrapper senderCompIDWrapper = new CharArrayWrapper();
    private char[] targetCompID = new char[1];

    public char[] targetCompID()
    {
        if (buffer != null && targetCompIDLength > 0)
        {
            targetCompID = buffer.getChars(targetCompID, targetCompIDOffset, targetCompIDLength);
        }
        return targetCompID;
    }


    private int targetCompIDOffset;

    private int targetCompIDLength;

    public int targetCompIDLength()
    {
        return targetCompIDLength;
    }

    public String targetCompIDAsString()
    {
        return buffer != null ? buffer.getStringWithoutLengthAscii(targetCompIDOffset, targetCompIDLength) : "";
    }

    public void targetCompID(final AsciiSequenceView view)
    {
        view.wrap(buffer, targetCompIDOffset, targetCompIDLength);
    }


    private final CharArrayWrapper targetCompIDWrapper = new CharArrayWrapper();
    private int msgSeqNum = MISSING_INT;

    public int msgSeqNum()
    {
        if (buffer != null && msgSeqNumLength > 0)
        {
            msgSeqNum = getIntFlyweight(buffer, msgSeqNumOffset, msgSeqNumLength, 34, CODEC_VALIDATION_ENABLED);
        }
        return msgSeqNum;
    }


    private int msgSeqNumOffset;

    private int msgSeqNumLength;

    public int msgSeqNumLength()
    {
        return msgSeqNumLength;
    }


    private char[] senderSubID = new char[1];

    private boolean hasSenderSubID;

    public char[] senderSubID()
    {
        if (!hasSenderSubID)
        {
            throw new IllegalArgumentException("No value for optional field: SenderSubID");
        }

        if (buffer != null && senderSubIDLength > 0)
        {
            senderSubID = buffer.getChars(senderSubID, senderSubIDOffset, senderSubIDLength);
        }
        return senderSubID;
    }

    public boolean hasSenderSubID()
    {
        return hasSenderSubID;
    }


    private int senderSubIDOffset;

    private int senderSubIDLength;

    public int senderSubIDLength()
    {
        if (!hasSenderSubID)
        {
            throw new IllegalArgumentException("No value for optional field: SenderSubID");
        }

        return senderSubIDLength;
    }

    public String senderSubIDAsString()
    {
        return hasSenderSubID ? buffer.getStringWithoutLengthAscii(senderSubIDOffset, senderSubIDLength) : null;
    }

    public void senderSubID(final AsciiSequenceView view)
    {
        if (!hasSenderSubID)
        {
            throw new IllegalArgumentException("No value for optional field: SenderSubID");
        }

        view.wrap(buffer, senderSubIDOffset, senderSubIDLength);
    }


    private final CharArrayWrapper senderSubIDWrapper = new CharArrayWrapper();
    private char[] senderLocationID = new char[1];

    private boolean hasSenderLocationID;

    public char[] senderLocationID()
    {
        if (!hasSenderLocationID)
        {
            throw new IllegalArgumentException("No value for optional field: SenderLocationID");
        }

        if (buffer != null && senderLocationIDLength > 0)
        {
            senderLocationID = buffer.getChars(senderLocationID, senderLocationIDOffset, senderLocationIDLength);
        }
        return senderLocationID;
    }

    public boolean hasSenderLocationID()
    {
        return hasSenderLocationID;
    }


    private int senderLocationIDOffset;

    private int senderLocationIDLength;

    public int senderLocationIDLength()
    {
        if (!hasSenderLocationID)
        {
            throw new IllegalArgumentException("No value for optional field: SenderLocationID");
        }

        return senderLocationIDLength;
    }

    public String senderLocationIDAsString()
    {
        return hasSenderLocationID ? buffer.getStringWithoutLengthAscii(senderLocationIDOffset, senderLocationIDLength) : null;
    }

    public void senderLocationID(final AsciiSequenceView view)
    {
        if (!hasSenderLocationID)
        {
            throw new IllegalArgumentException("No value for optional field: SenderLocationID");
        }

        view.wrap(buffer, senderLocationIDOffset, senderLocationIDLength);
    }


    private final CharArrayWrapper senderLocationIDWrapper = new CharArrayWrapper();
    private char[] targetSubID = new char[1];

    private boolean hasTargetSubID;

    public char[] targetSubID()
    {
        if (!hasTargetSubID)
        {
            throw new IllegalArgumentException("No value for optional field: TargetSubID");
        }

        if (buffer != null && targetSubIDLength > 0)
        {
            targetSubID = buffer.getChars(targetSubID, targetSubIDOffset, targetSubIDLength);
        }
        return targetSubID;
    }

    public boolean hasTargetSubID()
    {
        return hasTargetSubID;
    }


    private int targetSubIDOffset;

    private int targetSubIDLength;

    public int targetSubIDLength()
    {
        if (!hasTargetSubID)
        {
            throw new IllegalArgumentException("No value for optional field: TargetSubID");
        }

        return targetSubIDLength;
    }

    public String targetSubIDAsString()
    {
        return hasTargetSubID ? buffer.getStringWithoutLengthAscii(targetSubIDOffset, targetSubIDLength) : null;
    }

    public void targetSubID(final AsciiSequenceView view)
    {
        if (!hasTargetSubID)
        {
            throw new IllegalArgumentException("No value for optional field: TargetSubID");
        }

        view.wrap(buffer, targetSubIDOffset, targetSubIDLength);
    }


    private final CharArrayWrapper targetSubIDWrapper = new CharArrayWrapper();
    private char[] targetLocationID = new char[1];

    private boolean hasTargetLocationID;

    public char[] targetLocationID()
    {
        if (!hasTargetLocationID)
        {
            throw new IllegalArgumentException("No value for optional field: TargetLocationID");
        }

        if (buffer != null && targetLocationIDLength > 0)
        {
            targetLocationID = buffer.getChars(targetLocationID, targetLocationIDOffset, targetLocationIDLength);
        }
        return targetLocationID;
    }

    public boolean hasTargetLocationID()
    {
        return hasTargetLocationID;
    }


    private int targetLocationIDOffset;

    private int targetLocationIDLength;

    public int targetLocationIDLength()
    {
        if (!hasTargetLocationID)
        {
            throw new IllegalArgumentException("No value for optional field: TargetLocationID");
        }

        return targetLocationIDLength;
    }

    public String targetLocationIDAsString()
    {
        return hasTargetLocationID ? buffer.getStringWithoutLengthAscii(targetLocationIDOffset, targetLocationIDLength) : null;
    }

    public void targetLocationID(final AsciiSequenceView view)
    {
        if (!hasTargetLocationID)
        {
            throw new IllegalArgumentException("No value for optional field: TargetLocationID");
        }

        view.wrap(buffer, targetLocationIDOffset, targetLocationIDLength);
    }


    private final CharArrayWrapper targetLocationIDWrapper = new CharArrayWrapper();
    private boolean possDupFlag;

    private boolean hasPossDupFlag;

    public boolean possDupFlag()
    {
        if (!hasPossDupFlag)
        {
            throw new IllegalArgumentException("No value for optional field: PossDupFlag");
        }

        return possDupFlag;
    }

    public boolean hasPossDupFlag()
    {
        return hasPossDupFlag;
    }



    private boolean possResend;

    private boolean hasPossResend;

    public boolean possResend()
    {
        if (!hasPossResend)
        {
            throw new IllegalArgumentException("No value for optional field: PossResend");
        }

        return possResend;
    }

    public boolean hasPossResend()
    {
        return hasPossResend;
    }



    private byte[] sendingTime = new byte[24];

    public byte[] sendingTime()
    {
        if (buffer != null && sendingTimeLength > 0)
        {
            sendingTime = buffer.getBytes(sendingTime, sendingTimeOffset, sendingTimeLength);
        }
        return sendingTime;
    }


    private int sendingTimeOffset;

    private int sendingTimeLength;

    public int sendingTimeLength()
    {
        return sendingTimeLength;
    }

    public String sendingTimeAsString()
    {
        return buffer != null ? buffer.getStringWithoutLengthAscii(sendingTimeOffset, sendingTimeLength) : "";
    }

    public void sendingTime(final AsciiSequenceView view)
    {
        view.wrap(buffer, sendingTimeOffset, sendingTimeLength);
    }


    private byte[] origSendingTime = new byte[24];

    private boolean hasOrigSendingTime;

    public byte[] origSendingTime()
    {
        if (!hasOrigSendingTime)
        {
            throw new IllegalArgumentException("No value for optional field: OrigSendingTime");
        }

        if (buffer != null && origSendingTimeLength > 0)
        {
            origSendingTime = buffer.getBytes(origSendingTime, origSendingTimeOffset, origSendingTimeLength);
        }
        return origSendingTime;
    }

    public boolean hasOrigSendingTime()
    {
        return hasOrigSendingTime;
    }


    private int origSendingTimeOffset;

    private int origSendingTimeLength;

    public int origSendingTimeLength()
    {
        if (!hasOrigSendingTime)
        {
            throw new IllegalArgumentException("No value for optional field: OrigSendingTime");
        }

        return origSendingTimeLength;
    }

    public String origSendingTimeAsString()
    {
        return hasOrigSendingTime ? buffer.getStringWithoutLengthAscii(origSendingTimeOffset, origSendingTimeLength) : null;
    }

    public void origSendingTime(final AsciiSequenceView view)
    {
        if (!hasOrigSendingTime)
        {
            throw new IllegalArgumentException("No value for optional field: OrigSendingTime");
        }

        view.wrap(buffer, origSendingTimeOffset, origSendingTimeLength);
    }


    private int lastMsgSeqNumProcessed = MISSING_INT;

    private boolean hasLastMsgSeqNumProcessed;

    public int lastMsgSeqNumProcessed()
    {
        if (!hasLastMsgSeqNumProcessed)
        {
            throw new IllegalArgumentException("No value for optional field: LastMsgSeqNumProcessed");
        }

        if (buffer != null && lastMsgSeqNumProcessedLength > 0)
        {
            lastMsgSeqNumProcessed = getIntFlyweight(buffer, lastMsgSeqNumProcessedOffset, lastMsgSeqNumProcessedLength, 369, CODEC_VALIDATION_ENABLED);
        }
        return lastMsgSeqNumProcessed;
    }

    public boolean hasLastMsgSeqNumProcessed()
    {
        return hasLastMsgSeqNumProcessed;
    }


    private int lastMsgSeqNumProcessedOffset;

    private int lastMsgSeqNumProcessedLength;

    public int lastMsgSeqNumProcessedLength()
    {
        if (!hasLastMsgSeqNumProcessed)
        {
            throw new IllegalArgumentException("No value for optional field: LastMsgSeqNumProcessed");
        }

        return lastMsgSeqNumProcessedLength;
    }


    private char[] testField = new char[1];

    private boolean hasTestField;

    public char[] testField()
    {
        if (!hasTestField)
        {
            throw new IllegalArgumentException("No value for optional field: TestField");
        }

        if (buffer != null && testFieldLength > 0)
        {
            testField = buffer.getChars(testField, testFieldOffset, testFieldLength);
        }
        return testField;
    }

    public boolean hasTestField()
    {
        return hasTestField;
    }


    private int testFieldOffset;

    private int testFieldLength;

    public int testFieldLength()
    {
        if (!hasTestField)
        {
            throw new IllegalArgumentException("No value for optional field: TestField");
        }

        return testFieldLength;
    }

    public String testFieldAsString()
    {
        return hasTestField ? buffer.getStringWithoutLengthAscii(testFieldOffset, testFieldLength) : null;
    }

    public void testField(final AsciiSequenceView view)
    {
        if (!hasTestField)
        {
            throw new IllegalArgumentException("No value for optional field: TestField");
        }

        view.wrap(buffer, testFieldOffset, testFieldLength);
    }


    private final CharArrayWrapper testFieldWrapper = new CharArrayWrapper();
    public int decode(final AsciiBuffer buffer, final int offset, final int length)
    {
        // Decode Header
        int seenFieldCount = 0;
        if (CODEC_VALIDATION_ENABLED)
        {
            missingRequiredFields.copy(REQUIRED_FIELDS);
            alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        final int end = offset + length;
        int position = offset;
        int tag;

        while (position < end)
        {
            final int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == AsciiBuffer.UNKNOWN_INDEX)
            {
               return position;
            }
            tag = buffer.getInt(position, equalsPosition);
            final int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, START_OF_HEADER);
            if (endOfField == AsciiBuffer.UNKNOWN_INDEX || equalsPosition == AsciiBuffer.UNKNOWN_INDEX)
            {
                rejectReason = 5;
                break;
            }
            final int valueLength = endOfField - valueOffset;
            if (CODEC_VALIDATION_ENABLED)
            {
                if (tag <= 0)
                {
                    invalidTagId = tag;
                    rejectReason = 0;
                }
                else if (valueLength == 0)
                {
                    invalidTagId = tag;
                    rejectReason = 4;
                }
                else if (seenFieldCount == 0 && tag != 8)
                {
                    invalidTagId = tag;
                    rejectReason = 14;
                }
                else if (seenFieldCount == 1 && tag != 9)
                {
                    invalidTagId = tag;
                    rejectReason = 14;
                }
                else if (seenFieldCount == 2 && tag != 35)
                {
                    invalidTagId = tag;
                    rejectReason = 14;
                }
                if (!alreadyVisitedFields.add(tag))
                {
                    invalidTagId = tag;
                    rejectReason = 13;
                }
                missingRequiredFields.remove(tag);
                seenFieldCount++;
            }

            switch (tag)
            {
            case Constants.BEGIN_STRING:
                beginStringOffset = valueOffset;
                beginStringLength = valueLength;
                break;

            case Constants.BODY_LENGTH:
                bodyLengthOffset = valueOffset;
                bodyLengthLength = valueLength;
                break;

            case Constants.MSG_TYPE:
                msgTypeOffset = valueOffset;
                msgTypeLength = valueLength;
                break;

            case Constants.SENDER_COMP_ID:
                senderCompIDOffset = valueOffset;
                senderCompIDLength = valueLength;
                break;

            case Constants.TARGET_COMP_ID:
                targetCompIDOffset = valueOffset;
                targetCompIDLength = valueLength;
                break;

            case Constants.MSG_SEQ_NUM:
                msgSeqNumOffset = valueOffset;
                msgSeqNumLength = valueLength;
                break;

            case Constants.SENDER_SUB_ID:
                hasSenderSubID = true;
                senderSubIDOffset = valueOffset;
                senderSubIDLength = valueLength;
                break;

            case Constants.SENDER_LOCATION_ID:
                hasSenderLocationID = true;
                senderLocationIDOffset = valueOffset;
                senderLocationIDLength = valueLength;
                break;

            case Constants.TARGET_SUB_ID:
                hasTargetSubID = true;
                targetSubIDOffset = valueOffset;
                targetSubIDLength = valueLength;
                break;

            case Constants.TARGET_LOCATION_ID:
                hasTargetLocationID = true;
                targetLocationIDOffset = valueOffset;
                targetLocationIDLength = valueLength;
                break;

            case Constants.POSS_DUP_FLAG:
                hasPossDupFlag = true;
                possDupFlag = buffer.getBoolean(valueOffset);
                break;

            case Constants.POSS_RESEND:
                hasPossResend = true;
                possResend = buffer.getBoolean(valueOffset);
                break;

            case Constants.SENDING_TIME:
                sendingTimeOffset = valueOffset;
                sendingTimeLength = valueLength;
                break;

            case Constants.ORIG_SENDING_TIME:
                hasOrigSendingTime = true;
                origSendingTimeOffset = valueOffset;
                origSendingTimeLength = valueLength;
                break;

            case Constants.LAST_MSG_SEQ_NUM_PROCESSED:
                hasLastMsgSeqNumProcessed = true;
                lastMsgSeqNumProcessedOffset = valueOffset;
                lastMsgSeqNumProcessedLength = valueLength;
                break;

            case Constants.TEST_FIELD:
                hasTestField = true;
                testFieldOffset = valueOffset;
                testFieldLength = valueLength;
                break;

            default:
                if (!CODEC_REJECT_UNKNOWN_FIELD_ENABLED)
                {
                    alreadyVisitedFields.remove(tag);
                }
                else
                {
                    if (!true)
                    {
                        unknownFields.add(tag);
                    }
                }
                if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED || true)
                {
                    return position - offset;
                }

            }

            if (position < (endOfField + 1))
            {
                position = endOfField + 1;
            }
        }
        return position - offset;
    }

    public void reset()
    {
        this.resetSenderCompID();
        this.resetTargetCompID();
        this.resetMsgSeqNum();
        this.resetSenderSubID();
        this.resetSenderLocationID();
        this.resetTargetSubID();
        this.resetTargetLocationID();
        this.resetPossDupFlag();
        this.resetPossResend();
        this.resetSendingTime();
        this.resetOrigSendingTime();
        this.resetLastMsgSeqNumProcessed();
        this.resetTestField();
        buffer = null;
        if (CODEC_VALIDATION_ENABLED)
        {
            invalidTagId = Decoder.NO_ERROR;
            rejectReason = Decoder.NO_ERROR;
            missingRequiredFields.clear();
            unknownFields.clear();
            alreadyVisitedFields.clear();
        }
    }

    public void resetSenderCompID()
    {
        senderCompIDOffset = 0;
        senderCompIDLength = 0;
    }

    public void resetTargetCompID()
    {
        targetCompIDOffset = 0;
        targetCompIDLength = 0;
    }

    public void resetMsgSeqNum()
    {
        msgSeqNumLength = 0;
        msgSeqNum = MISSING_INT;
    }

    public void resetSenderSubID()
    {
        hasSenderSubID = false;
    }

    public void resetSenderLocationID()
    {
        hasSenderLocationID = false;
    }

    public void resetTargetSubID()
    {
        hasTargetSubID = false;
    }

    public void resetTargetLocationID()
    {
        hasTargetLocationID = false;
    }

    public void resetPossDupFlag()
    {
        hasPossDupFlag = false;
    }

    public void resetPossResend()
    {
        hasPossResend = false;
    }

    public void resetSendingTime()
    {
    }

    public void resetOrigSendingTime()
    {
        hasOrigSendingTime = false;
    }

    public void resetLastMsgSeqNumProcessed()
    {
        hasLastMsgSeqNumProcessed = false;
    }

    public void resetTestField()
    {
        hasTestField = false;
    }

    public String toString()
    {
        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        return appendTo(builder, 1);
    }

    public StringBuilder appendTo(final StringBuilder builder, final int level)
    {
        builder.append("{\n");        indent(builder, level);
        builder.append("\"MessageName\": \"Header\",\n");
        indent(builder, level);
        builder.append("\"BeginString\": \"");
        builder.append(this.beginString(), 0, beginStringLength());
        builder.append("\",\n");


        indent(builder, level);
        builder.append("\"MsgType\": \"");
        builder.append(this.msgType(), 0, msgTypeLength());
        builder.append("\",\n");

        indent(builder, level);
        builder.append("\"SenderCompID\": \"");
        builder.append(this.senderCompID(), 0, senderCompIDLength());
        builder.append("\",\n");

        indent(builder, level);
        builder.append("\"TargetCompID\": \"");
        builder.append(this.targetCompID(), 0, targetCompIDLength());
        builder.append("\",\n");

        indent(builder, level);
        builder.append("\"MsgSeqNum\": \"");
        builder.append(this.msgSeqNum());
        builder.append("\",\n");

        if (hasSenderSubID())
        {
            indent(builder, level);
            builder.append("\"SenderSubID\": \"");
            builder.append(this.senderSubID(), 0, senderSubIDLength());
            builder.append("\",\n");
        }

        if (hasSenderLocationID())
        {
            indent(builder, level);
            builder.append("\"SenderLocationID\": \"");
            builder.append(this.senderLocationID(), 0, senderLocationIDLength());
            builder.append("\",\n");
        }

        if (hasTargetSubID())
        {
            indent(builder, level);
            builder.append("\"TargetSubID\": \"");
            builder.append(this.targetSubID(), 0, targetSubIDLength());
            builder.append("\",\n");
        }

        if (hasTargetLocationID())
        {
            indent(builder, level);
            builder.append("\"TargetLocationID\": \"");
            builder.append(this.targetLocationID(), 0, targetLocationIDLength());
            builder.append("\",\n");
        }

        if (hasPossDupFlag())
        {
            indent(builder, level);
            builder.append("\"PossDupFlag\": \"");
            builder.append(this.possDupFlag());
            builder.append("\",\n");
        }

        if (hasPossResend())
        {
            indent(builder, level);
            builder.append("\"PossResend\": \"");
            builder.append(this.possResend());
            builder.append("\",\n");
        }

        indent(builder, level);
        builder.append("\"SendingTime\": \"");
        appendData(builder, this.sendingTime(), sendingTimeLength());
        builder.append("\",\n");

        if (hasOrigSendingTime())
        {
            indent(builder, level);
            builder.append("\"OrigSendingTime\": \"");
            appendData(builder, this.origSendingTime(), origSendingTimeLength());
            builder.append("\",\n");
        }

        if (hasLastMsgSeqNumProcessed())
        {
            indent(builder, level);
            builder.append("\"LastMsgSeqNumProcessed\": \"");
            builder.append(this.lastMsgSeqNumProcessed());
            builder.append("\",\n");
        }

        if (hasTestField())
        {
            indent(builder, level);
            builder.append("\"TestField\": \"");
            builder.append(this.testField(), 0, testFieldLength());
            builder.append("\",\n");
        }
        indent(builder, level - 1);
        builder.append("}");
        return builder;
    }

    /**
     * {@inheritDoc}
     */
    public HeaderEncoder toEncoder(final Encoder encoder)
    {
        return toEncoder((HeaderEncoder)encoder);
    }

    public HeaderEncoder toEncoder(final HeaderEncoder encoder)
    {
        encoder.reset();
        encoder.beginString(this.beginString(), 0, beginStringLength());

        encoder.msgType(this.msgType(), 0, msgTypeLength());
        encoder.senderCompID(this.senderCompID(), 0, senderCompIDLength());
        encoder.targetCompID(this.targetCompID(), 0, targetCompIDLength());
        encoder.msgSeqNum(this.msgSeqNum());
        if (hasSenderSubID())
        {
            encoder.senderSubID(this.senderSubID(), 0, senderSubIDLength());
        }

        if (hasSenderLocationID())
        {
            encoder.senderLocationID(this.senderLocationID(), 0, senderLocationIDLength());
        }

        if (hasTargetSubID())
        {
            encoder.targetSubID(this.targetSubID(), 0, targetSubIDLength());
        }

        if (hasTargetLocationID())
        {
            encoder.targetLocationID(this.targetLocationID(), 0, targetLocationIDLength());
        }

        if (hasPossDupFlag())
        {
            encoder.possDupFlag(this.possDupFlag());
        }

        if (hasPossResend())
        {
            encoder.possResend(this.possResend());
        }

        encoder.sendingTimeAsCopy(this.sendingTime(), 0, sendingTimeLength());
        if (hasOrigSendingTime())
        {
            encoder.origSendingTimeAsCopy(this.origSendingTime(), 0, origSendingTimeLength());
        }

        if (hasLastMsgSeqNumProcessed())
        {
            encoder.lastMsgSeqNumProcessed(this.lastMsgSeqNumProcessed());
        }

        if (hasTestField())
        {
            encoder.testField(this.testField(), 0, testFieldLength());
        }
        return encoder;
    }

}
