/* Generated Fix Gateway message codec */
package uk.co.real_logic.artio.decoder_flyweight;

import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import org.agrona.AsciiNumberFormatException;
import org.agrona.MutableDirectBuffer;
import org.agrona.AsciiSequenceView;
import static uk.co.real_logic.artio.dictionary.generation.CodecUtil.*;
import static uk.co.real_logic.artio.dictionary.SessionConstants.*;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.decoder_flyweight.HeaderDecoder;
import uk.co.real_logic.artio.decoder_flyweight.TrailerDecoder;
import uk.co.real_logic.artio.fields.ReadOnlyDecimalFloat;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.fields.LocalMktDateEncoder;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.dictionary.CharArraySet;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.IntHashSet.IntIterator;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.CommonDecoderImpl;
import static java.nio.charset.StandardCharsets.US_ASCII;
import static uk.co.real_logic.artio.builder.Validation.CODEC_VALIDATION_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED;
import uk.co.real_logic.artio.*;
import uk.co.real_logic.artio.builder.LogonEncoder;


public class LogonDecoder extends CommonDecoderImpl implements MessageDecoder, AbstractLogonDecoder
{
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(4);

    {
        if (CODEC_VALIDATION_ENABLED)
        {
            REQUIRED_FIELDS.add(Constants.ENCRYPT_METHOD);
            REQUIRED_FIELDS.add(Constants.HEART_BT_INT);
        }
    }

    private final IntHashSet alreadyVisitedFields = new IntHashSet(24);

    private final IntHashSet unknownFields = new IntHashSet(10);

    private final IntHashSet missingRequiredFields = new IntHashSet(4);

    public boolean validate()
    {
        if (rejectReason != Decoder.NO_ERROR)
        {
            return false;
        }
        final IntIterator missingFieldsIterator = missingRequiredFields.iterator();
        final IntIterator unknownFieldsIterator = unknownFields.iterator();
        if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext())
        {
            invalidTagId = unknownFieldsIterator.nextValue();
            rejectReason = Constants.ALL_FIELDS.contains(invalidTagId) ? 2 : 0;
            return false;
        }
        if (!header.validate())
        {
            invalidTagId = header.invalidTagId();
            rejectReason = header.rejectReason();
            return false;
        }
        else if (!trailer.validate())
        {
            invalidTagId = trailer.invalidTagId();
            rejectReason = trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext())
        {
            invalidTagId = missingFieldsIterator.nextValue();
            rejectReason = 1;
            return false;
        }
        if (CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !EncryptMethod.isValid(encryptMethod()))
        {
            invalidTagId = 98;
            rejectReason = 5;
            return false;
        }

        if (hasCancelOnDisconnectType)
        {
        if (CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !CancelOnDisconnectType.isValid(cancelOnDisconnectType()))
        {
            invalidTagId = 35002;
            rejectReason = 5;
            return false;
        }
        }
        return true;
    }

    public static final long MESSAGE_TYPE = 65L;

    public static final String MESSAGE_TYPE_AS_STRING = "A";

    public static final char[] MESSAGE_TYPE_CHARS = MESSAGE_TYPE_AS_STRING.toCharArray();

    public static final byte[] MESSAGE_TYPE_BYTES = MESSAGE_TYPE_AS_STRING.getBytes(US_ASCII);

    public final IntHashSet messageFields = new IntHashSet(56);

    {
        messageFields.add(Constants.BEGIN_STRING);
        messageFields.add(Constants.BODY_LENGTH);
        messageFields.add(Constants.MSG_TYPE);
        messageFields.add(Constants.SENDER_COMP_ID);
        messageFields.add(Constants.TARGET_COMP_ID);
        messageFields.add(Constants.MSG_SEQ_NUM);
        messageFields.add(Constants.SENDER_SUB_ID);
        messageFields.add(Constants.SENDER_LOCATION_ID);
        messageFields.add(Constants.TARGET_SUB_ID);
        messageFields.add(Constants.TARGET_LOCATION_ID);
        messageFields.add(Constants.POSS_DUP_FLAG);
        messageFields.add(Constants.POSS_RESEND);
        messageFields.add(Constants.SENDING_TIME);
        messageFields.add(Constants.ORIG_SENDING_TIME);
        messageFields.add(Constants.LAST_MSG_SEQ_NUM_PROCESSED);
        messageFields.add(Constants.ENCRYPT_METHOD);
        messageFields.add(Constants.HEART_BT_INT);
        messageFields.add(Constants.RAW_DATA_LENGTH);
        messageFields.add(Constants.RAW_DATA);
        messageFields.add(Constants.RESET_SEQ_NUM_FLAG);
        messageFields.add(Constants.NEXT_EXPECTED_MSG_SEQ_NUM);
        messageFields.add(Constants.MAX_MESSAGE_SIZE);
        messageFields.add(Constants.TEST_MESSAGE_INDICATOR);
        messageFields.add(Constants.USERNAME);
        messageFields.add(Constants.PASSWORD);
        messageFields.add(Constants.CANCEL_ON_DISCONNECT_TYPE);
        messageFields.add(Constants.C_O_D_TIMEOUT_WINDOW);
        messageFields.add(Constants.CHECK_SUM);
    }

    private final TrailerDecoder trailer = new TrailerDecoder();

    public TrailerDecoder trailer()
    {
        return trailer;
    }

    private final HeaderDecoder header = new HeaderDecoder(trailer);

    public HeaderDecoder header()
    {
        return header;
    }

    private int encryptMethod = MISSING_INT;

    public int encryptMethod()
    {
        if (buffer != null && encryptMethodLength > 0)
        {
            encryptMethod = getIntFlyweight(buffer, encryptMethodOffset, encryptMethodLength, 98, CODEC_VALIDATION_ENABLED);
        }
        return encryptMethod;
    }


    private int encryptMethodOffset;

    private int encryptMethodLength;

    public int encryptMethodLength()
    {
        return encryptMethodLength;
    }


    private final CharArrayWrapper encryptMethodWrapper = new CharArrayWrapper();
    public EncryptMethod encryptMethodAsEnum()
    {
        return EncryptMethod.decode(this.encryptMethod());
    }

    private int heartBtInt = MISSING_INT;

    public int heartBtInt()
    {
        if (buffer != null && heartBtIntLength > 0)
        {
            heartBtInt = getIntFlyweight(buffer, heartBtIntOffset, heartBtIntLength, 108, CODEC_VALIDATION_ENABLED);
        }
        return heartBtInt;
    }


    private int heartBtIntOffset;

    private int heartBtIntLength;

    public int heartBtIntLength()
    {
        return heartBtIntLength;
    }


    private int rawDataLength = MISSING_INT;

    private boolean hasRawDataLength;

    public int rawDataLength()
    {
        if (!hasRawDataLength)
        {
            throw new IllegalArgumentException("No value for optional field: RawDataLength");
        }

        if (buffer != null && rawDataLengthLength > 0)
        {
            rawDataLength = getIntFlyweight(buffer, rawDataLengthOffset, rawDataLengthLength, 95, CODEC_VALIDATION_ENABLED);
        }
        return rawDataLength;
    }

    public boolean hasRawDataLength()
    {
        return hasRawDataLength;
    }


    private int rawDataLengthOffset;

    private int rawDataLengthLength;

    public int rawDataLengthLength()
    {
        if (!hasRawDataLength)
        {
            throw new IllegalArgumentException("No value for optional field: RawDataLength");
        }

        return rawDataLengthLength;
    }


    private byte[] rawData = new byte[1];

    private boolean hasRawData;

    public byte[] rawData()
    {
        if (!hasRawData)
        {
            throw new IllegalArgumentException("No value for optional field: RawData");
        }

        if (buffer != null && rawDataLength > 0)
        {
            rawData = buffer.getBytes(rawData, rawDataOffset, rawDataLength);
        }
        return rawData;
    }

    public boolean hasRawData()
    {
        return hasRawData;
    }


    private int rawDataOffset;


    private boolean resetSeqNumFlag;

    private boolean hasResetSeqNumFlag;

    public boolean resetSeqNumFlag()
    {
        if (!hasResetSeqNumFlag)
        {
            throw new IllegalArgumentException("No value for optional field: ResetSeqNumFlag");
        }

        return resetSeqNumFlag;
    }

    public boolean hasResetSeqNumFlag()
    {
        return hasResetSeqNumFlag;
    }



    private int nextExpectedMsgSeqNum = MISSING_INT;

    private boolean hasNextExpectedMsgSeqNum;

    public int nextExpectedMsgSeqNum()
    {
        if (!hasNextExpectedMsgSeqNum)
        {
            throw new IllegalArgumentException("No value for optional field: NextExpectedMsgSeqNum");
        }

        if (buffer != null && nextExpectedMsgSeqNumLength > 0)
        {
            nextExpectedMsgSeqNum = getIntFlyweight(buffer, nextExpectedMsgSeqNumOffset, nextExpectedMsgSeqNumLength, 789, CODEC_VALIDATION_ENABLED);
        }
        return nextExpectedMsgSeqNum;
    }

    public boolean hasNextExpectedMsgSeqNum()
    {
        return hasNextExpectedMsgSeqNum;
    }


    private int nextExpectedMsgSeqNumOffset;

    private int nextExpectedMsgSeqNumLength;

    public int nextExpectedMsgSeqNumLength()
    {
        if (!hasNextExpectedMsgSeqNum)
        {
            throw new IllegalArgumentException("No value for optional field: NextExpectedMsgSeqNum");
        }

        return nextExpectedMsgSeqNumLength;
    }


    private int maxMessageSize = MISSING_INT;

    private boolean hasMaxMessageSize;

    public int maxMessageSize()
    {
        if (!hasMaxMessageSize)
        {
            throw new IllegalArgumentException("No value for optional field: MaxMessageSize");
        }

        if (buffer != null && maxMessageSizeLength > 0)
        {
            maxMessageSize = getIntFlyweight(buffer, maxMessageSizeOffset, maxMessageSizeLength, 383, CODEC_VALIDATION_ENABLED);
        }
        return maxMessageSize;
    }

    public boolean hasMaxMessageSize()
    {
        return hasMaxMessageSize;
    }


    private int maxMessageSizeOffset;

    private int maxMessageSizeLength;

    public int maxMessageSizeLength()
    {
        if (!hasMaxMessageSize)
        {
            throw new IllegalArgumentException("No value for optional field: MaxMessageSize");
        }

        return maxMessageSizeLength;
    }


    private boolean testMessageIndicator;

    private boolean hasTestMessageIndicator;

    public boolean testMessageIndicator()
    {
        if (!hasTestMessageIndicator)
        {
            throw new IllegalArgumentException("No value for optional field: TestMessageIndicator");
        }

        return testMessageIndicator;
    }

    public boolean hasTestMessageIndicator()
    {
        return hasTestMessageIndicator;
    }



    private char[] username = new char[1];

    private boolean hasUsername;

    public char[] username()
    {
        if (!hasUsername)
        {
            throw new IllegalArgumentException("No value for optional field: Username");
        }

        if (buffer != null && usernameLength > 0)
        {
            username = buffer.getChars(username, usernameOffset, usernameLength);
        }
        return username;
    }

    public boolean hasUsername()
    {
        return hasUsername;
    }


    private int usernameOffset;

    private int usernameLength;

    public int usernameLength()
    {
        if (!hasUsername)
        {
            throw new IllegalArgumentException("No value for optional field: Username");
        }

        return usernameLength;
    }

    public String usernameAsString()
    {
        return hasUsername ? buffer.getStringWithoutLengthAscii(usernameOffset, usernameLength) : null;
    }

    public void username(final AsciiSequenceView view)
    {
        if (!hasUsername)
        {
            throw new IllegalArgumentException("No value for optional field: Username");
        }

        view.wrap(buffer, usernameOffset, usernameLength);
    }


    private final CharArrayWrapper usernameWrapper = new CharArrayWrapper();
    private char[] password = new char[1];

    private boolean hasPassword;

    public char[] password()
    {
        if (!hasPassword)
        {
            throw new IllegalArgumentException("No value for optional field: Password");
        }

        if (buffer != null && passwordLength > 0)
        {
            password = buffer.getChars(password, passwordOffset, passwordLength);
        }
        return password;
    }

    public boolean hasPassword()
    {
        return hasPassword;
    }


    private int passwordOffset;

    private int passwordLength;

    public int passwordLength()
    {
        if (!hasPassword)
        {
            throw new IllegalArgumentException("No value for optional field: Password");
        }

        return passwordLength;
    }

    public String passwordAsString()
    {
        return hasPassword ? buffer.getStringWithoutLengthAscii(passwordOffset, passwordLength) : null;
    }

    public void password(final AsciiSequenceView view)
    {
        if (!hasPassword)
        {
            throw new IllegalArgumentException("No value for optional field: Password");
        }

        view.wrap(buffer, passwordOffset, passwordLength);
    }


    private final CharArrayWrapper passwordWrapper = new CharArrayWrapper();
    private int cancelOnDisconnectType = MISSING_INT;

    private boolean hasCancelOnDisconnectType;

    public int cancelOnDisconnectType()
    {
        if (!hasCancelOnDisconnectType)
        {
            throw new IllegalArgumentException("No value for optional field: CancelOnDisconnectType");
        }

        if (buffer != null && cancelOnDisconnectTypeLength > 0)
        {
            cancelOnDisconnectType = getIntFlyweight(buffer, cancelOnDisconnectTypeOffset, cancelOnDisconnectTypeLength, 35002, CODEC_VALIDATION_ENABLED);
        }
        return cancelOnDisconnectType;
    }

    public boolean hasCancelOnDisconnectType()
    {
        return hasCancelOnDisconnectType;
    }


    private int cancelOnDisconnectTypeOffset;

    private int cancelOnDisconnectTypeLength;

    public int cancelOnDisconnectTypeLength()
    {
        if (!hasCancelOnDisconnectType)
        {
            throw new IllegalArgumentException("No value for optional field: CancelOnDisconnectType");
        }

        return cancelOnDisconnectTypeLength;
    }


    private final CharArrayWrapper cancelOnDisconnectTypeWrapper = new CharArrayWrapper();
    public CancelOnDisconnectType cancelOnDisconnectTypeAsEnum()
    {
        if (!hasCancelOnDisconnectType)
 return CancelOnDisconnectType.NULL_VAL;
        return CancelOnDisconnectType.decode(this.cancelOnDisconnectType());
    }

    private int cODTimeoutWindow = MISSING_INT;

    private boolean hasCODTimeoutWindow;

    public int cODTimeoutWindow()
    {
        if (!hasCODTimeoutWindow)
        {
            throw new IllegalArgumentException("No value for optional field: CODTimeoutWindow");
        }

        if (buffer != null && cODTimeoutWindowLength > 0)
        {
            cODTimeoutWindow = getIntFlyweight(buffer, cODTimeoutWindowOffset, cODTimeoutWindowLength, 35003, CODEC_VALIDATION_ENABLED);
        }
        return cODTimeoutWindow;
    }

    public boolean hasCODTimeoutWindow()
    {
        return hasCODTimeoutWindow;
    }


    private int cODTimeoutWindowOffset;

    private int cODTimeoutWindowLength;

    public int cODTimeoutWindowLength()
    {
        if (!hasCODTimeoutWindow)
        {
            throw new IllegalArgumentException("No value for optional field: CODTimeoutWindow");
        }

        return cODTimeoutWindowLength;
    }


    public boolean supportsUsername()
    {
        return true;
    }

    public boolean supportsPassword()
    {
        return true;
    }

    public boolean supportsCancelOnDisconnectType()
    {
        return true;
    }

    public boolean supportsCODTimeoutWindow()
    {
        return true;
    }

    public int decode(final AsciiBuffer buffer, final int offset, final int length)
    {
        // Decode Logon
        int seenFieldCount = 0;
        if (CODEC_VALIDATION_ENABLED)
        {
            missingRequiredFields.copy(REQUIRED_FIELDS);
            alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        final int end = offset + length;
        int position = offset;
        position += header.decode(buffer, position, length);
        int tag;

        while (position < end)
        {
            final int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == AsciiBuffer.UNKNOWN_INDEX)
            {
               return position;
            }
            tag = buffer.getInt(position, equalsPosition);
            final int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, START_OF_HEADER);
            if (endOfField == AsciiBuffer.UNKNOWN_INDEX || equalsPosition == AsciiBuffer.UNKNOWN_INDEX)
            {
                rejectReason = 5;
                break;
            }
            final int valueLength = endOfField - valueOffset;
            if (CODEC_VALIDATION_ENABLED)
            {
                if (tag <= 0)
                {
                    invalidTagId = tag;
                    rejectReason = 0;
                }
                else if (valueLength == 0)
                {
                    invalidTagId = tag;
                    rejectReason = 4;
                }
                if (!alreadyVisitedFields.add(tag))
                {
                    invalidTagId = tag;
                    rejectReason = 13;
                }
                missingRequiredFields.remove(tag);
                seenFieldCount++;
            }

            switch (tag)
            {
            case Constants.ENCRYPT_METHOD:
                encryptMethodOffset = valueOffset;
                encryptMethodLength = valueLength;
                break;

            case Constants.HEART_BT_INT:
                heartBtIntOffset = valueOffset;
                heartBtIntLength = valueLength;
                break;

            case Constants.RAW_DATA_LENGTH:
                hasRawDataLength = true;
                rawDataLengthOffset = valueOffset;
                rawDataLengthLength = valueLength;
                break;

            case Constants.RAW_DATA:
                hasRawData = true;
                endOfField = valueOffset + this.rawDataLength();
                rawDataOffset = valueOffset;
                break;

            case Constants.RESET_SEQ_NUM_FLAG:
                hasResetSeqNumFlag = true;
                resetSeqNumFlag = buffer.getBoolean(valueOffset);
                break;

            case Constants.NEXT_EXPECTED_MSG_SEQ_NUM:
                hasNextExpectedMsgSeqNum = true;
                nextExpectedMsgSeqNumOffset = valueOffset;
                nextExpectedMsgSeqNumLength = valueLength;
                break;

            case Constants.MAX_MESSAGE_SIZE:
                hasMaxMessageSize = true;
                maxMessageSizeOffset = valueOffset;
                maxMessageSizeLength = valueLength;
                break;

            case Constants.TEST_MESSAGE_INDICATOR:
                hasTestMessageIndicator = true;
                testMessageIndicator = buffer.getBoolean(valueOffset);
                break;

            case Constants.USERNAME:
                hasUsername = true;
                usernameOffset = valueOffset;
                usernameLength = valueLength;
                break;

            case Constants.PASSWORD:
                hasPassword = true;
                passwordOffset = valueOffset;
                passwordLength = valueLength;
                break;

            case Constants.CANCEL_ON_DISCONNECT_TYPE:
                hasCancelOnDisconnectType = true;
                cancelOnDisconnectTypeOffset = valueOffset;
                cancelOnDisconnectTypeLength = valueLength;
                break;

            case Constants.C_O_D_TIMEOUT_WINDOW:
                hasCODTimeoutWindow = true;
                cODTimeoutWindowOffset = valueOffset;
                cODTimeoutWindowLength = valueLength;
                break;

            default:
                if (!CODEC_REJECT_UNKNOWN_FIELD_ENABLED)
                {
                    alreadyVisitedFields.remove(tag);
                }
                else
                {
                    if (!(trailer.REQUIRED_FIELDS.contains(tag)))
                    {
                        unknownFields.add(tag);
                    }
                }
                if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED || (trailer.REQUIRED_FIELDS.contains(tag)))
                {
                    position += trailer.decode(buffer, position, end - position);
                    return position - offset;
                }

            }

            if (position < (endOfField + 1))
            {
                position = endOfField + 1;
            }
        }
        position += trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset()
    {
        header.reset();
        trailer.reset();
        resetMessage();
        buffer = null;
        if (CODEC_VALIDATION_ENABLED)
        {
            invalidTagId = Decoder.NO_ERROR;
            rejectReason = Decoder.NO_ERROR;
            missingRequiredFields.clear();
            unknownFields.clear();
            alreadyVisitedFields.clear();
        }
    }

    public void resetMessage()
    {
        this.resetEncryptMethod();
        this.resetHeartBtInt();
        this.resetRawDataLength();
        this.resetRawData();
        this.resetResetSeqNumFlag();
        this.resetNextExpectedMsgSeqNum();
        this.resetMaxMessageSize();
        this.resetTestMessageIndicator();
        this.resetUsername();
        this.resetPassword();
        this.resetCancelOnDisconnectType();
        this.resetCODTimeoutWindow();
    }

    public void resetEncryptMethod()
    {
        encryptMethodLength = 0;
        encryptMethod = MISSING_INT;
    }

    public void resetHeartBtInt()
    {
        heartBtIntLength = 0;
        heartBtInt = MISSING_INT;
    }

    public void resetRawDataLength()
    {
        hasRawDataLength = false;
    }

    public void resetRawData()
    {
        hasRawData = false;
    }

    public void resetResetSeqNumFlag()
    {
        hasResetSeqNumFlag = false;
    }

    public void resetNextExpectedMsgSeqNum()
    {
        hasNextExpectedMsgSeqNum = false;
    }

    public void resetMaxMessageSize()
    {
        hasMaxMessageSize = false;
    }

    public void resetTestMessageIndicator()
    {
        hasTestMessageIndicator = false;
    }

    public void resetUsername()
    {
        hasUsername = false;
    }

    public void resetPassword()
    {
        hasPassword = false;
    }

    public void resetCancelOnDisconnectType()
    {
        hasCancelOnDisconnectType = false;
    }

    public void resetCODTimeoutWindow()
    {
        hasCODTimeoutWindow = false;
    }

    public String toString()
    {
        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        return appendTo(builder, 1);
    }

    public StringBuilder appendTo(final StringBuilder builder, final int level)
    {
        builder.append("{\n");        indent(builder, level);
        builder.append("\"MessageName\": \"Logon\",\n");
        builder.append("  \"header\": ");
        header.appendTo(builder, level + 1);
        builder.append("\n");
        indent(builder, level);
        builder.append("\"EncryptMethod\": \"");
        builder.append(this.encryptMethod());
        builder.append("\",\n");

        indent(builder, level);
        builder.append("\"HeartBtInt\": \"");
        builder.append(this.heartBtInt());
        builder.append("\",\n");

        if (hasRawDataLength())
        {
            indent(builder, level);
            builder.append("\"RawDataLength\": \"");
            builder.append(this.rawDataLength());
            builder.append("\",\n");
        }

        if (hasRawData())
        {
            indent(builder, level);
            builder.append("\"RawData\": \"");
            appendData(builder, this.rawData(), this.rawDataLength());
            builder.append("\",\n");
        }

        if (hasResetSeqNumFlag())
        {
            indent(builder, level);
            builder.append("\"ResetSeqNumFlag\": \"");
            builder.append(this.resetSeqNumFlag());
            builder.append("\",\n");
        }

        if (hasNextExpectedMsgSeqNum())
        {
            indent(builder, level);
            builder.append("\"NextExpectedMsgSeqNum\": \"");
            builder.append(this.nextExpectedMsgSeqNum());
            builder.append("\",\n");
        }

        if (hasMaxMessageSize())
        {
            indent(builder, level);
            builder.append("\"MaxMessageSize\": \"");
            builder.append(this.maxMessageSize());
            builder.append("\",\n");
        }

        if (hasTestMessageIndicator())
        {
            indent(builder, level);
            builder.append("\"TestMessageIndicator\": \"");
            builder.append(this.testMessageIndicator());
            builder.append("\",\n");
        }

        if (hasUsername())
        {
            indent(builder, level);
            builder.append("\"Username\": \"");
            builder.append(this.username(), 0, usernameLength());
            builder.append("\",\n");
        }

        if (hasPassword())
        {
            indent(builder, level);
            builder.append("\"Password\": \"");
            builder.append(this.password(), 0, passwordLength());
            builder.append("\",\n");
        }

        if (hasCancelOnDisconnectType())
        {
            indent(builder, level);
            builder.append("\"CancelOnDisconnectType\": \"");
            builder.append(this.cancelOnDisconnectType());
            builder.append("\",\n");
        }

        if (hasCODTimeoutWindow())
        {
            indent(builder, level);
            builder.append("\"CODTimeoutWindow\": \"");
            builder.append(this.cODTimeoutWindow());
            builder.append("\",\n");
        }
        indent(builder, level - 1);
        builder.append("}");
        return builder;
    }

    /**
     * {@inheritDoc}
     */
    public LogonEncoder toEncoder(final Encoder encoder)
    {
        return toEncoder((LogonEncoder)encoder);
    }

    public LogonEncoder toEncoder(final LogonEncoder encoder)
    {
        encoder.reset();
        encoder.encryptMethod(this.encryptMethod());
        encoder.heartBtInt(this.heartBtInt());
        if (hasRawDataLength())
        {
            encoder.rawDataLength(this.rawDataLength());
        }

        if (hasRawData())
        {
            encoder.rawDataAsCopy(this.rawData(), 0, rawDataLength());
            encoder.rawDataLength(this.rawDataLength());
        }

        if (hasResetSeqNumFlag())
        {
            encoder.resetSeqNumFlag(this.resetSeqNumFlag());
        }

        if (hasNextExpectedMsgSeqNum())
        {
            encoder.nextExpectedMsgSeqNum(this.nextExpectedMsgSeqNum());
        }

        if (hasMaxMessageSize())
        {
            encoder.maxMessageSize(this.maxMessageSize());
        }

        if (hasTestMessageIndicator())
        {
            encoder.testMessageIndicator(this.testMessageIndicator());
        }

        if (hasUsername())
        {
            encoder.username(this.username(), 0, usernameLength());
        }

        if (hasPassword())
        {
            encoder.password(this.password(), 0, passwordLength());
        }

        if (hasCancelOnDisconnectType())
        {
            encoder.cancelOnDisconnectType(this.cancelOnDisconnectType());
        }

        if (hasCODTimeoutWindow())
        {
            encoder.cODTimeoutWindow(this.cODTimeoutWindow());
        }
        return encoder;
    }

}
