/* Generated Fix Gateway message codec */
package uk.co.real_logic.artio.other.builder;

import org.agrona.MutableDirectBuffer;
import org.agrona.AsciiSequenceView;
import static uk.co.real_logic.artio.dictionary.generation.CodecUtil.*;
import static uk.co.real_logic.artio.dictionary.SessionConstants.*;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.fields.ReadOnlyDecimalFloat;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.fields.LocalMktDateEncoder;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.dictionary.CharArraySet;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.IntHashSet.IntIterator;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.AsciiSequenceView;
import static java.nio.charset.StandardCharsets.US_ASCII;
import static uk.co.real_logic.artio.builder.Validation.CODEC_VALIDATION_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED;
import uk.co.real_logic.artio.other.*;


public class HeaderEncoder implements uk.co.real_logic.artio.builder.SessionHeaderEncoder
{
    public HeaderEncoder()
    {
        beginStringAsCopy(DEFAULT_BEGIN_STRING, 0, DEFAULT_BEGIN_STRING.length);
    }


    private static final byte[] DEFAULT_BEGIN_STRING="FIX.4.4".getBytes(StandardCharsets.US_ASCII);

    private static final int beginStringHeaderLength = 2;
    private static final byte[] beginStringHeader = new byte[] {56, (byte) '='};

    private static final int bodyLengthHeaderLength = 2;
    private static final byte[] bodyLengthHeader = new byte[] {57, (byte) '='};

    private static final int msgTypeHeaderLength = 3;
    private static final byte[] msgTypeHeader = new byte[] {51, 53, (byte) '='};

    private static final int senderCompIDHeaderLength = 3;
    private static final byte[] senderCompIDHeader = new byte[] {52, 57, (byte) '='};

    private static final int targetCompIDHeaderLength = 3;
    private static final byte[] targetCompIDHeader = new byte[] {53, 54, (byte) '='};

    private static final int msgSeqNumHeaderLength = 3;
    private static final byte[] msgSeqNumHeader = new byte[] {51, 52, (byte) '='};

    private static final int senderSubIDHeaderLength = 3;
    private static final byte[] senderSubIDHeader = new byte[] {53, 48, (byte) '='};

    private static final int senderLocationIDHeaderLength = 4;
    private static final byte[] senderLocationIDHeader = new byte[] {49, 52, 50, (byte) '='};

    private static final int targetSubIDHeaderLength = 3;
    private static final byte[] targetSubIDHeader = new byte[] {53, 55, (byte) '='};

    private static final int targetLocationIDHeaderLength = 4;
    private static final byte[] targetLocationIDHeader = new byte[] {49, 52, 51, (byte) '='};

    private static final int possDupFlagHeaderLength = 3;
    private static final byte[] possDupFlagHeader = new byte[] {52, 51, (byte) '='};

    private static final int possResendHeaderLength = 3;
    private static final byte[] possResendHeader = new byte[] {57, 55, (byte) '='};

    private static final int sendingTimeHeaderLength = 3;
    private static final byte[] sendingTimeHeader = new byte[] {53, 50, (byte) '='};

    private static final int origSendingTimeHeaderLength = 4;
    private static final byte[] origSendingTimeHeader = new byte[] {49, 50, 50, (byte) '='};

    private static final int lastMsgSeqNumProcessedHeaderLength = 4;
    private static final byte[] lastMsgSeqNumProcessedHeader = new byte[] {51, 54, 57, (byte) '='};

    private static final int testFieldHeaderLength = 4;
    private static final byte[] testFieldHeader = new byte[] {57, 57, 57, (byte) '='};

    private final MutableDirectBuffer beginString = new UnsafeBuffer();

    private int beginStringOffset = 0;

    private int beginStringLength = 0;

    public HeaderEncoder beginString(final DirectBuffer value, final int offset, final int length)
    {
        beginString.wrap(value);
        beginStringOffset = offset;
        beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginString(final DirectBuffer value, final int length)
    {
        return beginString(value, 0, length);
    }

    public HeaderEncoder beginString(final DirectBuffer value)
    {
        return beginString(value, 0, value.capacity());
    }

    public HeaderEncoder beginString(final byte[] value, final int offset, final int length)
    {
        beginString.wrap(value);
        beginStringOffset = offset;
        beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginStringAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(beginString, value, offset, length);
        beginStringOffset = offset;
        beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginString(final byte[] value, final int length)
    {
        return beginString(value, 0, length);
    }

    public HeaderEncoder beginString(final byte[] value)
    {
        return beginString(value, 0, value.length);
    }

    public boolean hasBeginString()
    {
        return beginStringLength > 0;
    }

    public MutableDirectBuffer beginString()
    {
        return beginString;
    }

    public String beginStringAsString()
    {
        return beginString.getStringWithoutLengthAscii(beginStringOffset, beginStringLength);
    }

    public HeaderEncoder beginString(final CharSequence value)
    {
        toBytes(value, beginString);
        beginStringOffset = 0;
        beginStringLength = value.length();
        return this;
    }

    public HeaderEncoder beginString(final AsciiSequenceView value)
    {
        final DirectBuffer buffer = value.buffer();
        if (buffer != null)
        {
            beginString.wrap(buffer);
            beginStringOffset = value.offset();
            beginStringLength = value.length();
        }
        return this;
    }

    public HeaderEncoder beginString(final char[] value)
    {
        return beginString(value, 0, value.length);
    }

    public HeaderEncoder beginString(final char[] value, final int length)
    {
        return beginString(value, 0, length);
    }

    public HeaderEncoder beginString(final char[] value, final int offset, final int length)
    {
        toBytes(value, beginString, offset, length);
        beginStringOffset = 0;
        beginStringLength = length;
        return this;
    }

    private final MutableDirectBuffer msgType = new UnsafeBuffer();

    private int msgTypeOffset = 0;

    private int msgTypeLength = 0;

    public HeaderEncoder msgType(final DirectBuffer value, final int offset, final int length)
    {
        msgType.wrap(value);
        msgTypeOffset = offset;
        msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(final DirectBuffer value, final int length)
    {
        return msgType(value, 0, length);
    }

    public HeaderEncoder msgType(final DirectBuffer value)
    {
        return msgType(value, 0, value.capacity());
    }

    public HeaderEncoder msgType(final byte[] value, final int offset, final int length)
    {
        msgType.wrap(value);
        msgTypeOffset = offset;
        msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgTypeAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(msgType, value, offset, length);
        msgTypeOffset = offset;
        msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(final byte[] value, final int length)
    {
        return msgType(value, 0, length);
    }

    public HeaderEncoder msgType(final byte[] value)
    {
        return msgType(value, 0, value.length);
    }

    public boolean hasMsgType()
    {
        return msgTypeLength > 0;
    }

    public MutableDirectBuffer msgType()
    {
        return msgType;
    }

    public String msgTypeAsString()
    {
        return msgType.getStringWithoutLengthAscii(msgTypeOffset, msgTypeLength);
    }

    public HeaderEncoder msgType(final CharSequence value)
    {
        toBytes(value, msgType);
        msgTypeOffset = 0;
        msgTypeLength = value.length();
        return this;
    }

    public HeaderEncoder msgType(final AsciiSequenceView value)
    {
        final DirectBuffer buffer = value.buffer();
        if (buffer != null)
        {
            msgType.wrap(buffer);
            msgTypeOffset = value.offset();
            msgTypeLength = value.length();
        }
        return this;
    }

    public HeaderEncoder msgType(final char[] value)
    {
        return msgType(value, 0, value.length);
    }

    public HeaderEncoder msgType(final char[] value, final int length)
    {
        return msgType(value, 0, length);
    }

    public HeaderEncoder msgType(final char[] value, final int offset, final int length)
    {
        toBytes(value, msgType, offset, length);
        msgTypeOffset = 0;
        msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(MsgType value)
    {
        if (CODEC_VALIDATION_ENABLED)
        {
            if (value == MsgType.ARTIO_UNKNOWN)
            {
                throw new EncodingException("Invalid Value Field: msgType Value: " + value );
            }
            if (value == MsgType.NULL_VAL)
            {
                return this;
            }
        }
        return msgType(value.representation());
    }

    private final MutableDirectBuffer senderCompID = new UnsafeBuffer();

    private int senderCompIDOffset = 0;

    private int senderCompIDLength = 0;

    public HeaderEncoder senderCompID(final DirectBuffer value, final int offset, final int length)
    {
        senderCompID.wrap(value);
        senderCompIDOffset = offset;
        senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(final DirectBuffer value, final int length)
    {
        return senderCompID(value, 0, length);
    }

    public HeaderEncoder senderCompID(final DirectBuffer value)
    {
        return senderCompID(value, 0, value.capacity());
    }

    public HeaderEncoder senderCompID(final byte[] value, final int offset, final int length)
    {
        senderCompID.wrap(value);
        senderCompIDOffset = offset;
        senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompIDAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(senderCompID, value, offset, length);
        senderCompIDOffset = offset;
        senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(final byte[] value, final int length)
    {
        return senderCompID(value, 0, length);
    }

    public HeaderEncoder senderCompID(final byte[] value)
    {
        return senderCompID(value, 0, value.length);
    }

    public boolean hasSenderCompID()
    {
        return senderCompIDLength > 0;
    }

    public MutableDirectBuffer senderCompID()
    {
        return senderCompID;
    }

    public String senderCompIDAsString()
    {
        return senderCompID.getStringWithoutLengthAscii(senderCompIDOffset, senderCompIDLength);
    }

    public HeaderEncoder senderCompID(final CharSequence value)
    {
        toBytes(value, senderCompID);
        senderCompIDOffset = 0;
        senderCompIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderCompID(final AsciiSequenceView value)
    {
        final DirectBuffer buffer = value.buffer();
        if (buffer != null)
        {
            senderCompID.wrap(buffer);
            senderCompIDOffset = value.offset();
            senderCompIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder senderCompID(final char[] value)
    {
        return senderCompID(value, 0, value.length);
    }

    public HeaderEncoder senderCompID(final char[] value, final int length)
    {
        return senderCompID(value, 0, length);
    }

    public HeaderEncoder senderCompID(final char[] value, final int offset, final int length)
    {
        toBytes(value, senderCompID, offset, length);
        senderCompIDOffset = 0;
        senderCompIDLength = length;
        return this;
    }

    private final MutableDirectBuffer targetCompID = new UnsafeBuffer();

    private int targetCompIDOffset = 0;

    private int targetCompIDLength = 0;

    public HeaderEncoder targetCompID(final DirectBuffer value, final int offset, final int length)
    {
        targetCompID.wrap(value);
        targetCompIDOffset = offset;
        targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(final DirectBuffer value, final int length)
    {
        return targetCompID(value, 0, length);
    }

    public HeaderEncoder targetCompID(final DirectBuffer value)
    {
        return targetCompID(value, 0, value.capacity());
    }

    public HeaderEncoder targetCompID(final byte[] value, final int offset, final int length)
    {
        targetCompID.wrap(value);
        targetCompIDOffset = offset;
        targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompIDAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(targetCompID, value, offset, length);
        targetCompIDOffset = offset;
        targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(final byte[] value, final int length)
    {
        return targetCompID(value, 0, length);
    }

    public HeaderEncoder targetCompID(final byte[] value)
    {
        return targetCompID(value, 0, value.length);
    }

    public boolean hasTargetCompID()
    {
        return targetCompIDLength > 0;
    }

    public MutableDirectBuffer targetCompID()
    {
        return targetCompID;
    }

    public String targetCompIDAsString()
    {
        return targetCompID.getStringWithoutLengthAscii(targetCompIDOffset, targetCompIDLength);
    }

    public HeaderEncoder targetCompID(final CharSequence value)
    {
        toBytes(value, targetCompID);
        targetCompIDOffset = 0;
        targetCompIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetCompID(final AsciiSequenceView value)
    {
        final DirectBuffer buffer = value.buffer();
        if (buffer != null)
        {
            targetCompID.wrap(buffer);
            targetCompIDOffset = value.offset();
            targetCompIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder targetCompID(final char[] value)
    {
        return targetCompID(value, 0, value.length);
    }

    public HeaderEncoder targetCompID(final char[] value, final int length)
    {
        return targetCompID(value, 0, length);
    }

    public HeaderEncoder targetCompID(final char[] value, final int offset, final int length)
    {
        toBytes(value, targetCompID, offset, length);
        targetCompIDOffset = 0;
        targetCompIDLength = length;
        return this;
    }

    private int msgSeqNum;

    private boolean hasMsgSeqNum;

    public boolean hasMsgSeqNum()
    {
        return hasMsgSeqNum;
    }

    public HeaderEncoder msgSeqNum(int value)
    {
        msgSeqNum = value;
        hasMsgSeqNum = true;
        return this;
    }

    public int msgSeqNum()
    {
        return msgSeqNum;
    }

    private final MutableDirectBuffer senderSubID = new UnsafeBuffer();

    private int senderSubIDOffset = 0;

    private int senderSubIDLength = 0;

    public HeaderEncoder senderSubID(final DirectBuffer value, final int offset, final int length)
    {
        senderSubID.wrap(value);
        senderSubIDOffset = offset;
        senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubID(final DirectBuffer value, final int length)
    {
        return senderSubID(value, 0, length);
    }

    public HeaderEncoder senderSubID(final DirectBuffer value)
    {
        return senderSubID(value, 0, value.capacity());
    }

    public HeaderEncoder senderSubID(final byte[] value, final int offset, final int length)
    {
        senderSubID.wrap(value);
        senderSubIDOffset = offset;
        senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubIDAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(senderSubID, value, offset, length);
        senderSubIDOffset = offset;
        senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubID(final byte[] value, final int length)
    {
        return senderSubID(value, 0, length);
    }

    public HeaderEncoder senderSubID(final byte[] value)
    {
        return senderSubID(value, 0, value.length);
    }

    public boolean hasSenderSubID()
    {
        return senderSubIDLength > 0;
    }

    public MutableDirectBuffer senderSubID()
    {
        return senderSubID;
    }

    public String senderSubIDAsString()
    {
        return senderSubID.getStringWithoutLengthAscii(senderSubIDOffset, senderSubIDLength);
    }

    public HeaderEncoder senderSubID(final CharSequence value)
    {
        toBytes(value, senderSubID);
        senderSubIDOffset = 0;
        senderSubIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderSubID(final AsciiSequenceView value)
    {
        final DirectBuffer buffer = value.buffer();
        if (buffer != null)
        {
            senderSubID.wrap(buffer);
            senderSubIDOffset = value.offset();
            senderSubIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder senderSubID(final char[] value)
    {
        return senderSubID(value, 0, value.length);
    }

    public HeaderEncoder senderSubID(final char[] value, final int length)
    {
        return senderSubID(value, 0, length);
    }

    public HeaderEncoder senderSubID(final char[] value, final int offset, final int length)
    {
        toBytes(value, senderSubID, offset, length);
        senderSubIDOffset = 0;
        senderSubIDLength = length;
        return this;
    }

    private final MutableDirectBuffer senderLocationID = new UnsafeBuffer();

    private int senderLocationIDOffset = 0;

    private int senderLocationIDLength = 0;

    public HeaderEncoder senderLocationID(final DirectBuffer value, final int offset, final int length)
    {
        senderLocationID.wrap(value);
        senderLocationIDOffset = offset;
        senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(final DirectBuffer value, final int length)
    {
        return senderLocationID(value, 0, length);
    }

    public HeaderEncoder senderLocationID(final DirectBuffer value)
    {
        return senderLocationID(value, 0, value.capacity());
    }

    public HeaderEncoder senderLocationID(final byte[] value, final int offset, final int length)
    {
        senderLocationID.wrap(value);
        senderLocationIDOffset = offset;
        senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationIDAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(senderLocationID, value, offset, length);
        senderLocationIDOffset = offset;
        senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(final byte[] value, final int length)
    {
        return senderLocationID(value, 0, length);
    }

    public HeaderEncoder senderLocationID(final byte[] value)
    {
        return senderLocationID(value, 0, value.length);
    }

    public boolean hasSenderLocationID()
    {
        return senderLocationIDLength > 0;
    }

    public MutableDirectBuffer senderLocationID()
    {
        return senderLocationID;
    }

    public String senderLocationIDAsString()
    {
        return senderLocationID.getStringWithoutLengthAscii(senderLocationIDOffset, senderLocationIDLength);
    }

    public HeaderEncoder senderLocationID(final CharSequence value)
    {
        toBytes(value, senderLocationID);
        senderLocationIDOffset = 0;
        senderLocationIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderLocationID(final AsciiSequenceView value)
    {
        final DirectBuffer buffer = value.buffer();
        if (buffer != null)
        {
            senderLocationID.wrap(buffer);
            senderLocationIDOffset = value.offset();
            senderLocationIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder senderLocationID(final char[] value)
    {
        return senderLocationID(value, 0, value.length);
    }

    public HeaderEncoder senderLocationID(final char[] value, final int length)
    {
        return senderLocationID(value, 0, length);
    }

    public HeaderEncoder senderLocationID(final char[] value, final int offset, final int length)
    {
        toBytes(value, senderLocationID, offset, length);
        senderLocationIDOffset = 0;
        senderLocationIDLength = length;
        return this;
    }

    private final MutableDirectBuffer targetSubID = new UnsafeBuffer();

    private int targetSubIDOffset = 0;

    private int targetSubIDLength = 0;

    public HeaderEncoder targetSubID(final DirectBuffer value, final int offset, final int length)
    {
        targetSubID.wrap(value);
        targetSubIDOffset = offset;
        targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(final DirectBuffer value, final int length)
    {
        return targetSubID(value, 0, length);
    }

    public HeaderEncoder targetSubID(final DirectBuffer value)
    {
        return targetSubID(value, 0, value.capacity());
    }

    public HeaderEncoder targetSubID(final byte[] value, final int offset, final int length)
    {
        targetSubID.wrap(value);
        targetSubIDOffset = offset;
        targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubIDAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(targetSubID, value, offset, length);
        targetSubIDOffset = offset;
        targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(final byte[] value, final int length)
    {
        return targetSubID(value, 0, length);
    }

    public HeaderEncoder targetSubID(final byte[] value)
    {
        return targetSubID(value, 0, value.length);
    }

    public boolean hasTargetSubID()
    {
        return targetSubIDLength > 0;
    }

    public MutableDirectBuffer targetSubID()
    {
        return targetSubID;
    }

    public String targetSubIDAsString()
    {
        return targetSubID.getStringWithoutLengthAscii(targetSubIDOffset, targetSubIDLength);
    }

    public HeaderEncoder targetSubID(final CharSequence value)
    {
        toBytes(value, targetSubID);
        targetSubIDOffset = 0;
        targetSubIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetSubID(final AsciiSequenceView value)
    {
        final DirectBuffer buffer = value.buffer();
        if (buffer != null)
        {
            targetSubID.wrap(buffer);
            targetSubIDOffset = value.offset();
            targetSubIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder targetSubID(final char[] value)
    {
        return targetSubID(value, 0, value.length);
    }

    public HeaderEncoder targetSubID(final char[] value, final int length)
    {
        return targetSubID(value, 0, length);
    }

    public HeaderEncoder targetSubID(final char[] value, final int offset, final int length)
    {
        toBytes(value, targetSubID, offset, length);
        targetSubIDOffset = 0;
        targetSubIDLength = length;
        return this;
    }

    private final MutableDirectBuffer targetLocationID = new UnsafeBuffer();

    private int targetLocationIDOffset = 0;

    private int targetLocationIDLength = 0;

    public HeaderEncoder targetLocationID(final DirectBuffer value, final int offset, final int length)
    {
        targetLocationID.wrap(value);
        targetLocationIDOffset = offset;
        targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(final DirectBuffer value, final int length)
    {
        return targetLocationID(value, 0, length);
    }

    public HeaderEncoder targetLocationID(final DirectBuffer value)
    {
        return targetLocationID(value, 0, value.capacity());
    }

    public HeaderEncoder targetLocationID(final byte[] value, final int offset, final int length)
    {
        targetLocationID.wrap(value);
        targetLocationIDOffset = offset;
        targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationIDAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(targetLocationID, value, offset, length);
        targetLocationIDOffset = offset;
        targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(final byte[] value, final int length)
    {
        return targetLocationID(value, 0, length);
    }

    public HeaderEncoder targetLocationID(final byte[] value)
    {
        return targetLocationID(value, 0, value.length);
    }

    public boolean hasTargetLocationID()
    {
        return targetLocationIDLength > 0;
    }

    public MutableDirectBuffer targetLocationID()
    {
        return targetLocationID;
    }

    public String targetLocationIDAsString()
    {
        return targetLocationID.getStringWithoutLengthAscii(targetLocationIDOffset, targetLocationIDLength);
    }

    public HeaderEncoder targetLocationID(final CharSequence value)
    {
        toBytes(value, targetLocationID);
        targetLocationIDOffset = 0;
        targetLocationIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetLocationID(final AsciiSequenceView value)
    {
        final DirectBuffer buffer = value.buffer();
        if (buffer != null)
        {
            targetLocationID.wrap(buffer);
            targetLocationIDOffset = value.offset();
            targetLocationIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder targetLocationID(final char[] value)
    {
        return targetLocationID(value, 0, value.length);
    }

    public HeaderEncoder targetLocationID(final char[] value, final int length)
    {
        return targetLocationID(value, 0, length);
    }

    public HeaderEncoder targetLocationID(final char[] value, final int offset, final int length)
    {
        toBytes(value, targetLocationID, offset, length);
        targetLocationIDOffset = 0;
        targetLocationIDLength = length;
        return this;
    }

    private boolean possDupFlag;

    private boolean hasPossDupFlag;

    public boolean hasPossDupFlag()
    {
        return hasPossDupFlag;
    }

    public HeaderEncoder possDupFlag(boolean value)
    {
        possDupFlag = value;
        hasPossDupFlag = true;
        return this;
    }

    public boolean possDupFlag()
    {
        return possDupFlag;
    }

    private boolean possResend;

    private boolean hasPossResend;

    public boolean hasPossResend()
    {
        return hasPossResend;
    }

    public HeaderEncoder possResend(boolean value)
    {
        possResend = value;
        hasPossResend = true;
        return this;
    }

    public boolean possResend()
    {
        return possResend;
    }

    private final MutableDirectBuffer sendingTime = new UnsafeBuffer();

    private int sendingTimeOffset = 0;

    private int sendingTimeLength = 0;

    public HeaderEncoder sendingTime(final DirectBuffer value, final int offset, final int length)
    {
        sendingTime.wrap(value);
        sendingTimeOffset = offset;
        sendingTimeLength = length;
        return this;
    }

    public HeaderEncoder sendingTime(final DirectBuffer value, final int length)
    {
        return sendingTime(value, 0, length);
    }

    public HeaderEncoder sendingTime(final DirectBuffer value)
    {
        return sendingTime(value, 0, value.capacity());
    }

    public HeaderEncoder sendingTime(final byte[] value, final int offset, final int length)
    {
        sendingTime.wrap(value);
        sendingTimeOffset = offset;
        sendingTimeLength = length;
        return this;
    }

    public HeaderEncoder sendingTimeAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(sendingTime, value, offset, length);
        sendingTimeOffset = offset;
        sendingTimeLength = length;
        return this;
    }

    public HeaderEncoder sendingTime(final byte[] value, final int length)
    {
        return sendingTime(value, 0, length);
    }

    public HeaderEncoder sendingTime(final byte[] value)
    {
        return sendingTime(value, 0, value.length);
    }

    public boolean hasSendingTime()
    {
        return sendingTimeLength > 0;
    }

    public MutableDirectBuffer sendingTime()
    {
        return sendingTime;
    }

    public String sendingTimeAsString()
    {
        return sendingTime.getStringWithoutLengthAscii(sendingTimeOffset, sendingTimeLength);
    }

    private final MutableDirectBuffer origSendingTime = new UnsafeBuffer();

    private int origSendingTimeOffset = 0;

    private int origSendingTimeLength = 0;

    public HeaderEncoder origSendingTime(final DirectBuffer value, final int offset, final int length)
    {
        origSendingTime.wrap(value);
        origSendingTimeOffset = offset;
        origSendingTimeLength = length;
        return this;
    }

    public HeaderEncoder origSendingTime(final DirectBuffer value, final int length)
    {
        return origSendingTime(value, 0, length);
    }

    public HeaderEncoder origSendingTime(final DirectBuffer value)
    {
        return origSendingTime(value, 0, value.capacity());
    }

    public HeaderEncoder origSendingTime(final byte[] value, final int offset, final int length)
    {
        origSendingTime.wrap(value);
        origSendingTimeOffset = offset;
        origSendingTimeLength = length;
        return this;
    }

    public HeaderEncoder origSendingTimeAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(origSendingTime, value, offset, length);
        origSendingTimeOffset = offset;
        origSendingTimeLength = length;
        return this;
    }

    public HeaderEncoder origSendingTime(final byte[] value, final int length)
    {
        return origSendingTime(value, 0, length);
    }

    public HeaderEncoder origSendingTime(final byte[] value)
    {
        return origSendingTime(value, 0, value.length);
    }

    public boolean hasOrigSendingTime()
    {
        return origSendingTimeLength > 0;
    }

    public MutableDirectBuffer origSendingTime()
    {
        return origSendingTime;
    }

    public String origSendingTimeAsString()
    {
        return origSendingTime.getStringWithoutLengthAscii(origSendingTimeOffset, origSendingTimeLength);
    }

    private int lastMsgSeqNumProcessed;

    private boolean hasLastMsgSeqNumProcessed;

    public boolean hasLastMsgSeqNumProcessed()
    {
        return hasLastMsgSeqNumProcessed;
    }

    public HeaderEncoder lastMsgSeqNumProcessed(int value)
    {
        lastMsgSeqNumProcessed = value;
        hasLastMsgSeqNumProcessed = true;
        return this;
    }

    public int lastMsgSeqNumProcessed()
    {
        return lastMsgSeqNumProcessed;
    }

    private final MutableDirectBuffer testField = new UnsafeBuffer();

    private int testFieldOffset = 0;

    private int testFieldLength = 0;

    public HeaderEncoder testField(final DirectBuffer value, final int offset, final int length)
    {
        testField.wrap(value);
        testFieldOffset = offset;
        testFieldLength = length;
        return this;
    }

    public HeaderEncoder testField(final DirectBuffer value, final int length)
    {
        return testField(value, 0, length);
    }

    public HeaderEncoder testField(final DirectBuffer value)
    {
        return testField(value, 0, value.capacity());
    }

    public HeaderEncoder testField(final byte[] value, final int offset, final int length)
    {
        testField.wrap(value);
        testFieldOffset = offset;
        testFieldLength = length;
        return this;
    }

    public HeaderEncoder testFieldAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(testField, value, offset, length);
        testFieldOffset = offset;
        testFieldLength = length;
        return this;
    }

    public HeaderEncoder testField(final byte[] value, final int length)
    {
        return testField(value, 0, length);
    }

    public HeaderEncoder testField(final byte[] value)
    {
        return testField(value, 0, value.length);
    }

    public boolean hasTestField()
    {
        return testFieldLength > 0;
    }

    public MutableDirectBuffer testField()
    {
        return testField;
    }

    public String testFieldAsString()
    {
        return testField.getStringWithoutLengthAscii(testFieldOffset, testFieldLength);
    }

    public HeaderEncoder testField(final CharSequence value)
    {
        toBytes(value, testField);
        testFieldOffset = 0;
        testFieldLength = value.length();
        return this;
    }

    public HeaderEncoder testField(final AsciiSequenceView value)
    {
        final DirectBuffer buffer = value.buffer();
        if (buffer != null)
        {
            testField.wrap(buffer);
            testFieldOffset = value.offset();
            testFieldLength = value.length();
        }
        return this;
    }

    public HeaderEncoder testField(final char[] value)
    {
        return testField(value, 0, value.length);
    }

    public HeaderEncoder testField(final char[] value, final int length)
    {
        return testField(value, 0, length);
    }

    public HeaderEncoder testField(final char[] value, final int offset, final int length)
    {
        toBytes(value, testField, offset, length);
        testFieldOffset = 0;
        testFieldLength = length;
        return this;
    }

    int finishHeader(final MutableAsciiBuffer buffer, final int bodyStart, final int bodyLength)
    {
        int position = bodyStart - 1;

        buffer.putSeparator(position);
        position = buffer.putNaturalIntAsciiFromEnd(bodyLength, position);
        position -= bodyLengthHeaderLength;
        buffer.putBytes(position, bodyLengthHeader, 0, bodyLengthHeaderLength);

        if (beginStringLength > 0) {
        position--;
        buffer.putSeparator(position);
        position -= beginStringLength;
        buffer.putBytes(position, beginString, beginStringOffset, beginStringLength);
        position -= beginStringHeaderLength;
        buffer.putBytes(position, beginStringHeader, 0, beginStringHeaderLength);
        } else if (CODEC_VALIDATION_ENABLED)
        {
            throw new EncodingException("Missing Field: BeginString");
        }

        return position;
    }

    // 35=...| + other header fields
    public long startMessage(final MutableAsciiBuffer buffer, final int offset)
    {
        final int start = offset + beginStringLength + 16;
        int position = start;

        if (msgTypeLength > 0)
        {
            buffer.putBytes(position, msgTypeHeader, 0, msgTypeHeaderLength);
            position += msgTypeHeaderLength;
            buffer.putBytes(position, msgType, msgTypeOffset, msgTypeLength);
            position += msgTypeLength;
            buffer.putSeparator(position);
            position++;
        }
        else if (CODEC_VALIDATION_ENABLED)
        {
            throw new EncodingException("Missing Field: MsgType");
        }

        if (senderCompIDLength > 0)
        {
            buffer.putBytes(position, senderCompIDHeader, 0, senderCompIDHeaderLength);
            position += senderCompIDHeaderLength;
            buffer.putBytes(position, senderCompID, senderCompIDOffset, senderCompIDLength);
            position += senderCompIDLength;
            buffer.putSeparator(position);
            position++;
        }
        else if (CODEC_VALIDATION_ENABLED)
        {
            throw new EncodingException("Missing Field: SenderCompID");
        }

        if (targetCompIDLength > 0)
        {
            buffer.putBytes(position, targetCompIDHeader, 0, targetCompIDHeaderLength);
            position += targetCompIDHeaderLength;
            buffer.putBytes(position, targetCompID, targetCompIDOffset, targetCompIDLength);
            position += targetCompIDLength;
            buffer.putSeparator(position);
            position++;
        }
        else if (CODEC_VALIDATION_ENABLED)
        {
            throw new EncodingException("Missing Field: TargetCompID");
        }

        if (hasMsgSeqNum)
        {
            buffer.putBytes(position, msgSeqNumHeader, 0, msgSeqNumHeaderLength);
            position += msgSeqNumHeaderLength;
            position += buffer.putIntAscii(position, msgSeqNum);
            buffer.putSeparator(position);
            position++;
        }

        if (senderSubIDLength > 0)
        {
            buffer.putBytes(position, senderSubIDHeader, 0, senderSubIDHeaderLength);
            position += senderSubIDHeaderLength;
            buffer.putBytes(position, senderSubID, senderSubIDOffset, senderSubIDLength);
            position += senderSubIDLength;
            buffer.putSeparator(position);
            position++;
        }

        if (senderLocationIDLength > 0)
        {
            buffer.putBytes(position, senderLocationIDHeader, 0, senderLocationIDHeaderLength);
            position += senderLocationIDHeaderLength;
            buffer.putBytes(position, senderLocationID, senderLocationIDOffset, senderLocationIDLength);
            position += senderLocationIDLength;
            buffer.putSeparator(position);
            position++;
        }

        if (targetSubIDLength > 0)
        {
            buffer.putBytes(position, targetSubIDHeader, 0, targetSubIDHeaderLength);
            position += targetSubIDHeaderLength;
            buffer.putBytes(position, targetSubID, targetSubIDOffset, targetSubIDLength);
            position += targetSubIDLength;
            buffer.putSeparator(position);
            position++;
        }

        if (targetLocationIDLength > 0)
        {
            buffer.putBytes(position, targetLocationIDHeader, 0, targetLocationIDHeaderLength);
            position += targetLocationIDHeaderLength;
            buffer.putBytes(position, targetLocationID, targetLocationIDOffset, targetLocationIDLength);
            position += targetLocationIDLength;
            buffer.putSeparator(position);
            position++;
        }

        if (hasPossDupFlag)
        {
            buffer.putBytes(position, possDupFlagHeader, 0, possDupFlagHeaderLength);
            position += possDupFlagHeaderLength;
            position += buffer.putBooleanAscii(position, possDupFlag);
            buffer.putSeparator(position);
            position++;
        }

        if (hasPossResend)
        {
            buffer.putBytes(position, possResendHeader, 0, possResendHeaderLength);
            position += possResendHeaderLength;
            position += buffer.putBooleanAscii(position, possResend);
            buffer.putSeparator(position);
            position++;
        }

        if (sendingTimeLength > 0)
        {
            buffer.putBytes(position, sendingTimeHeader, 0, sendingTimeHeaderLength);
            position += sendingTimeHeaderLength;
            buffer.putBytes(position, sendingTime, sendingTimeOffset, sendingTimeLength);
            position += sendingTimeLength;
            buffer.putSeparator(position);
            position++;
        }
        else if (CODEC_VALIDATION_ENABLED)
        {
            throw new EncodingException("Missing Field: SendingTime");
        }

        if (origSendingTimeLength > 0)
        {
            buffer.putBytes(position, origSendingTimeHeader, 0, origSendingTimeHeaderLength);
            position += origSendingTimeHeaderLength;
            buffer.putBytes(position, origSendingTime, origSendingTimeOffset, origSendingTimeLength);
            position += origSendingTimeLength;
            buffer.putSeparator(position);
            position++;
        }

        if (hasLastMsgSeqNumProcessed)
        {
            buffer.putBytes(position, lastMsgSeqNumProcessedHeader, 0, lastMsgSeqNumProcessedHeaderLength);
            position += lastMsgSeqNumProcessedHeaderLength;
            position += buffer.putIntAscii(position, lastMsgSeqNumProcessed);
            buffer.putSeparator(position);
            position++;
        }

        if (testFieldLength > 0)
        {
            buffer.putBytes(position, testFieldHeader, 0, testFieldHeaderLength);
            position += testFieldHeaderLength;
            buffer.putBytes(position, testField, testFieldOffset, testFieldLength);
            position += testFieldLength;
            buffer.putSeparator(position);
            position++;
        }

        return Encoder.result(position - start, start);
    }

    public void reset()
    {
        this.resetSenderCompID();
        this.resetTargetCompID();
        this.resetMsgSeqNum();
        this.resetSenderSubID();
        this.resetSenderLocationID();
        this.resetTargetSubID();
        this.resetTargetLocationID();
        this.resetPossDupFlag();
        this.resetPossResend();
        this.resetSendingTime();
        this.resetOrigSendingTime();
        this.resetLastMsgSeqNumProcessed();
        this.resetTestField();
        beginStringAsCopy(DEFAULT_BEGIN_STRING, 0, DEFAULT_BEGIN_STRING.length);
    }

    public void resetSenderCompID()
    {
        senderCompIDLength = 0;
    }

    public void resetTargetCompID()
    {
        targetCompIDLength = 0;
    }

    public void resetMsgSeqNum()
    {
        hasMsgSeqNum = false;
    }

    public void resetSenderSubID()
    {
        senderSubIDLength = 0;
    }

    public void resetSenderLocationID()
    {
        senderLocationIDLength = 0;
    }

    public void resetTargetSubID()
    {
        targetSubIDLength = 0;
    }

    public void resetTargetLocationID()
    {
        targetLocationIDLength = 0;
    }

    public void resetPossDupFlag()
    {
        hasPossDupFlag = false;
    }

    public void resetPossResend()
    {
        hasPossResend = false;
    }

    public void resetSendingTime()
    {
        sendingTimeLength = 0;
    }

    public void resetOrigSendingTime()
    {
        origSendingTimeLength = 0;
    }

    public void resetLastMsgSeqNumProcessed()
    {
        hasLastMsgSeqNumProcessed = false;
    }

    public void resetTestField()
    {
        testFieldLength = 0;
    }

    public String toString()
    {
        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        return appendTo(builder, 1);
    }

    public StringBuilder appendTo(final StringBuilder builder, final int level)
    {
        builder.append("{\n");        indent(builder, level);
        builder.append("\"MessageName\": \"Header\",\n");
        if (hasBeginString())
        {
            indent(builder, level);
            builder.append("\"BeginString\": \"");
            appendBuffer(builder, beginString, beginStringOffset, beginStringLength);
            builder.append("\",\n");
        }


        if (hasMsgType())
        {
            indent(builder, level);
            builder.append("\"MsgType\": \"");
            appendBuffer(builder, msgType, msgTypeOffset, msgTypeLength);
            builder.append("\",\n");
        }

        if (hasSenderCompID())
        {
            indent(builder, level);
            builder.append("\"SenderCompID\": \"");
            appendBuffer(builder, senderCompID, senderCompIDOffset, senderCompIDLength);
            builder.append("\",\n");
        }

        if (hasTargetCompID())
        {
            indent(builder, level);
            builder.append("\"TargetCompID\": \"");
            appendBuffer(builder, targetCompID, targetCompIDOffset, targetCompIDLength);
            builder.append("\",\n");
        }

        if (hasMsgSeqNum())
        {
            indent(builder, level);
            builder.append("\"MsgSeqNum\": \"");
            builder.append(msgSeqNum);
            builder.append("\",\n");
        }

        if (hasSenderSubID())
        {
            indent(builder, level);
            builder.append("\"SenderSubID\": \"");
            appendBuffer(builder, senderSubID, senderSubIDOffset, senderSubIDLength);
            builder.append("\",\n");
        }

        if (hasSenderLocationID())
        {
            indent(builder, level);
            builder.append("\"SenderLocationID\": \"");
            appendBuffer(builder, senderLocationID, senderLocationIDOffset, senderLocationIDLength);
            builder.append("\",\n");
        }

        if (hasTargetSubID())
        {
            indent(builder, level);
            builder.append("\"TargetSubID\": \"");
            appendBuffer(builder, targetSubID, targetSubIDOffset, targetSubIDLength);
            builder.append("\",\n");
        }

        if (hasTargetLocationID())
        {
            indent(builder, level);
            builder.append("\"TargetLocationID\": \"");
            appendBuffer(builder, targetLocationID, targetLocationIDOffset, targetLocationIDLength);
            builder.append("\",\n");
        }

        if (hasPossDupFlag())
        {
            indent(builder, level);
            builder.append("\"PossDupFlag\": \"");
            builder.append(possDupFlag);
            builder.append("\",\n");
        }

        if (hasPossResend())
        {
            indent(builder, level);
            builder.append("\"PossResend\": \"");
            builder.append(possResend);
            builder.append("\",\n");
        }

        if (hasSendingTime())
        {
            indent(builder, level);
            builder.append("\"SendingTime\": \"");
            appendBuffer(builder, sendingTime, sendingTimeOffset, sendingTimeLength);
            builder.append("\",\n");
        }

        if (hasOrigSendingTime())
        {
            indent(builder, level);
            builder.append("\"OrigSendingTime\": \"");
            appendBuffer(builder, origSendingTime, origSendingTimeOffset, origSendingTimeLength);
            builder.append("\",\n");
        }

        if (hasLastMsgSeqNumProcessed())
        {
            indent(builder, level);
            builder.append("\"LastMsgSeqNumProcessed\": \"");
            builder.append(lastMsgSeqNumProcessed);
            builder.append("\",\n");
        }

        if (hasTestField())
        {
            indent(builder, level);
            builder.append("\"TestField\": \"");
            appendBuffer(builder, testField, testFieldOffset, testFieldLength);
            builder.append("\",\n");
        }
        indent(builder, level - 1);
        builder.append("}");
        return builder;
    }

    /**
     * {@inheritDoc}
     */
    public HeaderEncoder copyTo(final Encoder encoder)
    {
        return copyTo((HeaderEncoder)encoder);
    }

    public HeaderEncoder copyTo(final HeaderEncoder encoder)
    {
        encoder.reset();
        if (hasBeginString())
        {
            encoder.beginStringAsCopy(beginString.byteArray(), 0, beginStringLength);
        }


        if (hasMsgType())
        {
            encoder.msgTypeAsCopy(msgType.byteArray(), 0, msgTypeLength);
        }

        if (hasSenderCompID())
        {
            encoder.senderCompIDAsCopy(senderCompID.byteArray(), 0, senderCompIDLength);
        }

        if (hasTargetCompID())
        {
            encoder.targetCompIDAsCopy(targetCompID.byteArray(), 0, targetCompIDLength);
        }

        if (hasMsgSeqNum())
        {
            encoder.msgSeqNum(this.msgSeqNum());
        }

        if (hasSenderSubID())
        {
            encoder.senderSubIDAsCopy(senderSubID.byteArray(), 0, senderSubIDLength);
        }

        if (hasSenderLocationID())
        {
            encoder.senderLocationIDAsCopy(senderLocationID.byteArray(), 0, senderLocationIDLength);
        }

        if (hasTargetSubID())
        {
            encoder.targetSubIDAsCopy(targetSubID.byteArray(), 0, targetSubIDLength);
        }

        if (hasTargetLocationID())
        {
            encoder.targetLocationIDAsCopy(targetLocationID.byteArray(), 0, targetLocationIDLength);
        }

        if (hasPossDupFlag())
        {
            encoder.possDupFlag(this.possDupFlag());
        }

        if (hasPossResend())
        {
            encoder.possResend(this.possResend());
        }

        if (hasSendingTime())
        {
            encoder.sendingTimeAsCopy(sendingTime.byteArray(), 0, sendingTimeLength);
        }

        if (hasOrigSendingTime())
        {
            encoder.origSendingTimeAsCopy(origSendingTime.byteArray(), 0, origSendingTimeLength);
        }

        if (hasLastMsgSeqNumProcessed())
        {
            encoder.lastMsgSeqNumProcessed(this.lastMsgSeqNumProcessed());
        }

        if (hasTestField())
        {
            encoder.testFieldAsCopy(testField.byteArray(), 0, testFieldLength);
        }
        return encoder;
    }

}
