/* Generated Fix Gateway message codec */
package uk.co.real_logic.artio.other;

import uk.co.real_logic.artio.dictionary.CharArrayMap;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import org.agrona.collections.IntHashSet;
import java.util.Map;
import java.util.HashMap;
import uk.co.real_logic.artio.builder.IntRepresentable;
public enum UserRequestType implements IntRepresentable
{
    LogOnUser(1),
    LogOffUser(2),
    ChangePasswordForUser(3),
    RequestIndividualUserStatus(4),
    NULL_VAL(-2147483648),
    ARTIO_UNKNOWN(2147483647);

    private final int representation;

    UserRequestType(final int representation)
    {
         this.representation = representation;
    }

    public final int representation() { return representation; }

    private static final IntHashSet intSet = new IntHashSet(8);
        static
    {
        intSet.add(1);
        intSet.add(2);
        intSet.add(3);
        intSet.add(4);
    }



    public static boolean isValid(final int representation)
    {
        return intSet.contains(representation);
    }
    public static UserRequestType decode(final int representation)
    {
        switch(representation)
        {
        case 1: return LogOnUser;
        case 2: return LogOffUser;
        case 3: return ChangePasswordForUser;
        case 4: return RequestIndividualUserStatus;
        default:
            return ARTIO_UNKNOWN;
        }
    }
}
