/* Generated Fix Gateway message codec */
package uk.co.real_logic.artio.other;

import uk.co.real_logic.artio.dictionary.CharArrayMap;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import org.agrona.collections.IntHashSet;
import java.util.Map;
import java.util.HashMap;
import uk.co.real_logic.artio.builder.CharRepresentable;
public enum OrdStatus implements CharRepresentable
{
    NEW('0'),
    FILLED('2'),
    CANCELED('4'),
    NULL_VAL(''),
    ARTIO_UNKNOWN('');

    private final char representation;

    OrdStatus(final char representation)
    {
         this.representation = representation;
    }

    public final char representation() { return representation; }

    private static final IntHashSet intSet = new IntHashSet(6);
        static
    {
        intSet.add('0');
        intSet.add('2');
        intSet.add('4');
    }



    public static boolean isValid(final int representation)
    {
        return intSet.contains(representation);
    }
    public static OrdStatus decode(final int representation)
    {
        switch(representation)
        {
        case '0': return NEW;
        case '2': return FILLED;
        case '4': return CANCELED;
        default:
            return ARTIO_UNKNOWN;
        }
    }
}
