/* Generated Fix Gateway message codec */
package uk.co.real_logic.artio.decoder;

import org.agrona.AsciiNumberFormatException;
import org.agrona.MutableDirectBuffer;
import org.agrona.AsciiSequenceView;
import static uk.co.real_logic.artio.dictionary.generation.CodecUtil.*;
import static uk.co.real_logic.artio.dictionary.SessionConstants.*;
import uk.co.real_logic.artio.builder.Decoder;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.decoder.TrailerDecoder;
import uk.co.real_logic.artio.fields.ReadOnlyDecimalFloat;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.fields.LocalMktDateEncoder;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.dictionary.CharArraySet;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.IntHashSet.IntIterator;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.CommonDecoderImpl;
import static java.nio.charset.StandardCharsets.US_ASCII;
import static uk.co.real_logic.artio.builder.Validation.CODEC_VALIDATION_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED;
import uk.co.real_logic.artio.*;
import uk.co.real_logic.artio.builder.BusinessMessageRejectEncoder;


public class BusinessMessageRejectDecoder extends CommonDecoderImpl implements MessageDecoder
{
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(4);

    {
        if (CODEC_VALIDATION_ENABLED)
        {
            REQUIRED_FIELDS.add(Constants.REF_MSG_TYPE);
            REQUIRED_FIELDS.add(Constants.BUSINESS_REJECT_REASON);
        }
    }

    private final IntHashSet alreadyVisitedFields = new IntHashSet(10);

    private final IntHashSet unknownFields = new IntHashSet(10);

    private final IntHashSet missingRequiredFields = new IntHashSet(4);

    public boolean validate()
    {
        if (rejectReason != Decoder.NO_ERROR)
        {
            return false;
        }
        final IntIterator missingFieldsIterator = missingRequiredFields.iterator();
        final IntIterator unknownFieldsIterator = unknownFields.iterator();
        if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext())
        {
            invalidTagId = unknownFieldsIterator.nextValue();
            rejectReason = Constants.ALL_FIELDS.contains(invalidTagId) ? 2 : 0;
            return false;
        }
        if (!header.validate())
        {
            invalidTagId = header.invalidTagId();
            rejectReason = header.rejectReason();
            return false;
        }
        else if (!trailer.validate())
        {
            invalidTagId = trailer.invalidTagId();
            rejectReason = trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext())
        {
            invalidTagId = missingFieldsIterator.nextValue();
            rejectReason = 1;
            return false;
        }
        return true;
    }

    public static final long MESSAGE_TYPE = 106L;

    public static final String MESSAGE_TYPE_AS_STRING = "j";

    public static final char[] MESSAGE_TYPE_CHARS = MESSAGE_TYPE_AS_STRING.toCharArray();

    public static final byte[] MESSAGE_TYPE_BYTES = MESSAGE_TYPE_AS_STRING.getBytes(US_ASCII);

    public final IntHashSet messageFields = new IntHashSet(42);

    {
        messageFields.add(Constants.BEGIN_STRING);
        messageFields.add(Constants.BODY_LENGTH);
        messageFields.add(Constants.MSG_TYPE);
        messageFields.add(Constants.SENDER_COMP_ID);
        messageFields.add(Constants.TARGET_COMP_ID);
        messageFields.add(Constants.MSG_SEQ_NUM);
        messageFields.add(Constants.SENDER_SUB_ID);
        messageFields.add(Constants.SENDER_LOCATION_ID);
        messageFields.add(Constants.TARGET_SUB_ID);
        messageFields.add(Constants.TARGET_LOCATION_ID);
        messageFields.add(Constants.POSS_DUP_FLAG);
        messageFields.add(Constants.POSS_RESEND);
        messageFields.add(Constants.SENDING_TIME);
        messageFields.add(Constants.ORIG_SENDING_TIME);
        messageFields.add(Constants.LAST_MSG_SEQ_NUM_PROCESSED);
        messageFields.add(Constants.REF_SEQ_NUM);
        messageFields.add(Constants.REF_MSG_TYPE);
        messageFields.add(Constants.BUSINESS_REJECT_REF_ID);
        messageFields.add(Constants.BUSINESS_REJECT_REASON);
        messageFields.add(Constants.TEXT);
        messageFields.add(Constants.CHECK_SUM);
    }

    private final TrailerDecoder trailer = new TrailerDecoder();

    public TrailerDecoder trailer()
    {
        return trailer;
    }

    private final HeaderDecoder header = new HeaderDecoder(trailer);

    public HeaderDecoder header()
    {
        return header;
    }

    private int refSeqNum = MISSING_INT;

    private boolean hasRefSeqNum;

    public int refSeqNum()
    {
        if (!hasRefSeqNum)
        {
            throw new IllegalArgumentException("No value for optional field: RefSeqNum");
        }

        return refSeqNum;
    }

    public boolean hasRefSeqNum()
    {
        return hasRefSeqNum;
    }



    private char[] refMsgType = new char[1];

    public char[] refMsgType()
    {
        return refMsgType;
    }


    private int refMsgTypeOffset;

    private int refMsgTypeLength;

    public int refMsgTypeLength()
    {
        return refMsgTypeLength;
    }

    public String refMsgTypeAsString()
    {
        return new String(refMsgType, 0, refMsgTypeLength);
    }

    public void refMsgType(final AsciiSequenceView view)
    {
        view.wrap(buffer, refMsgTypeOffset, refMsgTypeLength);
    }


    private final CharArrayWrapper refMsgTypeWrapper = new CharArrayWrapper();
    private char[] businessRejectRefID = new char[1];

    private boolean hasBusinessRejectRefID;

    public char[] businessRejectRefID()
    {
        if (!hasBusinessRejectRefID)
        {
            throw new IllegalArgumentException("No value for optional field: BusinessRejectRefID");
        }

        return businessRejectRefID;
    }

    public boolean hasBusinessRejectRefID()
    {
        return hasBusinessRejectRefID;
    }


    private int businessRejectRefIDOffset;

    private int businessRejectRefIDLength;

    public int businessRejectRefIDLength()
    {
        if (!hasBusinessRejectRefID)
        {
            throw new IllegalArgumentException("No value for optional field: BusinessRejectRefID");
        }

        return businessRejectRefIDLength;
    }

    public String businessRejectRefIDAsString()
    {
        return hasBusinessRejectRefID ? new String(businessRejectRefID, 0, businessRejectRefIDLength) : null;
    }

    public void businessRejectRefID(final AsciiSequenceView view)
    {
        if (!hasBusinessRejectRefID)
        {
            throw new IllegalArgumentException("No value for optional field: BusinessRejectRefID");
        }

        view.wrap(buffer, businessRejectRefIDOffset, businessRejectRefIDLength);
    }


    private final CharArrayWrapper businessRejectRefIDWrapper = new CharArrayWrapper();
    private int businessRejectReason = MISSING_INT;

    public int businessRejectReason()
    {
        return businessRejectReason;
    }



    private char[] text = new char[1];

    private boolean hasText;

    public char[] text()
    {
        if (!hasText)
        {
            throw new IllegalArgumentException("No value for optional field: Text");
        }

        return text;
    }

    public boolean hasText()
    {
        return hasText;
    }


    private int textOffset;

    private int textLength;

    public int textLength()
    {
        if (!hasText)
        {
            throw new IllegalArgumentException("No value for optional field: Text");
        }

        return textLength;
    }

    public String textAsString()
    {
        return hasText ? new String(text, 0, textLength) : null;
    }

    public void text(final AsciiSequenceView view)
    {
        if (!hasText)
        {
            throw new IllegalArgumentException("No value for optional field: Text");
        }

        view.wrap(buffer, textOffset, textLength);
    }


    private final CharArrayWrapper textWrapper = new CharArrayWrapper();
    public int decode(final AsciiBuffer buffer, final int offset, final int length)
    {
        // Decode BusinessMessageReject
        int seenFieldCount = 0;
        if (CODEC_VALIDATION_ENABLED)
        {
            missingRequiredFields.copy(REQUIRED_FIELDS);
            alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        final int end = offset + length;
        int position = offset;
        position += header.decode(buffer, position, length);
        int tag;

        while (position < end)
        {
            final int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == AsciiBuffer.UNKNOWN_INDEX)
            {
               return position;
            }
            tag = buffer.getInt(position, equalsPosition);
            final int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, START_OF_HEADER);
            if (endOfField == AsciiBuffer.UNKNOWN_INDEX || equalsPosition == AsciiBuffer.UNKNOWN_INDEX)
            {
                rejectReason = 5;
                break;
            }
            final int valueLength = endOfField - valueOffset;
            if (CODEC_VALIDATION_ENABLED)
            {
                if (tag <= 0)
                {
                    invalidTagId = tag;
                    rejectReason = 0;
                }
                else if (valueLength == 0)
                {
                    invalidTagId = tag;
                    rejectReason = 4;
                }
                if (!alreadyVisitedFields.add(tag))
                {
                    invalidTagId = tag;
                    rejectReason = 13;
                }
                missingRequiredFields.remove(tag);
                seenFieldCount++;
            }

            switch (tag)
            {
            case Constants.REF_SEQ_NUM:
                hasRefSeqNum = true;
                refSeqNum = getInt(buffer, valueOffset, endOfField, 45, CODEC_VALIDATION_ENABLED);
                break;

            case Constants.REF_MSG_TYPE:
                refMsgType = buffer.getChars(refMsgType, valueOffset, valueLength);
                refMsgTypeOffset = valueOffset;
                refMsgTypeLength = valueLength;
                break;

            case Constants.BUSINESS_REJECT_REF_ID:
                hasBusinessRejectRefID = true;
                businessRejectRefID = buffer.getChars(businessRejectRefID, valueOffset, valueLength);
                businessRejectRefIDOffset = valueOffset;
                businessRejectRefIDLength = valueLength;
                break;

            case Constants.BUSINESS_REJECT_REASON:
                businessRejectReason = getInt(buffer, valueOffset, endOfField, 380, CODEC_VALIDATION_ENABLED);
                break;

            case Constants.TEXT:
                hasText = true;
                text = buffer.getChars(text, valueOffset, valueLength);
                textOffset = valueOffset;
                textLength = valueLength;
                break;

            default:
                if (!CODEC_REJECT_UNKNOWN_FIELD_ENABLED)
                {
                    alreadyVisitedFields.remove(tag);
                }
                else
                {
                    if (!(trailer.REQUIRED_FIELDS.contains(tag)))
                    {
                        unknownFields.add(tag);
                    }
                }
                if (CODEC_REJECT_UNKNOWN_FIELD_ENABLED || (trailer.REQUIRED_FIELDS.contains(tag)))
                {
                    position += trailer.decode(buffer, position, end - position);
                    return position - offset;
                }

            }

            if (position < (endOfField + 1))
            {
                position = endOfField + 1;
            }
        }
        position += trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset()
    {
        header.reset();
        trailer.reset();
        resetMessage();
        buffer = null;
        if (CODEC_VALIDATION_ENABLED)
        {
            invalidTagId = Decoder.NO_ERROR;
            rejectReason = Decoder.NO_ERROR;
            missingRequiredFields.clear();
            unknownFields.clear();
            alreadyVisitedFields.clear();
        }
    }

    public void resetMessage()
    {
        this.resetRefSeqNum();
        this.resetRefMsgType();
        this.resetBusinessRejectRefID();
        this.resetBusinessRejectReason();
        this.resetText();
    }

    public void resetRefSeqNum()
    {
        hasRefSeqNum = false;
    }

    public void resetRefMsgType()
    {
        refMsgTypeOffset = 0;
        refMsgTypeLength = 0;
    }

    public void resetBusinessRejectRefID()
    {
        hasBusinessRejectRefID = false;
    }

    public void resetBusinessRejectReason()
    {
        businessRejectReason = MISSING_INT;
    }

    public void resetText()
    {
        hasText = false;
    }

    public String toString()
    {
        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        return appendTo(builder, 1);
    }

    public StringBuilder appendTo(final StringBuilder builder, final int level)
    {
        builder.append("{\n");        indent(builder, level);
        builder.append("\"MessageName\": \"BusinessMessageReject\",\n");
        builder.append("  \"header\": ");
        header.appendTo(builder, level + 1);
        builder.append("\n");
        if (hasRefSeqNum())
        {
            indent(builder, level);
            builder.append("\"RefSeqNum\": \"");
            builder.append(refSeqNum);
            builder.append("\",\n");
        }

        indent(builder, level);
        builder.append("\"RefMsgType\": \"");
        builder.append(this.refMsgType(), 0, refMsgTypeLength());
        builder.append("\",\n");

        if (hasBusinessRejectRefID())
        {
            indent(builder, level);
            builder.append("\"BusinessRejectRefID\": \"");
            builder.append(this.businessRejectRefID(), 0, businessRejectRefIDLength());
            builder.append("\",\n");
        }

        indent(builder, level);
        builder.append("\"BusinessRejectReason\": \"");
        builder.append(businessRejectReason);
        builder.append("\",\n");

        if (hasText())
        {
            indent(builder, level);
            builder.append("\"Text\": \"");
            builder.append(this.text(), 0, textLength());
            builder.append("\",\n");
        }
        indent(builder, level - 1);
        builder.append("}");
        return builder;
    }

    /**
     * {@inheritDoc}
     */
    public BusinessMessageRejectEncoder toEncoder(final Encoder encoder)
    {
        return toEncoder((BusinessMessageRejectEncoder)encoder);
    }

    public BusinessMessageRejectEncoder toEncoder(final BusinessMessageRejectEncoder encoder)
    {
        encoder.reset();
        if (hasRefSeqNum())
        {
            encoder.refSeqNum(this.refSeqNum());
        }

        encoder.refMsgType(this.refMsgType(), 0, refMsgTypeLength());
        if (hasBusinessRejectRefID())
        {
            encoder.businessRejectRefID(this.businessRejectRefID(), 0, businessRejectRefIDLength());
        }

        encoder.businessRejectReason(this.businessRejectReason());
        if (hasText())
        {
            encoder.text(this.text(), 0, textLength());
        }
        return encoder;
    }

}
