/* Generated Fix Gateway message codec */
package uk.co.real_logic.artio.builder;

import org.agrona.MutableDirectBuffer;
import org.agrona.AsciiSequenceView;
import static uk.co.real_logic.artio.dictionary.generation.CodecUtil.*;
import static uk.co.real_logic.artio.dictionary.SessionConstants.*;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.fields.LocalMktDateEncoder;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import uk.co.real_logic.artio.dictionary.CharArraySet;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.IntHashSet.IntIterator;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.AsciiSequenceView;
import static java.nio.charset.StandardCharsets.US_ASCII;
import static uk.co.real_logic.artio.builder.Validation.CODEC_VALIDATION_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED;
import static uk.co.real_logic.artio.builder.RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED;
import uk.co.real_logic.artio.*;


public class InstrumentEncoder
{
    private static final int symbolHeaderLength = 3;
    private static final byte[] symbolHeader = new byte[] {53, 53, (byte) '='};

    private final MutableDirectBuffer symbol = new UnsafeBuffer();

    private int symbolOffset = 0;

    private int symbolLength = 0;

    public InstrumentEncoder symbol(final DirectBuffer value, final int offset, final int length)
    {
        symbol.wrap(value);
        symbolOffset = offset;
        symbolLength = length;
        return this;
    }

    public InstrumentEncoder symbol(final DirectBuffer value, final int length)
    {
        return symbol(value, 0, length);
    }

    public InstrumentEncoder symbol(final DirectBuffer value)
    {
        return symbol(value, 0, value.capacity());
    }

    public InstrumentEncoder symbol(final byte[] value, final int offset, final int length)
    {
        symbol.wrap(value);
        symbolOffset = offset;
        symbolLength = length;
        return this;
    }

    public InstrumentEncoder symbolAsCopy(final byte[] value, final int offset, final int length)
    {
        copyInto(symbol, value, offset, length);
        symbolOffset = offset;
        symbolLength = length;
        return this;
    }

    public InstrumentEncoder symbol(final byte[] value, final int length)
    {
        return symbol(value, 0, length);
    }

    public InstrumentEncoder symbol(final byte[] value)
    {
        return symbol(value, 0, value.length);
    }

    public boolean hasSymbol()
    {
        return symbolLength > 0;
    }

    public MutableDirectBuffer symbol()
    {
        return symbol;
    }

    public String symbolAsString()
    {
        return symbol.getStringWithoutLengthAscii(symbolOffset, symbolLength);
    }

    public InstrumentEncoder symbol(final CharSequence value)
    {
        toBytes(value, symbol);
        symbolOffset = 0;
        symbolLength = value.length();
        return this;
    }

    public InstrumentEncoder symbol(final AsciiSequenceView value)
    {
        final DirectBuffer buffer = value.buffer();
        if (buffer != null)
        {
            symbol.wrap(buffer);
            symbolOffset = value.offset();
            symbolLength = value.length();
        }
        return this;
    }

    public InstrumentEncoder symbol(final char[] value)
    {
        return symbol(value, 0, value.length);
    }

    public InstrumentEncoder symbol(final char[] value, final int length)
    {
        return symbol(value, 0, length);
    }

    public InstrumentEncoder symbol(final char[] value, final int offset, final int length)
    {
        toBytes(value, symbol, offset, length);
        symbolOffset = 0;
        symbolLength = length;
        return this;
    }

    public int encode(final MutableAsciiBuffer buffer, final int offset)
    {
        int position = offset;

        if (symbolLength > 0)
        {
            buffer.putBytes(position, symbolHeader, 0, symbolHeaderLength);
            position += symbolHeaderLength;
            buffer.putBytes(position, symbol, symbolOffset, symbolLength);
            position += symbolLength;
            buffer.putSeparator(position);
            position++;
        }
        else if (CODEC_VALIDATION_ENABLED)
        {
            throw new EncodingException("Missing Field: Symbol");
        }
        return position - offset;
    }

    public void reset()
    {
        this.resetSymbol();
    }

    public void resetSymbol()
    {
        symbolLength = 0;
    }

    public String toString()
    {
        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        return appendTo(builder, 1);
    }

    public StringBuilder appendTo(final StringBuilder builder, final int level)
    {
        builder.append("{\n");        indent(builder, level);
        builder.append("\"MessageName\": \"Instrument\",\n");
        if (hasSymbol())
        {
            indent(builder, level);
            builder.append("\"Symbol\": \"");
            appendBuffer(builder, symbol, symbolOffset, symbolLength);
            builder.append("\",\n");
        }
        indent(builder, level - 1);
        builder.append("}");
        return builder;
    }

    /**
     * {@inheritDoc}
     */
    public InstrumentEncoder copyTo(final Encoder encoder)
    {
        return copyTo((InstrumentEncoder)encoder);
    }

    public InstrumentEncoder copyTo(final InstrumentEncoder encoder)
    {
        encoder.reset();
        if (hasSymbol())
        {
            encoder.symbolAsCopy(symbol.byteArray(), 0, symbolLength);
        }
        return encoder;
    }

}
